﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/iotevents-data/IoTEventsDataRequest.h>
#include <aws/iotevents-data/IoTEventsData_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Http {
class URI;
}  // namespace Http
namespace IoTEventsData {
namespace Model {

/**
 */
class ListDetectorsRequest : public IoTEventsDataRequest {
 public:
  AWS_IOTEVENTSDATA_API ListDetectorsRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "ListDetectors"; }

  AWS_IOTEVENTSDATA_API Aws::String SerializePayload() const override;

  AWS_IOTEVENTSDATA_API void AddQueryStringParameters(Aws::Http::URI& uri) const override;

  ///@{
  /**
   * <p>The name of the detector model whose detectors (instances) are listed.</p>
   */
  inline const Aws::String& GetDetectorModelName() const { return m_detectorModelName; }
  inline bool DetectorModelNameHasBeenSet() const { return m_detectorModelNameHasBeenSet; }
  template <typename DetectorModelNameT = Aws::String>
  void SetDetectorModelName(DetectorModelNameT&& value) {
    m_detectorModelNameHasBeenSet = true;
    m_detectorModelName = std::forward<DetectorModelNameT>(value);
  }
  template <typename DetectorModelNameT = Aws::String>
  ListDetectorsRequest& WithDetectorModelName(DetectorModelNameT&& value) {
    SetDetectorModelName(std::forward<DetectorModelNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A filter that limits results to those detectors (instances) in the given
   * state.</p>
   */
  inline const Aws::String& GetStateName() const { return m_stateName; }
  inline bool StateNameHasBeenSet() const { return m_stateNameHasBeenSet; }
  template <typename StateNameT = Aws::String>
  void SetStateName(StateNameT&& value) {
    m_stateNameHasBeenSet = true;
    m_stateName = std::forward<StateNameT>(value);
  }
  template <typename StateNameT = Aws::String>
  ListDetectorsRequest& WithStateName(StateNameT&& value) {
    SetStateName(std::forward<StateNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The token that you can use to return the next set of results.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  inline bool NextTokenHasBeenSet() const { return m_nextTokenHasBeenSet; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListDetectorsRequest& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The maximum number of results to be returned per request.</p>
   */
  inline int GetMaxResults() const { return m_maxResults; }
  inline bool MaxResultsHasBeenSet() const { return m_maxResultsHasBeenSet; }
  inline void SetMaxResults(int value) {
    m_maxResultsHasBeenSet = true;
    m_maxResults = value;
  }
  inline ListDetectorsRequest& WithMaxResults(int value) {
    SetMaxResults(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_detectorModelName;

  Aws::String m_stateName;

  Aws::String m_nextToken;

  int m_maxResults{0};
  bool m_detectorModelNameHasBeenSet = false;
  bool m_stateNameHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_maxResultsHasBeenSet = false;
};

}  // namespace Model
}  // namespace IoTEventsData
}  // namespace Aws
