/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.output.xsd;

import com.thaiopensource.relaxng.output.common.Name;
import com.thaiopensource.relaxng.output.xsd.Guide;
import com.thaiopensource.relaxng.output.xsd.SourceUriGenerator;
import com.thaiopensource.relaxng.output.xsd.basic.Attribute;
import com.thaiopensource.relaxng.output.xsd.basic.Definition;
import com.thaiopensource.relaxng.output.xsd.basic.Element;
import com.thaiopensource.relaxng.output.xsd.basic.GroupDefinition;
import com.thaiopensource.relaxng.output.xsd.basic.GroupRef;
import com.thaiopensource.relaxng.output.xsd.basic.Include;
import com.thaiopensource.relaxng.output.xsd.basic.Particle;
import com.thaiopensource.relaxng.output.xsd.basic.ParticleChoice;
import com.thaiopensource.relaxng.output.xsd.basic.Schema;
import com.thaiopensource.relaxng.output.xsd.basic.SchemaWalker;
import com.thaiopensource.relaxng.output.xsd.basic.Structure;
import com.thaiopensource.relaxng.output.xsd.basic.Wildcard;
import com.thaiopensource.relaxng.output.xsd.basic.WildcardAttribute;
import com.thaiopensource.relaxng.output.xsd.basic.WildcardElement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class NamespaceManager {
    private final Schema schema;
    private final Map elementNameMap = new HashMap();
    private final Map attributeNameMap = new HashMap();
    private final Map substitutionGroupMap = new HashMap();
    private final Map groupDefinitionAbstractElementMap = new HashMap();
    private final Map abstractElementSubstitutionGroupMemberMap = new HashMap();
    private final Map sourceUriMap = new HashMap();
    private final Map targetNamespaceMap = new HashMap();

    NamespaceManager(Schema schema, Guide guide, SourceUriGenerator sourceUriGenerator) {
        this.schema = schema;
        new IncludeFinder(schema);
        schema.accept(new RootMarker());
        this.assignTargetNamespaces();
        new GlobalElementSelector(schema);
        this.findSubstitutionGroups(guide);
        this.chooseRootSchemas(sourceUriGenerator);
        schema.accept(new StructureMover(this.getTargetNamespace(schema.getUri())));
    }

    private void assignTargetNamespaces() {
        new TargetNamespaceSelector(this.schema);
        String string = this.filterUpTargetNamespace(this.schema.getUri());
        if (string == null) {
            this.lookupTargetNamespace("");
            this.lookupSourceUri((String)this.schema.getUri()).targetNamespace = "";
            string = "";
        }
        this.inheritDownTargetNamespace(this.schema.getUri(), string);
    }

    private String filterUpTargetNamespace(String string) {
        Object object;
        String string2 = this.getTargetNamespace(string);
        if (string2 != null) {
            return string2;
        }
        List list = this.lookupSourceUri((String)string).includes;
        if (list.size() == 0) {
            return null;
        }
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object = this.filterUpTargetNamespace((String)iterator.next());
            if (object == null) continue;
            Integer n = (Integer)hashMap.get(object);
            hashMap.put((String)object, new Integer(n == null ? 1 : n + 1));
        }
        object = null;
        boolean bl = false;
        Iterator iterator2 = hashMap.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry = iterator2.next();
            if (object == null || (Integer)entry.getValue() > (Integer)object.getValue()) {
                object = entry;
                bl = false;
                continue;
            }
            if (((Integer)entry.getValue()).intValue() != ((Integer)object.getValue()).intValue()) continue;
            bl = true;
        }
        if (object == null || bl) {
            return null;
        }
        this.lookupSourceUri((String)string).targetNamespace = string2 = (String)object.getKey();
        return string2;
    }

    private void inheritDownTargetNamespace(String string, String string2) {
        Iterator iterator = this.lookupSourceUri((String)string).includes.iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            String string4 = this.lookupSourceUri((String)string3).targetNamespace;
            if (string4 == null) {
                this.lookupSourceUri((String)string3).targetNamespace = string4 = string2;
            }
            this.inheritDownTargetNamespace(string3, string4);
        }
    }

    private void chooseRootSchemas(SourceUriGenerator sourceUriGenerator) {
        Iterator iterator = this.targetNamespaceMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            Vector vector = new Vector();
            this.findRootSchemas(this.schema.getUri(), string, vector);
            if (vector.size() == 1) {
                ((TargetNamespace)entry.getValue()).rootSchema = (String)vector.get(0);
                continue;
            }
            String string2 = sourceUriGenerator.generateSourceUri(string);
            this.lookupSourceUri((String)string2).includes.addAll(vector);
            this.lookupSourceUri((String)string2).targetNamespace = string;
            ((TargetNamespace)entry.getValue()).rootSchema = string2;
            this.schema.addInclude(string2, this.schema.getEncoding(), null, null);
        }
    }

    boolean isGlobal(Element element) {
        return element.equals(this.lookupElementName((Name)element.getName()).globalType);
    }

    Element getGlobalElement(Name name) {
        NameInfo nameInfo = (NameInfo)this.elementNameMap.get(name);
        if (nameInfo == null) {
            return null;
        }
        return (Element)nameInfo.globalType;
    }

    boolean isGlobal(Attribute attribute) {
        return attribute.equals(this.lookupAttributeName((Name)attribute.getName()).globalType);
    }

    String getProxyName(Structure structure) {
        String string = structure.getName().getNamespaceUri();
        TargetNamespace targetNamespace = this.lookupTargetNamespace(string);
        String string2 = (String)targetNamespace.movedStructureNameMap.get(structure);
        if (string2 == null) {
            string2 = this.generateName(string, targetNamespace, structure.getName().getLocalName(), structure instanceof Element);
            targetNamespace.movedStructureNameMap.put(structure, string2);
        }
        return string2;
    }

    String getOtherElementName(String string) {
        TargetNamespace targetNamespace = this.lookupTargetNamespace(string);
        if (!targetNamespace.movedOtherElement) {
            return null;
        }
        if (targetNamespace.otherElementName == null) {
            targetNamespace.otherElementName = this.generateName(string, targetNamespace, "local", true);
        }
        return targetNamespace.otherElementName;
    }

    String getOtherAttributeName(String string) {
        TargetNamespace targetNamespace = this.lookupTargetNamespace(string);
        if (!targetNamespace.movedOtherAttribute) {
            return null;
        }
        if (targetNamespace.otherAttributeName == null) {
            targetNamespace.otherAttributeName = this.generateName(string, targetNamespace, "local", false);
        }
        return targetNamespace.otherAttributeName;
    }

    private String generateName(String string, TargetNamespace targetNamespace, String string2, boolean bl) {
        Definition definition;
        Set set = bl ? targetNamespace.movedElementNameSet : targetNamespace.movedAttributeNameSet;
        String string3 = string2;
        int n = 1;
        while (set.contains(string3) || (definition = bl ? this.schema.getGroup(string3) : this.schema.getAttributeGroup(string3)) != null && this.getTargetNamespace(definition.getParentSchema().getUri()).equals(string) && (!(definition instanceof GroupDefinition) || this.getElementNameForGroupRef((GroupDefinition)definition) == null)) {
            string3 = string2 + Integer.toString(n);
            ++n;
        }
        set.add(string3);
        return string3;
    }

    private void findSubstitutionGroups(Guide guide) {
        List list = GroupDefinitionFinder.findGroupDefinitions(this.schema);
        HashMap hashMap = new HashMap();
        while (this.addAbstractElements(guide, list, hashMap)) {
        }
        this.cleanSubstitutionGroupMap(hashMap);
        this.cleanAbstractElementSubstitutionGroupMemberMap(hashMap);
    }

    private boolean addAbstractElements(Guide guide, List list, Map map) {
        Name name;
        Object object;
        HashSet hashSet = new HashSet();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            List list2;
            object = (GroupDefinition)iterator.next();
            if (!guide.getGroupEnableAbstractElement(((Definition)object).getName()) || this.getGroupDefinitionAbstractElementName((GroupDefinition)object) != null || (name = this.abstractElementName((GroupDefinition)object)) == null || (list2 = this.substitutionGroupMembers((GroupDefinition)object)) == null) continue;
            map.put(name, ((Definition)object).getName());
            this.addSubstitutionGroup(name, list2, hashSet);
        }
        if (hashSet.size() == 0) {
            return false;
        }
        object = hashSet.iterator();
        while (object.hasNext()) {
            name = (Name)object.next();
            this.groupDefinitionAbstractElementMap.put(map.get(name), name);
        }
        return true;
    }

    private void addSubstitutionGroup(Name name, List list, Set set) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Name name2 = (Name)iterator.next();
            Name name3 = this.getSubstitutionGroup(name2);
            if (name3 != null && !name3.equals(name)) {
                set.remove(name3);
                return;
            }
            this.substitutionGroupMap.put(name2, name);
        }
        set.add(name);
        this.abstractElementSubstitutionGroupMemberMap.put(name, list);
    }

    private void cleanSubstitutionGroupMap(Map map) {
        Iterator iterator = this.substitutionGroupMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Name name = (Name)entry.getValue();
            if (this.groupDefinitionAbstractElementMap.get(map.get(name)) != null) continue;
            iterator.remove();
        }
    }

    private void cleanAbstractElementSubstitutionGroupMemberMap(Map map) {
        Iterator iterator = this.abstractElementSubstitutionGroupMemberMap.keySet().iterator();
        while (iterator.hasNext()) {
            if (this.groupDefinitionAbstractElementMap.get(map.get(iterator.next())) != null) continue;
            iterator.remove();
        }
    }

    private Name abstractElementName(GroupDefinition groupDefinition) {
        Name name = new Name(this.getTargetNamespace(groupDefinition.getParentSchema().getUri()), groupDefinition.getName());
        if (this.lookupElementName((Name)name).globalType != null) {
            return null;
        }
        return name;
    }

    private List substitutionGroupMembers(GroupDefinition groupDefinition) {
        if (groupDefinition.getParticle() instanceof Element) {
            return null;
        }
        Vector vector = new Vector();
        if (!this.particleMembers(groupDefinition.getParticle(), vector)) {
            return null;
        }
        return vector;
    }

    private boolean particleMembers(Particle particle, List list) {
        if (particle instanceof Element) {
            Element element = (Element)particle;
            if (!this.isGlobal(element)) {
                return false;
            }
            list.add(element.getName());
        } else if (particle instanceof GroupRef) {
            Name name = this.getElementNameForGroupRef(this.schema.getGroup(((GroupRef)particle).getName()));
            if (name == null) {
                return false;
            }
            list.add(name);
        } else if (particle instanceof ParticleChoice) {
            Iterator iterator = ((ParticleChoice)particle).getChildren().iterator();
            while (iterator.hasNext()) {
                if (this.particleMembers((Particle)iterator.next(), list)) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    Name getElementNameForGroupRef(GroupDefinition groupDefinition) {
        Name name = this.getGroupDefinitionAbstractElementName(groupDefinition);
        if (name != null) {
            return name;
        }
        return this.getGroupDefinitionSingleElementName(groupDefinition);
    }

    boolean isGroupDefinitionOmitted(GroupDefinition groupDefinition) {
        return this.getGroupDefinitionSingleElementName(groupDefinition) != null;
    }

    Name getGroupDefinitionAbstractElementName(GroupDefinition groupDefinition) {
        return (Name)this.groupDefinitionAbstractElementMap.get(groupDefinition.getName());
    }

    List getAbstractElementSubstitutionGroupMembers(Name name) {
        return (List)this.abstractElementSubstitutionGroupMemberMap.get(name);
    }

    private Name getGroupDefinitionSingleElementName(GroupDefinition groupDefinition) {
        Particle particle = groupDefinition.getParticle();
        if (!(particle instanceof Element) || !this.isGlobal((Element)particle)) {
            return null;
        }
        return ((Element)particle).getName();
    }

    Name getSubstitutionGroup(Name name) {
        return (Name)this.substitutionGroupMap.get(name);
    }

    String getTargetNamespace(String string) {
        return this.lookupSourceUri((String)string).targetNamespace;
    }

    boolean isTargetNamespace(String string) {
        return this.targetNamespaceMap.get(string) != null;
    }

    Set getTargetNamespaces() {
        return this.targetNamespaceMap.keySet();
    }

    String getRootSchema(String string) {
        return this.lookupTargetNamespace((String)string).rootSchema;
    }

    List getMovedStructures(String string) {
        return this.lookupTargetNamespace((String)string).movedStructures;
    }

    List effectiveIncludes(String string) {
        String string2 = this.getTargetNamespace(string);
        Vector vector = new Vector();
        Iterator iterator = this.lookupSourceUri((String)string).includes.iterator();
        while (iterator.hasNext()) {
            this.findRootSchemas((String)iterator.next(), string2, vector);
        }
        return vector;
    }

    private void findRootSchemas(String string, String string2, List list) {
        if (this.getTargetNamespace(string).equals(string2)) {
            list.add(string);
        } else {
            Iterator iterator = this.lookupSourceUri((String)string).includes.iterator();
            while (iterator.hasNext()) {
                this.findRootSchemas((String)iterator.next(), string2, list);
            }
        }
    }

    private SourceUri lookupSourceUri(String string) {
        SourceUri sourceUri = (SourceUri)this.sourceUriMap.get(string);
        if (sourceUri == null) {
            sourceUri = new SourceUri();
            this.sourceUriMap.put(string, sourceUri);
        }
        return sourceUri;
    }

    private TargetNamespace lookupTargetNamespace(String string) {
        TargetNamespace targetNamespace = (TargetNamespace)this.targetNamespaceMap.get(string);
        if (targetNamespace == null) {
            targetNamespace = new TargetNamespace();
            this.targetNamespaceMap.put(string, targetNamespace);
        }
        return targetNamespace;
    }

    private NameInfo lookupElementName(Name name) {
        NameInfo nameInfo = (NameInfo)this.elementNameMap.get(name);
        if (nameInfo == null) {
            nameInfo = new NameInfo();
            this.elementNameMap.put(name, nameInfo);
        }
        return nameInfo;
    }

    private NameInfo lookupAttributeName(Name name) {
        NameInfo nameInfo = (NameInfo)this.attributeNameMap.get(name);
        if (nameInfo == null) {
            nameInfo = new NameInfo();
            this.attributeNameMap.put(name, nameInfo);
        }
        return nameInfo;
    }

    static String otherNamespace(Wildcard wildcard) {
        if (wildcard.isPositive()) {
            return null;
        }
        Set set = wildcard.getNamespaces();
        switch (set.size()) {
            case 2: {
                if (!set.contains("")) {
                    return null;
                }
                Iterator iterator = set.iterator();
                String string = (String)iterator.next();
                if (!string.equals("")) {
                    return string;
                }
                return (String)iterator.next();
            }
            case 1: {
                if (!set.contains("")) break;
                return "";
            }
        }
        return null;
    }

    static class GroupDefinitionFinder
    extends SchemaWalker {
        final List list = new Vector();

        GroupDefinitionFinder() {
        }

        public void visitGroup(GroupDefinition groupDefinition) {
            this.list.add(groupDefinition);
        }

        static List findGroupDefinitions(Schema schema) {
            GroupDefinitionFinder groupDefinitionFinder = new GroupDefinitionFinder();
            schema.accept(groupDefinitionFinder);
            return groupDefinitionFinder.list;
        }
    }

    class StructureMover
    extends SchemaWalker {
        private final String currentNamespace;

        StructureMover(String string) {
            this.currentNamespace = string;
        }

        public Object visitElement(Element element) {
            NameInfo nameInfo = NamespaceManager.this.lookupElementName(element.getName());
            String string = element.getName().getNamespaceUri();
            if (string.equals(this.currentNamespace) || string.equals("") && !element.equals(nameInfo.globalType)) {
                element.getComplexType().accept(this);
            } else {
                this.noteMoved(nameInfo, element);
                this.moveStructure(element);
                element.getComplexType().accept(new StructureMover(string));
            }
            return null;
        }

        public Object visitAttribute(Attribute attribute) {
            String string = attribute.getName().getNamespaceUri();
            if (!string.equals("") && !string.equals(this.currentNamespace)) {
                this.noteMoved(NamespaceManager.this.lookupAttributeName(attribute.getName()), attribute);
                this.moveStructure(attribute);
            }
            return null;
        }

        private void noteMoved(NameInfo nameInfo, Structure structure) {
            if (nameInfo.occur < 3) {
                nameInfo.occur = 3;
                nameInfo.globalType = structure;
            } else if (nameInfo.occur == 3 && !structure.equals(nameInfo.globalType)) {
                nameInfo.globalType = null;
            }
        }

        private void moveStructure(Structure structure) {
            TargetNamespace targetNamespace = NamespaceManager.this.lookupTargetNamespace(structure.getName().getNamespaceUri());
            if (!targetNamespace.movedStructureSet.contains(structure)) {
                targetNamespace.movedStructureSet.add(structure);
                targetNamespace.movedStructures.add(structure);
            }
        }

        public void visitInclude(Include include) {
            Schema schema = include.getIncludedSchema();
            schema.accept(new StructureMover(NamespaceManager.this.getTargetNamespace(schema.getUri())));
        }

        public Object visitWildcardElement(WildcardElement wildcardElement) {
            return this.visitWildcard(wildcardElement.getWildcard(), true);
        }

        public Object visitWildcardAttribute(WildcardAttribute wildcardAttribute) {
            return this.visitWildcard(wildcardAttribute.getWildcard(), false);
        }

        private Object visitWildcard(Wildcard wildcard, boolean bl) {
            String string = NamespaceManager.otherNamespace(wildcard);
            if (string != null && !string.equals(this.currentNamespace)) {
                TargetNamespace targetNamespace = NamespaceManager.this.lookupTargetNamespace(string);
                if (bl) {
                    targetNamespace.movedOtherElement = true;
                } else {
                    targetNamespace.movedOtherAttribute = true;
                }
            }
            return null;
        }
    }

    class GlobalElementSelector
    extends SchemaWalker {
        private final boolean absentTargetNamespace;
        private boolean nested = false;

        GlobalElementSelector(Schema schema) {
            this.absentTargetNamespace = NamespaceManager.this.getTargetNamespace(schema.getUri()).equals("");
            schema.accept(this);
        }

        public Object visitElement(Element element) {
            Name name = element.getName();
            if (!name.getNamespaceUri().equals("") || this.absentTargetNamespace) {
                int n;
                NameInfo nameInfo = NamespaceManager.this.lookupElementName(name);
                int n2 = n = this.nested ? 1 : 2;
                if (n > nameInfo.occur) {
                    nameInfo.occur = n;
                    nameInfo.globalType = element;
                } else if (n == nameInfo.occur && !element.equals(nameInfo.globalType)) {
                    nameInfo.globalType = null;
                }
            }
            boolean bl = this.nested;
            this.nested = true;
            element.getComplexType().accept(this);
            this.nested = bl;
            return null;
        }

        public void visitInclude(Include include) {
            new GlobalElementSelector(include.getIncludedSchema());
        }
    }

    class TargetNamespaceSelector
    extends SchemaWalker {
        private boolean nested;
        private final Map namespaceUsageMap = new HashMap();

        TargetNamespaceSelector(Schema schema) {
            schema.accept(this);
            ((NamespaceManager)NamespaceManager.this).lookupSourceUri((String)schema.getUri()).targetNamespace = this.selectTargetNamespace();
        }

        public Object visitElement(Element element) {
            NamespaceUsage namespaceUsage = this.getUsage(element.getName().getNamespaceUri());
            if (!this.nested) {
                ++namespaceUsage.elementCount;
            }
            boolean bl = this.nested;
            this.nested = true;
            element.getComplexType().accept(this);
            this.nested = bl;
            return null;
        }

        public Object visitAttribute(Attribute attribute) {
            NamespaceUsage namespaceUsage = this.getUsage(attribute.getName().getNamespaceUri());
            if (!this.nested) {
                ++namespaceUsage.attributeCount;
            }
            return null;
        }

        public Object visitWildcardElement(WildcardElement wildcardElement) {
            return this.visitWildcard(wildcardElement.getWildcard());
        }

        public Object visitWildcardAttribute(WildcardAttribute wildcardAttribute) {
            return this.visitWildcard(wildcardAttribute.getWildcard());
        }

        private Object visitWildcard(Wildcard wildcard) {
            String string = NamespaceManager.otherNamespace(wildcard);
            if (string != null) {
                NamespaceManager.this.lookupTargetNamespace(string);
                if (!this.nested) {
                    ++this.getUsage((String)string).attributeCount;
                }
            }
            return null;
        }

        private NamespaceUsage getUsage(String string) {
            NamespaceUsage namespaceUsage = (NamespaceUsage)this.namespaceUsageMap.get(string);
            if (namespaceUsage == null) {
                namespaceUsage = new NamespaceUsage();
                this.namespaceUsageMap.put(string, namespaceUsage);
                if (!string.equals("")) {
                    NamespaceManager.this.lookupTargetNamespace(string);
                }
            }
            return namespaceUsage;
        }

        public void visitInclude(Include include) {
            new TargetNamespaceSelector(include.getIncludedSchema());
        }

        String selectTargetNamespace() {
            Object object;
            Map.Entry entry = null;
            Iterator iterator = this.namespaceUsageMap.entrySet().iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                if (entry != null && !NamespaceUsage.isBetter((NamespaceUsage)object.getValue(), (NamespaceUsage)entry.getValue()) && (!object.getValue().equals(entry.getValue()) || ((String)object.getKey()).compareTo(entry.getKey()) >= 0)) continue;
                entry = object;
            }
            this.namespaceUsageMap.clear();
            if (entry == null) {
                return null;
            }
            object = (String)entry.getKey();
            NamespaceManager.this.lookupTargetNamespace((String)object);
            return object;
        }
    }

    static class NamespaceUsage {
        int elementCount;
        int attributeCount;

        NamespaceUsage() {
        }

        static boolean isBetter(NamespaceUsage namespaceUsage, NamespaceUsage namespaceUsage2) {
            return namespaceUsage.elementCount > namespaceUsage2.elementCount || namespaceUsage.elementCount == namespaceUsage2.elementCount && namespaceUsage.attributeCount > namespaceUsage2.attributeCount;
        }

        public boolean equals(Object object) {
            if (!(object instanceof NamespaceUsage)) {
                return false;
            }
            NamespaceUsage namespaceUsage = (NamespaceUsage)object;
            return this.elementCount == namespaceUsage.elementCount && this.attributeCount == namespaceUsage.attributeCount;
        }
    }

    class RootMarker
    extends SchemaWalker {
        RootMarker() {
        }

        public void visitGroup(GroupDefinition groupDefinition) {
        }

        public Object visitElement(Element element) {
            NameInfo nameInfo = NamespaceManager.this.lookupElementName(element.getName());
            nameInfo.globalType = element;
            nameInfo.occur = 4;
            NamespaceManager.this.lookupTargetNamespace(element.getName().getNamespaceUri());
            return null;
        }
    }

    class IncludeFinder
    extends SchemaWalker {
        private final SourceUri source;

        IncludeFinder(Schema schema) {
            this.source = NamespaceManager.this.lookupSourceUri(schema.getUri());
            schema.accept(this);
        }

        public void visitInclude(Include include) {
            Schema schema = include.getIncludedSchema();
            this.source.includes.add(schema.getUri());
            new IncludeFinder(schema);
        }
    }

    static class NameInfo {
        static final int OCCUR_NONE = 0;
        static final int OCCUR_NESTED = 1;
        static final int OCCUR_TOP = 2;
        static final int OCCUR_MOVE = 3;
        static final int OCCUR_ROOT = 4;
        int occur = 0;
        Structure globalType = null;

        NameInfo() {
        }
    }

    static class TargetNamespace {
        String rootSchema;
        final List movedStructures = new Vector();
        final Set movedStructureSet = new HashSet();
        final Map movedStructureNameMap = new HashMap();
        final Set movedElementNameSet = new HashSet();
        final Set movedAttributeNameSet = new HashSet();
        boolean movedOtherElement = false;
        boolean movedOtherAttribute = false;
        String otherElementName;
        String otherAttributeName;

        TargetNamespace() {
        }
    }

    static class SourceUri {
        String targetNamespace;
        final List includes = new Vector();

        SourceUri() {
        }
    }
}

