/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.main.collectors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.collectors.BytecodeMappingTracer;
import org.jetbrains.java.decompiler.util.TextBuffer;

public class BytecodeSourceMapper {
    private int offset_total;
    private final Map<String, Map<String, Map<Integer, Integer>>> mapping = new LinkedHashMap<String, Map<String, Map<Integer, Integer>>>();
    private final Map<Integer, Integer> linesMapping = new HashMap<Integer, Integer>();
    private final Set<Integer> unmappedLines = new TreeSet<Integer>();

    public void addMapping(String className, String methodName, int bytecodeOffset, int sourceLine) {
        Map class_mapping = this.mapping.computeIfAbsent(className, k -> new LinkedHashMap());
        Map method_mapping = class_mapping.computeIfAbsent(methodName, k -> new HashMap());
        method_mapping.putIfAbsent(bytecodeOffset, sourceLine);
    }

    public void addTracer(String className, String methodName, BytecodeMappingTracer tracer) {
        for (Map.Entry<Integer, Integer> entry : tracer.getMapping().entrySet()) {
            this.addMapping(className, methodName, entry.getKey(), entry.getValue());
        }
        this.linesMapping.putAll(tracer.getOriginalLinesMapping());
        this.unmappedLines.addAll(tracer.getUnmappedLines());
    }

    public void dumpMapping(TextBuffer buffer, boolean offsetsToHex) {
        if (this.mapping.isEmpty() && this.linesMapping.isEmpty()) {
            return;
        }
        String lineSeparator = DecompilerContext.getNewLineSeparator();
        for (Map.Entry<String, Map<String, Map<Integer, Integer>>> class_entry : this.mapping.entrySet()) {
            Map<String, Map<Integer, Integer>> class_mapping = class_entry.getValue();
            buffer.append("class '" + class_entry.getKey() + "' {" + lineSeparator);
            boolean is_first_method = true;
            for (Map.Entry<String, Map<Integer, Integer>> method_entry : class_mapping.entrySet()) {
                Map<Integer, Integer> method_mapping = method_entry.getValue();
                if (!is_first_method) {
                    buffer.appendLineSeparator();
                }
                buffer.appendIndent(1).append("method '" + method_entry.getKey() + "' {" + lineSeparator);
                ArrayList<Integer> lstBytecodeOffsets = new ArrayList<Integer>(method_mapping.keySet());
                Collections.sort(lstBytecodeOffsets);
                for (Integer offset : lstBytecodeOffsets) {
                    Integer line = method_mapping.get(offset);
                    String strOffset = offsetsToHex ? Integer.toHexString(offset) : line.toString();
                    buffer.appendIndent(2).append(strOffset).appendIndent(2).append(line + this.offset_total + lineSeparator);
                }
                buffer.appendIndent(1).append("}").appendLineSeparator();
                is_first_method = false;
            }
            buffer.append("}").appendLineSeparator().appendLineSeparator();
        }
        buffer.append("Lines mapping:").appendLineSeparator();
        TreeMap<Integer, Integer> sorted = new TreeMap<Integer, Integer>(this.linesMapping);
        for (Map.Entry entry : sorted.entrySet()) {
            buffer.append((Integer)entry.getKey()).append(" <-> ").append((Integer)entry.getValue() + this.offset_total + 1).appendLineSeparator();
        }
        if (!this.unmappedLines.isEmpty()) {
            buffer.append("Not mapped:").appendLineSeparator();
            for (Integer line : this.unmappedLines) {
                if (this.linesMapping.containsKey(line)) continue;
                buffer.append(line).appendLineSeparator();
            }
        }
    }

    public void addTotalOffset(int offset_total) {
        this.offset_total += offset_total;
    }

    public int[] getOriginalLinesMapping() {
        int[] res = new int[this.linesMapping.size() * 2];
        int i = 0;
        for (Map.Entry<Integer, Integer> entry : this.linesMapping.entrySet()) {
            res[i] = entry.getKey();
            this.unmappedLines.remove(entry.getKey());
            res[i + 1] = entry.getValue() + this.offset_total + 1;
            i += 2;
        }
        return res;
    }
}

