/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skia;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.Matrix33Kt;
import org.jetbrains.skia.Matrix44;
import org.jetbrains.skia.Point;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0014\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0013\u0012\n\u0010\u0002\u001a\u00020\u0003\"\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\t\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004J\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0000J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/skia/Matrix33;", "", "mat", "", "", "<init>", "([F)V", "getMat", "()[F", "makePreScale", "sx", "sy", "makeConcat", "other", "asMatrix44", "Lorg/jetbrains/skia/Matrix44;", "equals", "", "hashCode", "", "toString", "", "Companion", "skiko"})
@SourceDebugExtension(value={"SMAP\nMatrix33.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Matrix33.kt\norg/jetbrains/skia/Matrix33\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,274:1\n1#2:275\n*E\n"})
public final class Matrix33 {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final float[] mat;
    @NotNull
    private static final Matrix33 IDENTITY = Companion.makeTranslate(0.0f, 0.0f);

    public Matrix33(float ... mat) {
        Intrinsics.checkNotNullParameter((Object)mat, (String)"mat");
        if (!(mat.length == 9)) {
            boolean bl = false;
            String string = "Expected 9 elements, got " + mat.length;
            throw new IllegalArgumentException(string.toString());
        }
        this.mat = mat;
    }

    @NotNull
    public final float[] getMat() {
        return this.mat;
    }

    @NotNull
    public final Matrix33 makePreScale(float sx, float sy) {
        float[] fArray = new float[]{this.mat[0] * sx, this.mat[1] * sy, this.mat[2], this.mat[3] * sx, this.mat[4] * sy, this.mat[5], this.mat[6] * sx, this.mat[7] * sy, this.mat[8]};
        return new Matrix33(fArray);
    }

    @NotNull
    public final Matrix33 makeConcat(@NotNull Matrix33 other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        float[] fArray = new float[]{this.mat[0] * other.mat[0] + this.mat[1] * other.mat[3] + this.mat[2] * other.mat[6], this.mat[0] * other.mat[1] + this.mat[1] * other.mat[4] + this.mat[2] * other.mat[7], this.mat[0] * other.mat[2] + this.mat[1] * other.mat[5] + this.mat[2] * other.mat[8], this.mat[3] * other.mat[0] + this.mat[4] * other.mat[3] + this.mat[5] * other.mat[6], this.mat[3] * other.mat[1] + this.mat[4] * other.mat[4] + this.mat[5] * other.mat[7], this.mat[3] * other.mat[2] + this.mat[4] * other.mat[5] + this.mat[5] * other.mat[8], this.mat[6] * other.mat[0] + this.mat[7] * other.mat[3] + this.mat[8] * other.mat[6], this.mat[6] * other.mat[1] + this.mat[7] * other.mat[4] + this.mat[8] * other.mat[7], this.mat[6] * other.mat[2] + this.mat[7] * other.mat[5] + this.mat[8] * other.mat[8]};
        return new Matrix33(fArray);
    }

    @NotNull
    public final Matrix44 asMatrix44() {
        float[] fArray = new float[]{this.mat[0], this.mat[1], 0.0f, this.mat[2], this.mat[3], this.mat[4], 0.0f, this.mat[5], 0.0f, 0.0f, 1.0f, 0.0f, this.mat[6], this.mat[7], 0.0f, this.mat[8]};
        return new Matrix44(fArray);
    }

    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Matrix33)) {
            return false;
        }
        return Arrays.equals(this.mat, ((Matrix33)other).mat);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * PRIME + Arrays.hashCode(this.mat);
        return result;
    }

    @NotNull
    public String toString() {
        return "Matrix33(_mat=" + this.mat + ')';
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\nJ\u0016\u0010\f\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\nJ\u000e\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\nJ\u0016\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013J\u001e\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\nJ\u0016\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/skia/Matrix33$Companion;", "", "<init>", "()V", "IDENTITY", "Lorg/jetbrains/skia/Matrix33;", "getIDENTITY", "()Lorg/jetbrains/skia/Matrix33;", "makeTranslate", "dx", "", "dy", "makeScale", "s", "sx", "sy", "makeRotate", "deg", "pivot", "Lorg/jetbrains/skia/Point;", "pivotx", "pivoty", "makeSkew", "skiko"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Matrix33 getIDENTITY() {
            return IDENTITY;
        }

        @NotNull
        public final Matrix33 makeTranslate(float dx, float dy) {
            float[] fArray = new float[]{1.0f, 0.0f, dx, 0.0f, 1.0f, dy, 0.0f, 0.0f, 1.0f};
            return new Matrix33(fArray);
        }

        @NotNull
        public final Matrix33 makeScale(float s) {
            return this.makeScale(s, s);
        }

        @NotNull
        public final Matrix33 makeScale(float sx, float sy) {
            float[] fArray = new float[]{sx, 0.0f, 0.0f, 0.0f, sy, 0.0f, 0.0f, 0.0f, 1.0f};
            return new Matrix33(fArray);
        }

        @NotNull
        public final Matrix33 makeRotate(float deg) {
            double rad = Matrix33Kt.toRadians(deg);
            double sin = Math.sin(rad);
            double cos = Math.cos(rad);
            double tolerance = 2.44140625E-4;
            if (Math.abs(sin) <= tolerance) {
                sin = 0.0;
            }
            if (Math.abs(cos) <= tolerance) {
                cos = 0.0;
            }
            float[] fArray = new float[]{(float)cos, (float)(-sin), 0.0f, (float)sin, (float)cos, 0.0f, 0.0f, 0.0f, 1.0f};
            return new Matrix33(fArray);
        }

        @NotNull
        public final Matrix33 makeRotate(float deg, @NotNull Point pivot) {
            Intrinsics.checkNotNullParameter((Object)pivot, (String)"pivot");
            return this.makeRotate(deg, pivot.getX(), pivot.getY());
        }

        @NotNull
        public final Matrix33 makeRotate(float deg, float pivotx, float pivoty) {
            double rad = Matrix33Kt.toRadians(deg);
            double sin = Math.sin(rad);
            double cos = Math.cos(rad);
            double tolerance = 2.44140625E-4;
            if (Math.abs(sin) <= tolerance) {
                sin = 0.0;
            }
            if (Math.abs(cos) <= tolerance) {
                cos = 0.0;
            }
            float[] fArray = new float[]{(float)cos, (float)(-sin), (float)((double)pivotx - (double)pivotx * cos + (double)pivoty * sin), (float)sin, (float)cos, (float)((double)pivoty - (double)pivoty * cos - (double)pivotx * sin), 0.0f, 0.0f, 1.0f};
            return new Matrix33(fArray);
        }

        @NotNull
        public final Matrix33 makeSkew(float sx, float sy) {
            float[] fArray = new float[]{1.0f, sx, 0.0f, sy, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f};
            return new Matrix33(fArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

