/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.api;

import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlEnum;
import org.jetbrains.annotations.NotNull;

@XmlEnum
public enum NodeKind {
    UNKNOWN("unknown"),
    FILE("file"),
    DIR("dir"),
    NONE("none");

    @NotNull
    private static final Map<String, NodeKind> ourAllNodeKinds;
    @NotNull
    private final String myKey;

    private NodeKind(String key) {
        if (key == null) {
            NodeKind.$$$reportNull$$$0(0);
        }
        this.myKey = key;
    }

    public boolean isFile() {
        return FILE.equals((Object)this);
    }

    public boolean isDirectory() {
        return DIR.equals((Object)this);
    }

    public boolean isNone() {
        return NONE.equals((Object)this);
    }

    public String toString() {
        return this.myKey;
    }

    private static void register(@NotNull NodeKind kind) {
        if (kind == null) {
            NodeKind.$$$reportNull$$$0(1);
        }
        ourAllNodeKinds.put(kind.myKey, kind);
    }

    @NotNull
    public static NodeKind from(@NotNull String nodeKindName) {
        NodeKind result;
        if (nodeKindName == null) {
            NodeKind.$$$reportNull$$$0(2);
        }
        if ((result = ourAllNodeKinds.get(nodeKindName)) == null) {
            throw new IllegalArgumentException("Unknown node kind " + nodeKindName);
        }
        NodeKind nodeKind = result;
        if (nodeKind == null) {
            NodeKind.$$$reportNull$$$0(3);
        }
        return nodeKind;
    }

    @NotNull
    public static NodeKind from(boolean isDirectory) {
        NodeKind nodeKind = isDirectory ? DIR : FILE;
        if (nodeKind == null) {
            NodeKind.$$$reportNull$$$0(4);
        }
        return nodeKind;
    }

    static {
        ourAllNodeKinds = new HashMap<String, NodeKind>();
        for (NodeKind kind : NodeKind.values()) {
            NodeKind.register(kind);
        }
        ourAllNodeKinds.put("", UNKNOWN);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeKindName";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/api/NodeKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/api/NodeKind";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "from";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "from";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }
}

