/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.groovy;

import com.android.tools.idea.gradle.dsl.api.ext.PropertyType;
import com.android.tools.idea.gradle.dsl.model.BuildModelContext;
import com.android.tools.idea.gradle.dsl.model.notifications.NotificationTypeReference;
import com.android.tools.idea.gradle.dsl.parser.ExternalNameInfo;
import com.android.tools.idea.gradle.dsl.parser.GradleDslParser;
import com.android.tools.idea.gradle.dsl.parser.GradleReferenceInjection;
import com.android.tools.idea.gradle.dsl.parser.SharedParserUtilsKt;
import com.android.tools.idea.gradle.dsl.parser.configurations.ConfigurationDslElement;
import com.android.tools.idea.gradle.dsl.parser.configurations.ConfigurationsDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslBlockElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslClosure;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslInfixExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslMethodCall;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSettableExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSimpleExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslUnknownElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import com.android.tools.idea.gradle.dsl.parser.files.GradleDslFile;
import com.android.tools.idea.gradle.dsl.parser.groovy.GroovyDslNameConverter;
import com.android.tools.idea.gradle.dsl.parser.groovy.GroovyDslRawText;
import com.android.tools.idea.gradle.dsl.parser.groovy.GroovyDslUtil;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelPropertyDescription;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCommandArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrString;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringInjection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrIndexProperty;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;

public class GroovyDslParser
extends GroovyDslNameConverter
implements GradleDslParser {
    @NotNull
    private final GroovyFile myPsiFile;
    @NotNull
    private final GradleDslFile myDslFile;
    @NotNull
    private final Set<Pair<GradleDslSimpleExpression, PsiElement>> myExtractValueSet;

    public GroovyDslParser(@NotNull GroovyFile file, @NotNull BuildModelContext context, @NotNull GradleDslFile dslFile) {
        if (file == null) {
            GroovyDslParser.$$$reportNull$$$0(0);
        }
        if (context == null) {
            GroovyDslParser.$$$reportNull$$$0(1);
        }
        if (dslFile == null) {
            GroovyDslParser.$$$reportNull$$$0(2);
        }
        super(context);
        this.myPsiFile = file;
        this.myDslFile = dslFile;
        this.myExtractValueSet = new HashSet<Pair<GradleDslSimpleExpression, PsiElement>>();
    }

    @Override
    public void parse() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        this.myPsiFile.acceptChildren((PsiElementVisitor)new GroovyPsiElementVisitor(new GroovyElementVisitor(){

            public void visitMethodCallExpression(@NotNull GrMethodCallExpression e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.process((GroovyPsiElement)e);
            }

            public void visitAssignmentExpression(@NotNull GrAssignmentExpression e) {
                if (e == null) {
                    1.$$$reportNull$$$0(1);
                }
                this.process((GroovyPsiElement)e);
            }

            public void visitReferenceExpression(@NotNull GrReferenceExpression e) {
                if (e == null) {
                    1.$$$reportNull$$$0(2);
                }
                this.process((GroovyPsiElement)e);
            }

            public void visitApplicationStatement(@NotNull GrApplicationStatement e) {
                if (e == null) {
                    1.$$$reportNull$$$0(3);
                }
                this.process((GroovyPsiElement)e);
            }

            public void visitVariableDeclaration(@NotNull GrVariableDeclaration e) {
                if (e == null) {
                    1.$$$reportNull$$$0(4);
                }
                this.process((GroovyPsiElement)e);
            }

            void process(GroovyPsiElement e) {
                GroovyDslParser.this.parsePsi((PsiElement)e, GroovyDslParser.this.myDslFile);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/parser/groovy/GroovyDslParser$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitMethodCallExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitAssignmentExpression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitReferenceExpression";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitApplicationStatement";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitVariableDeclaration";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }));
    }

    @Override
    @Nullable
    public PsiElement convertToPsiElement(@NotNull GradleDslSimpleExpression context, @NotNull Object literal) {
        if (context == null) {
            GroovyDslParser.$$$reportNull$$$0(3);
        }
        if (literal == null) {
            GroovyDslParser.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        try {
            return GroovyDslUtil.createLiteral(context, this.myDslFile, literal);
        }
        catch (IncorrectOperationException e) {
            this.myDslFile.getContext().getNotificationForType(this.myDslFile, NotificationTypeReference.INVALID_EXPRESSION).addError(e);
            return null;
        }
    }

    @Override
    public void setUpForNewValue(@NotNull GradleDslLiteral context, @Nullable PsiElement newValue) {
        if (context == null) {
            GroovyDslParser.$$$reportNull$$$0(5);
        }
        if (newValue == null) {
            return;
        }
        boolean isReference = newValue instanceof GrReferenceExpression || newValue instanceof GrIndexProperty;
        context.setReference(isReference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Object extractValue(@NotNull GradleDslSimpleExpression context, @NotNull PsiElement literal, boolean resolve) {
        if (context == null) {
            GroovyDslParser.$$$reportNull$$$0(6);
        }
        if (literal == null) {
            GroovyDslParser.$$$reportNull$$$0(7);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (literal instanceof GrReferenceExpression || literal instanceof GrIndexProperty) {
            GradleDslElement e;
            if (resolve && (e = context.resolveExternalSyntaxReference(literal, true)) instanceof GradleDslSimpleExpression) {
                Set<Pair<GradleDslSimpleExpression, PsiElement>> set = this.myExtractValueSet;
                synchronized (set) {
                    Object object;
                    Pair key = new Pair((Object)context, (Object)literal);
                    if (this.myExtractValueSet.contains(key)) {
                        return new GroovyDslRawText(literal.getText());
                    }
                    this.myExtractValueSet.add((Pair<GradleDslSimpleExpression, PsiElement>)key);
                    try {
                        object = ((GradleDslSimpleExpression)e).getValue();
                        this.myExtractValueSet.remove(key);
                    }
                    catch (Throwable throwable) {
                        this.myExtractValueSet.remove(key);
                        throw throwable;
                    }
                    return object;
                }
            }
            return literal.getText();
        }
        if (!(literal instanceof GrLiteral)) {
            return new GroovyDslRawText(literal.getText());
        }
        Object value = ((GrLiteral)literal).getValue();
        if (value != null) {
            return value;
        }
        if (!(literal instanceof GrString)) {
            return null;
        }
        if (!resolve) {
            return GroovyDslUtil.ensureUnquotedText(literal.getText());
        }
        if (context.hasCycle()) {
            return GroovyDslUtil.ensureUnquotedText(literal.getText());
        }
        List<GradleReferenceInjection> injections = context.getResolvedVariables();
        return GroovyDslUtil.ensureUnquotedText(GradleReferenceInjection.injectAll(literal, injections));
    }

    @Override
    public boolean shouldInterpolate(@NotNull GradleDslElement elementToCheck) {
        if (elementToCheck == null) {
            GroovyDslParser.$$$reportNull$$$0(8);
        }
        PsiElement element = elementToCheck instanceof GradleDslSettableExpression ? ((GradleDslSettableExpression)elementToCheck).getCurrentElement() : (elementToCheck instanceof GradleDslSimpleExpression ? ((GradleDslSimpleExpression)elementToCheck).getExpression() : elementToCheck.getPsiElement());
        return element instanceof GrString;
    }

    @Override
    @NotNull
    public List<GradleReferenceInjection> getResolvedInjections(@NotNull GradleDslSimpleExpression context, @NotNull PsiElement psiElement) {
        if (context == null) {
            GroovyDslParser.$$$reportNull$$$0(9);
        }
        if (psiElement == null) {
            GroovyDslParser.$$$reportNull$$$0(10);
        }
        List<GradleReferenceInjection> list = GroovyDslUtil.findInjections(context, psiElement, false);
        if (list == null) {
            GroovyDslParser.$$$reportNull$$$0(11);
        }
        return list;
    }

    @Override
    @NotNull
    public List<GradleReferenceInjection> getInjections(@NotNull GradleDslSimpleExpression context, @NotNull PsiElement psiElement) {
        if (context == null) {
            GroovyDslParser.$$$reportNull$$$0(12);
        }
        if (psiElement == null) {
            GroovyDslParser.$$$reportNull$$$0(13);
        }
        List<GradleReferenceInjection> list = GroovyDslUtil.findInjections(context, psiElement, true);
        if (list == null) {
            GroovyDslParser.$$$reportNull$$$0(14);
        }
        return list;
    }

    @Override
    @Nullable
    public GradlePropertiesDslElement getPropertiesElement(@NotNull List<String> nameParts, @NotNull GradlePropertiesDslElement parentElement, @Nullable GradleNameElement nameElement) {
        if (nameParts == null) {
            GroovyDslParser.$$$reportNull$$$0(15);
        }
        if (parentElement == null) {
            GroovyDslParser.$$$reportNull$$$0(16);
        }
        return SharedParserUtilsKt.getPropertiesElement(this.myDslFile, nameParts, this, parentElement, nameElement);
    }

    private void parsePsi(@NotNull PsiElement psiElement, @NotNull GradleDslFile gradleDslFile) {
        if (psiElement == null) {
            GroovyDslParser.$$$reportNull$$$0(17);
        }
        if (gradleDslFile == null) {
            GroovyDslParser.$$$reportNull$$$0(18);
        }
        boolean success = false;
        if (psiElement instanceof GrMethodCallExpression) {
            success = this.parseGrMethodCall((GrMethodCallExpression)psiElement, gradleDslFile);
        } else if (psiElement instanceof GrAssignmentExpression) {
            success = this.parseGrAssignment((GrAssignmentExpression)psiElement, gradleDslFile);
        } else if (psiElement instanceof GrApplicationStatement) {
            success = this.parseGrApplication((GrApplicationStatement)psiElement, gradleDslFile);
        } else if (psiElement instanceof GrVariableDeclaration) {
            success = this.parseGrVariableDeclaration((GrVariableDeclaration)psiElement, gradleDslFile);
        } else if (psiElement instanceof GrReferenceExpression) {
            success = this.parseGrReference((GrReferenceExpression)psiElement, gradleDslFile);
        }
        if (!success) {
            gradleDslFile.notification(NotificationTypeReference.INCOMPLETE_PARSING).addUnknownElement(psiElement);
        }
    }

    private boolean parseGrReference(@NotNull GrReferenceExpression element, @NotNull GradlePropertiesDslElement dslElement) {
        GradlePropertiesDslElement nestedElement;
        GradleNameElement name2;
        if (element == null) {
            GroovyDslParser.$$$reportNull$$$0(19);
        }
        if (dslElement == null) {
            GroovyDslParser.$$$reportNull$$$0(20);
        }
        if ((name2 = GradleNameElement.from((PsiElement)element, this)).isQualified() && (nestedElement = this.getPropertiesElement(name2.qualifyingParts(), dslElement, null)) != null) {
            dslElement = nestedElement;
        }
        if (!(dslElement instanceof ConfigurationsDslElement)) {
            return false;
        }
        ConfigurationDslElement resultElement = new ConfigurationDslElement(dslElement, (PsiElement)element, name2, false);
        resultElement.setElementType(PropertyType.REGULAR);
        dslElement.addParsedElement(resultElement);
        return true;
    }

    private boolean parseGrMethodCall(@NotNull GrMethodCallExpression expression, @NotNull GradlePropertiesDslElement dslElement) {
        GradlePropertiesDslElement propertiesElement;
        PsiElement operator;
        GrReferenceExpression referenceExpression;
        if (expression == null) {
            GroovyDslParser.$$$reportNull$$$0(21);
        }
        if (dslElement == null) {
            GroovyDslParser.$$$reportNull$$$0(22);
        }
        if ((referenceExpression = (GrReferenceExpression)PsiTreeUtil.findChildOfType((PsiElement)expression, GrReferenceExpression.class)) == null) {
            return false;
        }
        if ((referenceExpression.getFirstChild() instanceof GrApplicationStatement || referenceExpression.getFirstChild() instanceof GrMethodCallExpression) && ((operator = referenceExpression.getLastChild()).textMatches((CharSequence)"version") || operator.textMatches((CharSequence)"apply"))) {
            return this.processPluginDeclaration((GrMethodCall)expression, dslElement);
        }
        PsiElement psiElement = referenceExpression.getFirstChild();
        if (psiElement instanceof GrReferenceExpression) {
            GrReferenceExpression lvalue = (GrReferenceExpression)psiElement;
            if ("set".equals(referenceExpression.getReferenceName()) && expression.getExpressionArguments().length == 1) {
                GrExpression rvalue = expression.getExpressionArguments()[0];
                GradleNameElement name2 = GradleNameElement.from((PsiElement)lvalue, this);
                GradleDslExpression element = this.getExpressionElement(dslElement, (GroovyPsiElement)expression, name2, rvalue);
                element.setExternalSyntax(ExternalNameInfo.ExternalNameSyntax.SET_METHOD);
                element.setElementType(PropertyType.REGULAR);
                dslElement.addParsedElement(element);
                return true;
            }
        }
        if (expression.getChildren().length > 1 && referenceExpression.getChildren().length == 1 && referenceExpression.getChildren()[0] instanceof GrMethodCallExpression) {
            return this.parseGrMethodCall((GrMethodCallExpression)referenceExpression.getChildren()[0], dslElement);
        }
        GradleNameElement name3 = GradleNameElement.from((PsiElement)referenceExpression, this);
        if (name3.isEmpty()) {
            return false;
        }
        if (name3.isQualified()) {
            dslElement = this.getPropertiesElement(name3.qualifyingParts(), dslElement, null);
        }
        if (dslElement == null) {
            return false;
        }
        GrClosableBlock[] closureArguments = expression.getClosureArguments();
        GrArgumentList argumentList = expression.getArgumentList();
        int nArgs = argumentList.getAllArguments().length;
        if (!GroovyDslUtil.isBlockElement(expression, this, dslElement)) {
            GradleDslMethodCall methodCall = this.getMethodCall(dslElement, (PsiElement)expression, name3, argumentList, name3.fullName(), false);
            if (closureArguments.length > 0) {
                methodCall.setParsedClosureElement(this.getClosureElement(methodCall, closureArguments[0], name3));
            }
            methodCall.setElementType(PropertyType.REGULAR);
            dslElement.addParsedElement(methodCall);
            return true;
        }
        if (expression.getExpressionArguments().length == 1) {
            name3 = GradleNameElement.from((PsiElement)expression, this);
        }
        GrClosableBlock closableBlock = null;
        if (closureArguments.length > 0) {
            closableBlock = closureArguments[0];
        }
        ArrayList<GradlePropertiesDslElement> blockElements = new ArrayList<GradlePropertiesDslElement>();
        if (dslElement instanceof GradleDslFile && name3.name().equals("allprojects")) {
            blockElements.add(dslElement);
            name3 = GradleNameElement.create("subprojects");
        }
        if ((propertiesElement = this.getPropertiesElement((List<String>)ImmutableList.of((Object)name3.name()), dslElement, name3)) != null) {
            if (closableBlock != null) {
                propertiesElement.setPsiElement((PsiElement)closableBlock);
            } else {
                propertiesElement.setPsiElement((PsiElement)expression);
                if (propertiesElement instanceof GradleDslBlockElement) {
                    ((GradleDslBlockElement)propertiesElement).setHasBraces(false);
                }
            }
            blockElements.add(propertiesElement);
        }
        if (blockElements.isEmpty()) {
            return false;
        }
        if (closableBlock != null) {
            for (GradlePropertiesDslElement element : blockElements) {
                this.parseGrClosableBlock(closableBlock, element);
            }
        }
        return true;
    }

    private void parseGrClosableBlock(@NotNull GrClosableBlock closure, final @NotNull GradlePropertiesDslElement blockElement) {
        if (closure == null) {
            GroovyDslParser.$$$reportNull$$$0(23);
        }
        if (blockElement == null) {
            GroovyDslParser.$$$reportNull$$$0(24);
        }
        closure.acceptChildren(new GroovyElementVisitor(){

            public void visitMethodCallExpression(@NotNull GrMethodCallExpression methodCallExpression) {
                if (methodCallExpression == null) {
                    2.$$$reportNull$$$0(0);
                }
                GroovyDslParser.this.parseGrMethodCall(methodCallExpression, blockElement);
            }

            public void visitApplicationStatement(@NotNull GrApplicationStatement applicationStatement) {
                if (applicationStatement == null) {
                    2.$$$reportNull$$$0(1);
                }
                GroovyDslParser.this.parseGrApplication(applicationStatement, blockElement);
            }

            public void visitAssignmentExpression(@NotNull GrAssignmentExpression expression) {
                if (expression == null) {
                    2.$$$reportNull$$$0(2);
                }
                GroovyDslParser.this.parseGrAssignment(expression, blockElement);
            }

            public void visitReferenceExpression(@NotNull GrReferenceExpression referenceExpression) {
                if (referenceExpression == null) {
                    2.$$$reportNull$$$0(3);
                }
                GroovyDslParser.this.parseGrReference(referenceExpression, blockElement);
            }

            public void visitVariableDeclaration(@NotNull GrVariableDeclaration variableDeclaration) {
                if (variableDeclaration == null) {
                    2.$$$reportNull$$$0(4);
                }
                GroovyDslParser.this.parseGrVariableDeclaration(variableDeclaration, blockElement);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "methodCallExpression";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "applicationStatement";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "referenceExpression";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "variableDeclaration";
                        break;
                    }
                }
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/parser/groovy/GroovyDslParser$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitMethodCallExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitApplicationStatement";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitAssignmentExpression";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitReferenceExpression";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitVariableDeclaration";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private boolean parseGrApplication(@NotNull GrApplicationStatement statement, @NotNull GradlePropertiesDslElement blockElement) {
        PsiElement operator;
        GrReferenceExpression referenceExpression;
        if (statement == null) {
            GroovyDslParser.$$$reportNull$$$0(25);
        }
        if (blockElement == null) {
            GroovyDslParser.$$$reportNull$$$0(26);
        }
        if ((referenceExpression = (GrReferenceExpression)PsiTreeUtil.getChildOfType((PsiElement)statement, GrReferenceExpression.class)) == null) {
            return false;
        }
        if ((referenceExpression.getFirstChild() instanceof GrApplicationStatement || referenceExpression.getFirstChild() instanceof GrMethodCallExpression) && ((operator = referenceExpression.getLastChild()).textMatches((CharSequence)"version") || operator.textMatches((CharSequence)"apply"))) {
            return this.processPluginDeclaration((GrMethodCall)statement, blockElement);
        }
        GrCommandArgumentList argumentList = (GrCommandArgumentList)PsiTreeUtil.getNextSiblingOfType((PsiElement)referenceExpression, GrCommandArgumentList.class);
        if (argumentList == null) {
            return false;
        }
        GroovyPsiElement[] arguments = argumentList.getAllArguments();
        if (arguments.length == 0) {
            return false;
        }
        GradleNameElement name2 = GradleNameElement.from((PsiElement)referenceExpression, this);
        if (name2.isEmpty()) {
            return false;
        }
        if (name2.isQualified()) {
            GradlePropertiesDslElement nestedElement = this.getPropertiesElement(name2.qualifyingParts(), blockElement, null);
            if (nestedElement != null) {
                blockElement = nestedElement;
            } else {
                return false;
            }
        }
        GradleDslElement propertyElement = null;
        if (arguments[0] instanceof GrExpression) {
            ArrayList<GrExpression> expressions = new ArrayList<GrExpression>(arguments.length);
            for (GroovyPsiElement element : arguments) {
                if (!(element instanceof GrExpression) || element instanceof GrClosableBlock) continue;
                expressions.add((GrExpression)element);
            }
            propertyElement = expressions.size() == 1 ? this.createExpressionElement(blockElement, (GroovyPsiElement)argumentList, name2, (GrExpression)expressions.get(0)) : this.getExpressionList(blockElement, (GroovyPsiElement)argumentList, name2, expressions, false);
        } else if (arguments[0] instanceof GrNamedArgument) {
            ArrayList<GrNamedArgument> namedArguments = new ArrayList<GrNamedArgument>(arguments.length);
            for (GroovyPsiElement element : arguments) {
                if (!(element instanceof GrNamedArgument) || element instanceof GrClosableBlock) continue;
                namedArguments.add((GrNamedArgument)element);
            }
            propertyElement = this.getExpressionMap(blockElement, (GroovyPsiElement)argumentList, name2, namedArguments, false);
        }
        if (propertyElement == null) {
            return false;
        }
        GroovyPsiElement lastArgument = arguments[arguments.length - 1];
        if (lastArgument instanceof GrClosableBlock) {
            propertyElement.setParsedClosureElement(this.getClosureElement(propertyElement, (GrClosableBlock)lastArgument, name2));
        }
        propertyElement.setElementType(PropertyType.REGULAR);
        blockElement.addParsedElement(propertyElement);
        return true;
    }

    boolean processPluginDeclaration(GrMethodCall statement, GradlePropertiesDslElement parent) {
        GradlePropertiesDslElement pluginElement;
        if (parent instanceof GradleDslInfixExpression) {
            pluginElement = parent;
        } else {
            pluginElement = new GradleDslInfixExpression(parent, (PsiElement)statement);
            parent.addParsedElement(pluginElement);
        }
        GrReferenceExpression referenceExpression = (GrReferenceExpression)statement.getFirstChild();
        PsiElement innerElement = referenceExpression.getFirstChild();
        boolean success = false;
        if (innerElement instanceof GrApplicationStatement) {
            success = this.parseGrApplication((GrApplicationStatement)innerElement, pluginElement);
        } else if (innerElement instanceof GrMethodCallExpression) {
            success = this.parseGrMethodCall((GrMethodCallExpression)innerElement, pluginElement);
        }
        if (!success) {
            return false;
        }
        PsiElement operator = referenceExpression.getLastChild();
        GrExpression[] operands = statement.getExpressionArguments();
        if (operands.length != 1) {
            return false;
        }
        GrExpression value = operands[0];
        GradleDslExpression propertyElement = this.getExpressionElement(pluginElement, (GroovyPsiElement)value, GradleNameElement.from(operator, this), value);
        pluginElement.addParsedElement(propertyElement);
        return true;
    }

    @NotNull
    private GradleDslExpression createExpressionElement(@NotNull GradleDslElement parent, @NotNull GroovyPsiElement psiElement, @NotNull GradleNameElement name2, @NotNull GrExpression expression) {
        GrListOrMap listOrMap;
        if (parent == null) {
            GroovyDslParser.$$$reportNull$$$0(27);
        }
        if (psiElement == null) {
            GroovyDslParser.$$$reportNull$$$0(28);
        }
        if (name2 == null) {
            GroovyDslParser.$$$reportNull$$$0(29);
        }
        if (expression == null) {
            GroovyDslParser.$$$reportNull$$$0(30);
        }
        GradleDslElement propertyElement = expression instanceof GrListOrMap ? ((listOrMap = (GrListOrMap)expression).isMap() ? this.getExpressionMap(parent, (GroovyPsiElement)listOrMap, name2, Arrays.asList(listOrMap.getNamedArguments()), true) : this.getExpressionList(parent, (GroovyPsiElement)listOrMap, name2, Arrays.asList(listOrMap.getInitializers()), true)) : (expression instanceof GrClosableBlock ? this.getClosureElement(parent, (GrClosableBlock)expression, name2) : this.getExpressionElement(parent, psiElement, name2, expression));
        GradleDslExpression gradleDslExpression = propertyElement;
        if (gradleDslExpression == null) {
            GroovyDslParser.$$$reportNull$$$0(31);
        }
        return gradleDslExpression;
    }

    private boolean parseGrVariableDeclaration(@NotNull GrVariableDeclaration declaration, @NotNull GradlePropertiesDslElement blockElement) {
        if (declaration == null) {
            GroovyDslParser.$$$reportNull$$$0(32);
        }
        if (blockElement == null) {
            GroovyDslParser.$$$reportNull$$$0(33);
        }
        if (declaration.getVariables().length == 0) {
            return false;
        }
        for (GrVariable variable : declaration.getVariables()) {
            if (variable == null) {
                return false;
            }
            GrExpression init = variable.getInitializerGroovy();
            if (init == null) {
                return false;
            }
            GradleNameElement name2 = GradleNameElement.from((PsiElement)variable, this);
            GradleDslExpression variableElement = this.createExpressionElement(blockElement, (GroovyPsiElement)declaration, name2, init);
            variableElement.setElementType(PropertyType.VARIABLE);
            blockElement.setParsedElement(variableElement);
        }
        return true;
    }

    private boolean parseGrAssignment(@NotNull GrAssignmentExpression assignment, @NotNull GradlePropertiesDslElement blockElement) {
        PsiElement operationToken;
        if (assignment == null) {
            GroovyDslParser.$$$reportNull$$$0(34);
        }
        if (blockElement == null) {
            GroovyDslParser.$$$reportNull$$$0(35);
        }
        if ((operationToken = assignment.getOperationToken()).getText().equals("=")) {
            return this.processAssignment(assignment, blockElement);
        }
        if (operationToken.getText().equals("+=")) {
            return this.processAugmentedAssignment(assignment, blockElement);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean processAssignment(@NotNull GrAssignmentExpression assignment, @NotNull GradlePropertiesDslElement blockElement) {
        GrExpression right;
        GrExpression left;
        GradleNameElement name2;
        if (assignment == null) {
            GroovyDslParser.$$$reportNull$$$0(36);
        }
        if (blockElement == null) {
            GroovyDslParser.$$$reportNull$$$0(37);
        }
        if ((name2 = GradleNameElement.from((PsiElement)(left = assignment.getLValue()), this)).isEmpty()) {
            return false;
        }
        if (name2.isQualified()) {
            GradlePropertiesDslElement nestedElement = this.getPropertiesElement(name2.qualifyingParts(), blockElement, null);
            if (nestedElement == null) return false;
            blockElement = nestedElement;
        }
        if ((right = assignment.getRValue()) == null) {
            return false;
        }
        Matcher matcher = GradleNameElement.INDEX_PATTERN.matcher(name2.name());
        if (matcher.find()) {
            ModelPropertyDescription propertyDescription = this.modelDescriptionForParent(matcher.group(0), blockElement);
            String property = propertyDescription == null ? matcher.group(0) : propertyDescription.name;
            GradleDslElement element = blockElement.getElement(property);
            if (!(element instanceof GradlePropertiesDslElement)) {
                return false;
            }
            blockElement = (GradlePropertiesDslElement)element;
            if (!matcher.find()) return false;
            String index = matcher.group(1);
            while (matcher.find()) {
                if ((blockElement = GradleDslSimpleExpression.dereferencePropertiesElement(blockElement, index)) == null) {
                    return false;
                }
                index = matcher.group(1);
            }
            name2 = GradleNameElement.create(GroovyDslUtil.ensureUnquotedText(index));
            if (!(blockElement instanceof GradleDslExpressionMap)) return false;
            GradleDslExpression propertyElement = this.createExpressionElement(blockElement, (GroovyPsiElement)assignment, name2, right);
            propertyElement.setElementType(PropertyType.DERIVED);
            SharedParserUtilsKt.setMaybeIndirectedElement(blockElement, propertyElement, this.myDslFile);
            return true;
        } else {
            GradleDslExpression propertyElement = this.createExpressionElement(blockElement, (GroovyPsiElement)assignment, name2, right);
            propertyElement.setExternalSyntax(ExternalNameInfo.ExternalNameSyntax.ASSIGNMENT);
            propertyElement.setElementType(PropertyType.REGULAR);
            SharedParserUtilsKt.setMaybeIndirectedElement(blockElement, propertyElement, this.myDslFile);
        }
        return true;
    }

    boolean processAugmentedAssignment(@NotNull GrAssignmentExpression assignment, @NotNull GradlePropertiesDslElement blockElement) {
        GrExpression right;
        GrExpression left;
        GradleNameElement name2;
        if (assignment == null) {
            GroovyDslParser.$$$reportNull$$$0(38);
        }
        if (blockElement == null) {
            GroovyDslParser.$$$reportNull$$$0(39);
        }
        if ((name2 = GradleNameElement.from((PsiElement)(left = assignment.getLValue()), this)).isEmpty()) {
            return false;
        }
        if (name2.isQualified()) {
            GradlePropertiesDslElement nestedElement = this.getPropertiesElement(name2.qualifyingParts(), blockElement, null);
            if (nestedElement != null) {
                blockElement = nestedElement;
            } else {
                return false;
            }
        }
        if ((right = assignment.getRValue()) == null) {
            return false;
        }
        Matcher matcher = GradleNameElement.INDEX_PATTERN.matcher(name2.name());
        if (matcher.find()) {
            return false;
        }
        GradleDslExpression propertyElement = this.createExpressionElement(blockElement, (GroovyPsiElement)assignment, name2, right);
        propertyElement.setExternalSyntax(ExternalNameInfo.ExternalNameSyntax.AUGMENTED_ASSIGNMENT);
        propertyElement.setElementType(PropertyType.REGULAR);
        blockElement.augmentParsedElement(propertyElement);
        return true;
    }

    @NotNull
    private GradleDslExpression getExpressionElement(@NotNull GradleDslElement parentElement, @NotNull GroovyPsiElement psiElement, @NotNull GradleNameElement propertyName, @NotNull GrExpression propertyExpression) {
        GrArgumentList argumentList;
        String objectName;
        GrNewExpression newExpression;
        GrCodeReferenceElement referenceElement;
        String methodName;
        GrMethodCallExpression methodCall;
        GrReferenceExpression callReferenceExpression;
        if (parentElement == null) {
            GroovyDslParser.$$$reportNull$$$0(40);
        }
        if (psiElement == null) {
            GroovyDslParser.$$$reportNull$$$0(41);
        }
        if (propertyName == null) {
            GroovyDslParser.$$$reportNull$$$0(42);
        }
        if (propertyExpression == null) {
            GroovyDslParser.$$$reportNull$$$0(43);
        }
        if (propertyExpression instanceof GrLiteral) {
            PsiElement injection = PsiTreeUtil.getChildOfType((PsiElement)propertyExpression, GrStringInjection.class);
            return new GradleDslLiteral(parentElement, (PsiElement)psiElement, propertyName, (PsiElement)propertyExpression, injection != null ? GradleDslLiteral.LiteralType.INTERPOLATION : GradleDslLiteral.LiteralType.LITERAL);
        }
        if (propertyExpression instanceof GrReferenceExpression) {
            return new GradleDslLiteral(parentElement, (PsiElement)psiElement, propertyName, (PsiElement)propertyExpression, GradleDslLiteral.LiteralType.REFERENCE);
        }
        if (propertyExpression instanceof GrMethodCallExpression && (callReferenceExpression = (GrReferenceExpression)PsiTreeUtil.getChildOfType((PsiElement)(methodCall = (GrMethodCallExpression)propertyExpression), GrReferenceExpression.class)) != null && !(methodName = callReferenceExpression.getText()).isEmpty()) {
            GrArgumentList argumentList2 = methodCall.getArgumentList();
            return this.getMethodCall(parentElement, (PsiElement)methodCall, propertyName, argumentList2, methodName, false);
        }
        if (propertyExpression instanceof GrIndexProperty) {
            return new GradleDslLiteral(parentElement, (PsiElement)psiElement, propertyName, (PsiElement)propertyExpression, GradleDslLiteral.LiteralType.REFERENCE);
        }
        if (propertyExpression instanceof GrNewExpression && (referenceElement = (newExpression = (GrNewExpression)propertyExpression).getReferenceElement()) != null && (objectName = referenceElement.getReferenceName()) != null && !objectName.isEmpty() && (argumentList = newExpression.getArgumentList()) != null && argumentList.getAllArguments().length > 0) {
            return this.getMethodCall(parentElement, (PsiElement)newExpression, propertyName, argumentList, objectName, true);
        }
        parentElement.notification(NotificationTypeReference.INCOMPLETE_PARSING).addUnknownElement((PsiElement)propertyExpression);
        return new GradleDslUnknownElement(parentElement, (PsiElement)propertyExpression, propertyName);
    }

    @NotNull
    private GradleDslMethodCall getMethodCall(@NotNull GradleDslElement parentElement, @NotNull PsiElement psiElement, @NotNull GradleNameElement propertyName, @NotNull GrArgumentList argumentList, @NotNull String methodName, boolean isConstructor) {
        if (parentElement == null) {
            GroovyDslParser.$$$reportNull$$$0(44);
        }
        if (psiElement == null) {
            GroovyDslParser.$$$reportNull$$$0(45);
        }
        if (propertyName == null) {
            GroovyDslParser.$$$reportNull$$$0(46);
        }
        if (argumentList == null) {
            GroovyDslParser.$$$reportNull$$$0(47);
        }
        if (methodName == null) {
            GroovyDslParser.$$$reportNull$$$0(48);
        }
        GradleDslMethodCall methodCall = new GradleDslMethodCall(parentElement, psiElement, propertyName, methodName, isConstructor);
        GradleDslExpressionList arguments = this.getExpressionList(methodCall, (GroovyPsiElement)argumentList, GradleNameElement.empty(), Arrays.asList(argumentList.getExpressionArguments()), false);
        methodCall.setParsedArgumentList(arguments);
        GrNamedArgument[] namedArguments = argumentList.getNamedArguments();
        if (namedArguments.length > 0) {
            methodCall.addParsedExpression(this.getExpressionMap(methodCall, (GroovyPsiElement)argumentList, GradleNameElement.empty(), Arrays.asList(namedArguments), false));
        }
        GradleDslMethodCall gradleDslMethodCall = methodCall;
        if (gradleDslMethodCall == null) {
            GroovyDslParser.$$$reportNull$$$0(49);
        }
        return gradleDslMethodCall;
    }

    @NotNull
    private GradleDslExpressionList getExpressionList(@NotNull GradleDslElement parentElement, @NotNull GroovyPsiElement listPsiElement, @NotNull GradleNameElement propertyName, @NotNull List<GrExpression> propertyExpressions, boolean isLiteral) {
        if (parentElement == null) {
            GroovyDslParser.$$$reportNull$$$0(50);
        }
        if (listPsiElement == null) {
            GroovyDslParser.$$$reportNull$$$0(51);
        }
        if (propertyName == null) {
            GroovyDslParser.$$$reportNull$$$0(52);
        }
        if (propertyExpressions == null) {
            GroovyDslParser.$$$reportNull$$$0(53);
        }
        GradleDslExpressionList expressionList = new GradleDslExpressionList(parentElement, (PsiElement)listPsiElement, isLiteral, propertyName);
        for (GrExpression expression : propertyExpressions) {
            GradleDslExpression expressionElement = this.createExpressionElement(expressionList, (GroovyPsiElement)expression, GradleNameElement.empty(), expression);
            if (expressionElement instanceof GradleDslClosure) {
                parentElement.setParsedClosureElement((GradleDslClosure)expressionElement);
                continue;
            }
            expressionList.addParsedExpression(expressionElement);
        }
        GradleDslExpressionList gradleDslExpressionList = expressionList;
        if (gradleDslExpressionList == null) {
            GroovyDslParser.$$$reportNull$$$0(54);
        }
        return gradleDslExpressionList;
    }

    @NotNull
    private GradleDslExpressionMap getExpressionMap(@NotNull GradleDslElement parentElement, @NotNull GroovyPsiElement mapPsiElement, @NotNull GradleNameElement propertyName, @NotNull List<GrNamedArgument> namedArguments, boolean isLiteralMap) {
        if (parentElement == null) {
            GroovyDslParser.$$$reportNull$$$0(55);
        }
        if (mapPsiElement == null) {
            GroovyDslParser.$$$reportNull$$$0(56);
        }
        if (propertyName == null) {
            GroovyDslParser.$$$reportNull$$$0(57);
        }
        if (namedArguments == null) {
            GroovyDslParser.$$$reportNull$$$0(58);
        }
        GradleDslExpressionMap expressionMap = new GradleDslExpressionMap(parentElement, (PsiElement)mapPsiElement, propertyName, isLiteralMap);
        for (GrNamedArgument namedArgument : namedArguments) {
            GrExpression valueExpression;
            GradleNameElement argName;
            GrArgumentLabel nameLabel = namedArgument.getLabel();
            if (nameLabel == null || (argName = GradleNameElement.from(nameLabel.getNameElement(), this)).isEmpty() || (valueExpression = namedArgument.getExpression()) == null) continue;
            GradleDslExpression valueElement = this.createExpressionElement(expressionMap, mapPsiElement, argName, valueExpression);
            if (valueElement instanceof GradleDslUnknownElement && valueExpression instanceof GrListOrMap) {
                GrListOrMap listOrMap = (GrListOrMap)valueExpression;
                valueElement = listOrMap.isMap() ? this.getExpressionMap(expressionMap, (GroovyPsiElement)listOrMap, argName, Arrays.asList(listOrMap.getNamedArguments()), true) : this.getExpressionList(expressionMap, (GroovyPsiElement)listOrMap, argName, Arrays.asList(listOrMap.getInitializers()), true);
            }
            expressionMap.setParsedElement(valueElement);
        }
        GradleDslExpressionMap gradleDslExpressionMap = expressionMap;
        if (gradleDslExpressionMap == null) {
            GroovyDslParser.$$$reportNull$$$0(59);
        }
        return gradleDslExpressionMap;
    }

    @NotNull
    private GradleDslClosure getClosureElement(@NotNull GradleDslElement parentElement, @NotNull GrClosableBlock closableBlock, @NotNull GradleNameElement propertyName) {
        if (parentElement == null) {
            GroovyDslParser.$$$reportNull$$$0(60);
        }
        if (closableBlock == null) {
            GroovyDslParser.$$$reportNull$$$0(61);
        }
        if (propertyName == null) {
            GroovyDslParser.$$$reportNull$$$0(62);
        }
        GradleDslClosure closureElement = new GradleDslClosure(parentElement, (PsiElement)closableBlock, propertyName);
        this.parseGrClosableBlock(closableBlock, closureElement);
        GradleDslClosure gradleDslClosure = closureElement;
        if (gradleDslClosure == null) {
            GroovyDslParser.$$$reportNull$$$0(63);
        }
        return gradleDslClosure;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 14, 31, 49, 54, 59, 63 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dslFile";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToCheck";
                break;
            }
            case 10: 
            case 13: 
            case 17: 
            case 28: 
            case 41: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 11: 
            case 14: 
            case 31: 
            case 49: 
            case 54: 
            case 59: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/dsl/parser/groovy/GroovyDslParser";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameParts";
                break;
            }
            case 16: 
            case 40: 
            case 44: 
            case 50: 
            case 55: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentElement";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleDslFile";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dslElement";
                break;
            }
            case 21: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closure";
                break;
            }
            case 24: 
            case 26: 
            case 33: 
            case 35: 
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockElement";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 34: 
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignment";
                break;
            }
            case 42: 
            case 46: 
            case 52: 
            case 57: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyExpression";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentList";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listPsiElement";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyExpressions";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapPsiElement";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedArguments";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closableBlock";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/parser/groovy/GroovyDslParser";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedInjections";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getInjections";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "createExpressionElement";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodCall";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressionList";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressionMap";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "getClosureElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "convertToPsiElement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setUpForNewValue";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "extractValue";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "shouldInterpolate";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getResolvedInjections";
                break;
            }
            case 11: 
            case 14: 
            case 31: 
            case 49: 
            case 54: 
            case 59: 
            case 63: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getInjections";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getPropertiesElement";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "parsePsi";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "parseGrReference";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "parseGrMethodCall";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "parseGrClosableBlock";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "parseGrApplication";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createExpressionElement";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "parseGrVariableDeclaration";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "parseGrAssignment";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "processAssignment";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "processAugmentedAssignment";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionElement";
                break;
            }
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getMethodCall";
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionList";
                break;
            }
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionMap";
                break;
            }
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "getClosureElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 14, 31, 49, 54, 59, 63 -> new IllegalStateException(string);
        };
    }
}

