/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyElsePart;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyIfPart;
import com.jetbrains.python.psi.PyIfStatement;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.impl.PyEvaluator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/python/psi/impl/PyTypeCheckedElementVisitor;", "Lcom/jetbrains/python/psi/PyRecursiveElementVisitor;", "languageLevel", "Lcom/jetbrains/python/psi/LanguageLevel;", "<init>", "(Lcom/jetbrains/python/psi/LanguageLevel;)V", "visitPyIfStatement", "", "node", "Lcom/jetbrains/python/psi/PyIfStatement;", "intellij.python.psi.impl"})
@ApiStatus.Internal
public class PyTypeCheckedElementVisitor
extends PyRecursiveElementVisitor {
    @Nullable
    private final LanguageLevel languageLevel;

    public PyTypeCheckedElementVisitor(@Nullable LanguageLevel languageLevel) {
        this.languageLevel = languageLevel;
    }

    public void visitPyIfStatement(@NotNull PyIfStatement node) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Sequence sequence = SequencesKt.sequenceOf((Object)node.getIfPart());
            PyIfPart[] pyIfPartArray = node.getElifParts();
            Intrinsics.checkNotNullExpressionValue((Object)pyIfPartArray, (String)"getElifParts(...)");
            Sequence ifParts = SequencesKt.plus((Sequence)sequence, (Sequence)ArraysKt.asSequence((Object[])pyIfPartArray));
            for (PyIfPart ifPart : ifParts) {
                Boolean result = PyEvaluator.evaluateAsBooleanNoResolve((PyExpression)ifPart.getCondition(), this.languageLevel);
                if (result == null) {
                    super.visitPyIfStatement(node);
                    return;
                }
                if (!result.booleanValue()) continue;
                ((PyStatementList)ifPart.getStatementList()).accept((PsiElementVisitor)this);
                return;
            }
            PyElsePart pyElsePart = (PyElsePart)node.getElsePart();
            if (pyElsePart == null || (pyElsePart = (PyStatementList)pyElsePart.getStatementList()) == null) break block2;
            pyElsePart.accept((PsiElementVisitor)this);
        }
    }
}

