/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.collections.immutable.implementations.immutableMap;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.jvm.internal.markers.KMutableIterator;
import kotlinx.collections.immutable.implementations.immutableMap.PersistentHashMapBaseIterator;
import kotlinx.collections.immutable.implementations.immutableMap.PersistentHashMapBuilder;
import kotlinx.collections.immutable.implementations.immutableMap.TrieNode;
import kotlinx.collections.immutable.implementations.immutableMap.TrieNodeBaseIterator;
import kotlinx.collections.immutable.implementations.immutableMap.TrieNodeKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010)\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0010\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u0002*\u0004\b\u0002\u0010\u00032\b\u0012\u0004\u0012\u0002H\u00030\u00042\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0005B;\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007\u0012\u001e\u0010\b\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000e\u0010\u0013\u001a\u00028\u0002H\u0096\u0002\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u001b\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00028\u00002\u0006\u0010\u0019\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u001aJI\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u00122\u000e\u0010\u001d\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001e2\u0006\u0010\u0018\u001a\u00028\u00002\u0006\u0010\u001f\u001a\u00020\u00122\b\b\u0002\u0010 \u001a\u00020\u00122\b\b\u0002\u0010!\u001a\u00020\u0010H\u0002\u00a2\u0006\u0002\u0010\"J\b\u0010#\u001a\u00020\u0016H\u0002J\b\u0010$\u001a\u00020\u0016H\u0002R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lkotlinx/collections/immutable/implementations/immutableMap/PersistentHashMapBuilderBaseIterator;", "K", "V", "T", "", "Lkotlinx/collections/immutable/implementations/immutableMap/PersistentHashMapBaseIterator;", "builder", "Lkotlinx/collections/immutable/implementations/immutableMap/PersistentHashMapBuilder;", "path", "", "Lkotlinx/collections/immutable/implementations/immutableMap/TrieNodeBaseIterator;", "<init>", "(Lkotlinx/collections/immutable/implementations/immutableMap/PersistentHashMapBuilder;[Lkotlinx/collections/immutable/implementations/immutableMap/TrieNodeBaseIterator;)V", "lastIteratedKey", "Ljava/lang/Object;", "nextWasInvoked", "", "expectedModCount", "", "next", "()Ljava/lang/Object;", "remove", "", "setValue", "key", "newValue", "(Ljava/lang/Object;Ljava/lang/Object;)V", "resetPath", "keyHash", "node", "Lkotlinx/collections/immutable/implementations/immutableMap/TrieNode;", "pathIndex", "removedKeyHash", "afterRemove", "(ILkotlinx/collections/immutable/implementations/immutableMap/TrieNode;Ljava/lang/Object;IIZ)V", "checkNextWasInvoked", "checkForComodification", "kotlinx-collections-immutable"})
public class PersistentHashMapBuilderBaseIterator<K, V, T>
extends PersistentHashMapBaseIterator<K, V, T>
implements Iterator<T>,
KMutableIterator {
    @NotNull
    private final PersistentHashMapBuilder<K, V> builder;
    @Nullable
    private K lastIteratedKey;
    private boolean nextWasInvoked;
    private int expectedModCount;

    public PersistentHashMapBuilderBaseIterator(@NotNull PersistentHashMapBuilder<K, V> builder, @NotNull TrieNodeBaseIterator<K, V, T>[] path) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Intrinsics.checkNotNullParameter(path, (String)"path");
        super(builder.getNode$kotlinx_collections_immutable(), path);
        this.builder = builder;
        this.expectedModCount = this.builder.getModCount$kotlinx_collections_immutable();
    }

    @Override
    public T next() {
        this.checkForComodification();
        this.lastIteratedKey = this.currentKey();
        this.nextWasInvoked = true;
        return super.next();
    }

    @Override
    public void remove() {
        this.checkNextWasInvoked();
        if (this.hasNext()) {
            Object currentKey = this.currentKey();
            Map map = this.builder;
            K k = this.lastIteratedKey;
            TypeIntrinsics.asMutableMap((Object)map).remove(k);
            Object k2 = currentKey;
            K k3 = this.lastIteratedKey;
            this.resetPath(k2 != null ? k2.hashCode() : 0, this.builder.getNode$kotlinx_collections_immutable(), currentKey, 0, k3 != null ? k3.hashCode() : 0, true);
        } else {
            Map map = this.builder;
            K k = this.lastIteratedKey;
            TypeIntrinsics.asMutableMap((Object)map).remove(k);
        }
        this.lastIteratedKey = null;
        this.nextWasInvoked = false;
        this.expectedModCount = this.builder.getModCount$kotlinx_collections_immutable();
    }

    public final void setValue(K key, V newValue) {
        if (!this.builder.containsKey(key)) {
            return;
        }
        if (this.hasNext()) {
            Object currentKey = this.currentKey();
            ((Map)this.builder).put(key, newValue);
            Object k = currentKey;
            PersistentHashMapBuilderBaseIterator.resetPath$default(this, k != null ? k.hashCode() : 0, this.builder.getNode$kotlinx_collections_immutable(), currentKey, 0, 0, false, 48, null);
        } else {
            ((Map)this.builder).put(key, newValue);
        }
        this.expectedModCount = this.builder.getModCount$kotlinx_collections_immutable();
    }

    private final void resetPath(int keyHash, TrieNode<?, ?> node, K key, int pathIndex, int removedKeyHash, boolean afterRemove) {
        int shift = pathIndex * 5;
        if (shift > 30) {
            this.getPath()[pathIndex].reset(node.getBuffer$kotlinx_collections_immutable(), node.getBuffer$kotlinx_collections_immutable().length, 0);
            while (!Intrinsics.areEqual(this.getPath()[pathIndex].currentKey(), key)) {
                this.getPath()[pathIndex].moveToNextKey();
            }
            this.setPathLastIndex(pathIndex);
            return;
        }
        int keyPositionMask = 1 << TrieNodeKt.indexSegment(keyHash, shift);
        if (node.hasEntryAt$kotlinx_collections_immutable(keyPositionMask)) {
            int removedKeyPositionMask;
            int keyIndex = node.entryKeyIndex$kotlinx_collections_immutable(keyPositionMask);
            int n = removedKeyPositionMask = afterRemove ? 1 << TrieNodeKt.indexSegment(removedKeyHash, shift) : 0;
            if (keyPositionMask == removedKeyPositionMask && pathIndex < this.getPathLastIndex()) {
                Object[] objectArray = new Object[]{node.getBuffer$kotlinx_collections_immutable()[keyIndex], node.getBuffer$kotlinx_collections_immutable()[keyIndex + 1]};
                this.getPath()[this.getPathLastIndex()].reset(objectArray, 2);
                return;
            }
            this.getPath()[pathIndex].reset(node.getBuffer$kotlinx_collections_immutable(), 2 * node.entryCount$kotlinx_collections_immutable(), keyIndex);
            this.setPathLastIndex(pathIndex);
            return;
        }
        int nodeIndex = node.nodeIndex$kotlinx_collections_immutable(keyPositionMask);
        TrieNode<?, ?> targetNode = node.nodeAtIndex$kotlinx_collections_immutable(nodeIndex);
        this.getPath()[pathIndex].reset(node.getBuffer$kotlinx_collections_immutable(), 2 * node.entryCount$kotlinx_collections_immutable(), nodeIndex);
        this.resetPath(keyHash, targetNode, key, pathIndex + 1, removedKeyHash, afterRemove);
    }

    static /* synthetic */ void resetPath$default(PersistentHashMapBuilderBaseIterator persistentHashMapBuilderBaseIterator, int n, TrieNode trieNode, Object object, int n2, int n3, boolean bl, int n4, Object object2) {
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: resetPath");
        }
        if ((n4 & 0x10) != 0) {
            n3 = 0;
        }
        if ((n4 & 0x20) != 0) {
            bl = false;
        }
        persistentHashMapBuilderBaseIterator.resetPath(n, trieNode, object, n2, n3, bl);
    }

    private final void checkNextWasInvoked() {
        if (!this.nextWasInvoked) {
            throw new IllegalStateException();
        }
    }

    private final void checkForComodification() {
        if (this.builder.getModCount$kotlinx_collections_immutable() != this.expectedModCount) {
            throw new ConcurrentModificationException();
        }
    }
}

