/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import java.awt.Color;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Constants;
import net.sf.freecol.common.model.DiplomaticTrade;
import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.ExportData;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Monarch;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.NationOptions;
import net.sf.freecol.common.model.NationType;
import net.sf.freecol.common.model.NativeTrade;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Region;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.TradeRoute;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.networking.AbandonColonyMessage;
import net.sf.freecol.common.networking.AskSkillMessage;
import net.sf.freecol.common.networking.AssignTeacherMessage;
import net.sf.freecol.common.networking.AssignTradeRouteMessage;
import net.sf.freecol.common.networking.AttackMessage;
import net.sf.freecol.common.networking.AttackRangedMessage;
import net.sf.freecol.common.networking.BuildColonyMessage;
import net.sf.freecol.common.networking.CashInTreasureTrainMessage;
import net.sf.freecol.common.networking.ChangeStateMessage;
import net.sf.freecol.common.networking.ChangeWorkImprovementTypeMessage;
import net.sf.freecol.common.networking.ChangeWorkTypeMessage;
import net.sf.freecol.common.networking.ChatMessage;
import net.sf.freecol.common.networking.ChooseFoundingFatherMessage;
import net.sf.freecol.common.networking.ClaimLandMessage;
import net.sf.freecol.common.networking.ClearSpecialityMessage;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DeclareIndependenceMessage;
import net.sf.freecol.common.networking.DeclineMoundsMessage;
import net.sf.freecol.common.networking.DeleteTradeRouteMessage;
import net.sf.freecol.common.networking.DeliverGiftMessage;
import net.sf.freecol.common.networking.DemandTributeMessage;
import net.sf.freecol.common.networking.DiplomacyMessage;
import net.sf.freecol.common.networking.DisbandUnitMessage;
import net.sf.freecol.common.networking.DisembarkMessage;
import net.sf.freecol.common.networking.EmbarkMessage;
import net.sf.freecol.common.networking.EmigrateUnitMessage;
import net.sf.freecol.common.networking.EquipForRoleMessage;
import net.sf.freecol.common.networking.FirstContactMessage;
import net.sf.freecol.common.networking.HighScoresMessage;
import net.sf.freecol.common.networking.InciteMessage;
import net.sf.freecol.common.networking.IndianDemandMessage;
import net.sf.freecol.common.networking.JoinColonyMessage;
import net.sf.freecol.common.networking.LearnSkillMessage;
import net.sf.freecol.common.networking.LoadGoodsMessage;
import net.sf.freecol.common.networking.LoginMessage;
import net.sf.freecol.common.networking.LogoutMessage;
import net.sf.freecol.common.networking.LootCargoMessage;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.common.networking.MessageHandler;
import net.sf.freecol.common.networking.MissionaryMessage;
import net.sf.freecol.common.networking.MonarchActionMessage;
import net.sf.freecol.common.networking.MoveMessage;
import net.sf.freecol.common.networking.MoveToMessage;
import net.sf.freecol.common.networking.NationSummaryMessage;
import net.sf.freecol.common.networking.NativeGiftMessage;
import net.sf.freecol.common.networking.NativeTradeMessage;
import net.sf.freecol.common.networking.NewLandNameMessage;
import net.sf.freecol.common.networking.NewRegionNameMessage;
import net.sf.freecol.common.networking.NewTradeRouteMessage;
import net.sf.freecol.common.networking.PayArrearsMessage;
import net.sf.freecol.common.networking.PayForBuildingMessage;
import net.sf.freecol.common.networking.PutOutsideColonyMessage;
import net.sf.freecol.common.networking.ReadyMessage;
import net.sf.freecol.common.networking.RearrangeColonyMessage;
import net.sf.freecol.common.networking.RenameMessage;
import net.sf.freecol.common.networking.ScoutIndianSettlementMessage;
import net.sf.freecol.common.networking.ScoutSpeakToChiefMessage;
import net.sf.freecol.common.networking.SetAvailableMessage;
import net.sf.freecol.common.networking.SetBuildQueueMessage;
import net.sf.freecol.common.networking.SetColorMessage;
import net.sf.freecol.common.networking.SetCurrentStopMessage;
import net.sf.freecol.common.networking.SetDestinationMessage;
import net.sf.freecol.common.networking.SetGoodsLevelsMessage;
import net.sf.freecol.common.networking.SetNationMessage;
import net.sf.freecol.common.networking.SetNationTypeMessage;
import net.sf.freecol.common.networking.SpySettlementMessage;
import net.sf.freecol.common.networking.TrainUnitInEuropeMessage;
import net.sf.freecol.common.networking.TrivialMessage;
import net.sf.freecol.common.networking.UnloadGoodsMessage;
import net.sf.freecol.common.networking.UpdateGameOptionsMessage;
import net.sf.freecol.common.networking.UpdateMapGeneratorOptionsMessage;
import net.sf.freecol.common.networking.UpdateTradeRouteMessage;
import net.sf.freecol.common.networking.WorkMessage;
import net.sf.freecol.common.option.OptionGroup;

public abstract class ServerAPI {
    private static final Logger logger = Logger.getLogger(ServerAPI.class.getName());

    public abstract Connection connect(String var1, String var2, int var3) throws IOException;

    public abstract boolean disconnect();

    public abstract Connection reconnect() throws IOException;

    public abstract Connection getConnection();

    public void setMessageHandler(MessageHandler mh) {
        Connection c = this.getConnection();
        if (c != null) {
            c.setMessageHandler(mh);
        }
    }

    public boolean isConnected() {
        return this.getConnection() != null;
    }

    private Connection check(String operation, String type) {
        Connection c = this.getConnection();
        if (c == null) {
            logger.log(Level.WARNING, "Not connected, did not " + operation + ": " + type);
        }
        return c;
    }

    private boolean send(Message message) {
        if (message == null) {
            return true;
        }
        Connection c = this.check("send", message.getType());
        if (c != null) {
            try {
                c.send(message);
                return true;
            }
            catch (IOException | XMLStreamException | FreeColException ex) {
                logger.log(Level.WARNING, "Failed to send", ex);
            }
        }
        return false;
    }

    private boolean ask(Message message) {
        if (message == null) {
            return true;
        }
        Connection c = this.check("ask", message.getType());
        if (c != null) {
            try {
                c.request(message);
                return true;
            }
            catch (IOException | XMLStreamException | FreeColException ex) {
                logger.log(Level.WARNING, "Failed to ask", ex);
            }
        }
        return false;
    }

    public boolean abandonColony(Colony colony) {
        return this.ask(new AbandonColonyMessage(colony));
    }

    public boolean answerMonarch(Monarch.MonarchAction action, boolean accept) {
        return this.ask(new MonarchActionMessage(action, null, "").setResult(accept));
    }

    public boolean askSkill(Unit unit, Direction direction) {
        return this.ask(new AskSkillMessage(unit, direction));
    }

    public boolean assignTeacher(Unit student, Unit teacher) {
        return this.ask(new AssignTeacherMessage(student, teacher));
    }

    public boolean assignTradeRoute(Unit unit, TradeRoute tradeRoute) {
        return this.ask(new AssignTradeRouteMessage(unit, tradeRoute));
    }

    public boolean attack(Unit unit, Direction direction) {
        return this.ask(new AttackMessage(unit, direction));
    }

    public boolean attackRanged(Unit unit, Tile target) {
        return this.ask(new AttackRangedMessage(unit, target));
    }

    public boolean buildColony(String name, Unit unit) {
        return this.ask(new BuildColonyMessage(name, unit));
    }

    public boolean cashInTreasureTrain(Unit unit) {
        return this.ask(new CashInTreasureTrainMessage(unit));
    }

    public boolean changeState(Unit unit, Unit.UnitState state) {
        return this.ask(new ChangeStateMessage(unit, state));
    }

    public boolean changeWorkImprovementType(Unit unit, TileImprovementType type) {
        return this.ask(new ChangeWorkImprovementTypeMessage(unit, type));
    }

    public boolean changeWorkType(Unit unit, GoodsType workType) {
        return this.ask(new ChangeWorkTypeMessage(unit, workType));
    }

    public boolean chat(Player player, String chat) {
        return this.send(new ChatMessage(player, chat, false));
    }

    public boolean chooseFoundingFather(List<FoundingFather> ffs, FoundingFather ff) {
        return this.ask(new ChooseFoundingFatherMessage(ffs, ff));
    }

    public boolean claimTile(Tile tile, FreeColGameObject claimant, int price) {
        return this.ask(new ClaimLandMessage(tile, claimant, price));
    }

    public boolean clearSpeciality(Unit unit) {
        return this.ask(new ClearSpecialityMessage(unit));
    }

    public boolean continuePlaying() {
        return this.send(TrivialMessage.continueMessage);
    }

    public boolean declareIndependence(String nation, String country) {
        return this.ask(new DeclareIndependenceMessage(nation, country));
    }

    public boolean declineMounds(Unit unit, Direction direction) {
        return this.ask(new DeclineMoundsMessage(unit, direction));
    }

    public boolean deleteTradeRoute(TradeRoute tradeRoute) {
        return this.ask(new DeleteTradeRouteMessage(tradeRoute));
    }

    public boolean deliverGiftToSettlement(Unit unit, IndianSettlement is, Goods goods) {
        return this.ask(new DeliverGiftMessage(unit, is, goods));
    }

    public boolean demandTribute(Unit unit, Direction direction) {
        return this.ask(new DemandTributeMessage(unit, direction));
    }

    public boolean diplomacy(FreeColGameObject our, FreeColGameObject other, DiplomaticTrade dt) {
        return this.ask(new DiplomacyMessage(our, other, dt));
    }

    public boolean disbandUnit(Unit unit) {
        return this.ask(new DisbandUnitMessage(unit));
    }

    public boolean disembark(Unit unit) {
        return this.ask(new DisembarkMessage(unit));
    }

    public boolean embark(Unit unit, Unit carrier, Direction direction) {
        return this.ask(new EmbarkMessage(unit, carrier, direction));
    }

    public boolean emigrate(int slot) {
        return this.ask(new EmigrateUnitMessage(slot));
    }

    public boolean endTurn() {
        return this.ask(TrivialMessage.endTurnMessage);
    }

    public boolean enterRevengeMode() {
        return this.ask(TrivialMessage.enterRevengeModeMessage);
    }

    public boolean equipUnitForRole(Unit unit, Role role, int roleCount) {
        return this.ask(new EquipForRoleMessage(unit, role, roleCount));
    }

    public boolean firstContact(Player player, Player other, Tile tile, boolean result) {
        return this.ask(new FirstContactMessage(player, other, tile).setResult(result));
    }

    public boolean getHighScores(String key) {
        return this.ask(new HighScoresMessage(key, null));
    }

    public boolean nationSummary(Player self, Player player) {
        return this.ask(new NationSummaryMessage(player, null));
    }

    public boolean incite(Unit unit, IndianSettlement is, Player enemy, int gold) {
        return this.ask(new InciteMessage(unit, is, enemy, gold));
    }

    public boolean indianDemand(Unit unit, Colony colony, GoodsType type, int amount, Constants.IndianDemandAction result) {
        return this.ask(new IndianDemandMessage(unit, colony, type, amount).setResult(result));
    }

    public boolean joinColony(Unit unit, Colony colony) {
        return this.ask(new JoinColonyMessage(colony, unit));
    }

    public boolean learnSkill(Unit unit, Direction direction) {
        return this.ask(new LearnSkillMessage(unit, direction));
    }

    public boolean loadGoods(Location loc, GoodsType type, int amount, Unit carrier) {
        return this.ask(new LoadGoodsMessage(loc, type, amount, carrier));
    }

    public boolean login(String userName, String nationId, String version, boolean single, boolean current) {
        return this.ask(new LoginMessage(null, userName, nationId, version, null, single, current, null));
    }

    public boolean logout(Player player, Game.LogoutReason reason) {
        return this.ask(new LogoutMessage(player, reason));
    }

    public boolean loot(Unit winner, String defenderId, List<Goods> goods) {
        return this.ask(new LootCargoMessage(winner, defenderId, goods));
    }

    public boolean missionary(Unit unit, Direction direction, boolean denounce) {
        return this.ask(new MissionaryMessage(unit, direction, denounce));
    }

    public boolean move(Unit unit, Direction direction) {
        return this.ask(new MoveMessage(unit, direction));
    }

    public boolean moveTo(Unit unit, Location destination) {
        return this.ask(new MoveToMessage(unit, destination));
    }

    public boolean nativeGift(Unit unit, Colony colony) {
        return this.ask(new NativeGiftMessage(unit, colony));
    }

    public boolean newLandName(Unit unit, String name) {
        return this.ask(new NewLandNameMessage(unit, name));
    }

    public boolean nativeTrade(NativeTrade.NativeTradeAction action, NativeTrade nt) {
        return this.ask(new NativeTradeMessage(action, nt));
    }

    public boolean newNativeTradeSession(Unit unit, IndianSettlement is) {
        return this.ask(new NativeTradeMessage(unit, is));
    }

    public boolean newRegionName(Region region, Tile tile, Unit unit, String name) {
        return this.ask(new NewRegionNameMessage(region, tile, unit, name));
    }

    public boolean newTradeRoute() {
        return this.ask(new NewTradeRouteMessage(null));
    }

    public boolean payArrears(GoodsType type) {
        return this.ask(new PayArrearsMessage(type));
    }

    public boolean payForBuilding(Colony colony) {
        return this.ask(new PayForBuildingMessage(colony));
    }

    public boolean putOutsideColony(Unit unit) {
        return this.ask(new PutOutsideColonyMessage(unit));
    }

    public boolean rearrangeColony(Colony colony, List<Unit> workers, Colony scratch) {
        RearrangeColonyMessage message = new RearrangeColonyMessage(colony, workers, scratch);
        return message.isEmpty() ? true : this.ask(message);
    }

    public boolean rename(FreeColGameObject object, String name) {
        return this.ask(new RenameMessage(object, name));
    }

    public boolean requestLaunch() {
        return this.send(TrivialMessage.requestLaunchMessage);
    }

    public boolean retire() {
        return this.ask(TrivialMessage.retireMessage);
    }

    public boolean scoutSettlement(Unit unit, Direction direction) {
        return this.ask(new ScoutIndianSettlementMessage(unit, direction));
    }

    public boolean scoutSpeakToChief(Unit unit, IndianSettlement is) {
        return this.ask(new ScoutSpeakToChiefMessage(unit, is, null));
    }

    public boolean setAvailable(Nation nation, NationOptions.NationState state) {
        return this.ask(new SetAvailableMessage(nation, state));
    }

    public boolean setBuildQueue(Colony colony, List<BuildableType> buildQueue) {
        return this.ask(new SetBuildQueueMessage(colony, buildQueue));
    }

    public boolean setColor(Nation nation, Color color) {
        return this.ask(new SetColorMessage(nation, color));
    }

    public boolean setCurrentStop(Unit unit, int index) {
        return this.ask(new SetCurrentStopMessage(unit, index));
    }

    public boolean setDestination(Unit unit, Location destination) {
        return this.ask(new SetDestinationMessage(unit, destination));
    }

    public boolean setGoodsLevels(Colony colony, ExportData data) {
        return this.ask(new SetGoodsLevelsMessage(colony, data));
    }

    public boolean setNation(Nation nation) {
        return this.ask(new SetNationMessage(null, nation));
    }

    public boolean setNationType(NationType nationType) {
        return this.ask(new SetNationTypeMessage(null, nationType));
    }

    public boolean setReady(boolean ready) {
        return this.send(new ReadyMessage(null, ready));
    }

    public boolean spy(Unit unit, Settlement settlement) {
        return this.ask(new SpySettlementMessage(unit, settlement));
    }

    public boolean startSkipping() {
        return this.send(TrivialMessage.endTurnMessage);
    }

    public boolean trainUnitInEurope(UnitType type) {
        return this.ask(new TrainUnitInEuropeMessage(type));
    }

    public boolean unloadGoods(GoodsType type, int amount, Unit carrier) {
        return this.ask(new UnloadGoodsMessage(type, amount, carrier));
    }

    public boolean updateGameOptions(OptionGroup gameOptions) {
        return this.send(new UpdateGameOptionsMessage(gameOptions));
    }

    public boolean updateMapGeneratorOptions(OptionGroup mapOptions) {
        return this.send(new UpdateMapGeneratorOptionsMessage(mapOptions));
    }

    public boolean updateTradeRoute(TradeRoute route) {
        return this.ask(new UpdateTradeRouteMessage(route));
    }

    public boolean work(Unit unit, WorkLocation workLocation) {
        return this.ask(new WorkMessage(unit, workLocation));
    }
}

