/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.ai.chat;

import dev.langchain4j.model.output.TokenUsage;
import java.util.function.Supplier;
import javax.swing.SwingWorker;
import org.freeplane.plugin.ai.chat.AIChatService;
import org.freeplane.plugin.ai.chat.AssistantProfileChatMemory;
import org.freeplane.plugin.ai.chat.ChatMemoryRenderEntry;
import org.freeplane.plugin.ai.chat.ChatRequestCancellation;
import org.freeplane.plugin.ai.chat.ChatTokenUsageTracker;
import org.freeplane.plugin.ai.tools.utilities.ToolCallSummary;

class ChatRequestFlow {
    private final RequestCallbacks callbacks;
    private final ChatRequestCancellation requestCancellation;
    private final int contextTooLargeMaxRetries;
    private final ChatTokenUsageTracker tokenUsageTracker;
    private AssistantProfileChatMemory chatMemory;
    private SwingWorker<String, Void> activeWorker;
    private boolean requestInProgress;
    private int activeRequestId;
    private int pendingMemorySize;
    private String pendingUserMessage;
    private int pendingContextTooLargeRetryCount;
    private TokenUsage pendingResponseUsage;

    ChatRequestFlow(RequestCallbacks callbacks, ChatTokenUsageTracker tokenUsageTracker, int contextTooLargeMaxRetries) {
        this.callbacks = callbacks;
        this.tokenUsageTracker = tokenUsageTracker;
        this.contextTooLargeMaxRetries = contextTooLargeMaxRetries;
        this.requestCancellation = new ChatRequestCancellation();
    }

    boolean isRequestActive() {
        return this.requestInProgress;
    }

    Supplier<Boolean> cancellationSupplier() {
        return this.requestCancellation::isCancelled;
    }

    void refreshTokenCounters() {
        this.callbacks.refreshTokenCounters();
    }

    void updateChatMemory(AssistantProfileChatMemory chatMemory) {
        this.chatMemory = chatMemory;
    }

    void onToolCallSummary(ToolCallSummary summary) {
        if (summary == null || !this.callbacks.isToolCallHistoryVisible()) {
            return;
        }
        if (this.chatMemory != null) {
            this.chatMemory.addToolCallSummary(summary.getSummaryText(), summary.getToolCaller());
        }
        this.callbacks.onToolSummaryAppended(ChatMemoryRenderEntry.forToolSummary(summary.getSummaryText(), summary.getToolCaller()));
    }

    void onProviderUsage(TokenUsage usage) {
        if (usage != null && this.tokenUsageTracker != null) {
            this.tokenUsageTracker.recordProviderUsage(usage);
        }
        this.pendingResponseUsage = usage;
    }

    void beginRequest(String userMessage) {
        this.requestCancellation.reset();
        ++this.activeRequestId;
        this.pendingUserMessage = userMessage;
        this.pendingMemorySize = this.callbacks.snapshotMemorySize();
        this.pendingContextTooLargeRetryCount = 0;
        this.requestInProgress = true;
        this.callbacks.onRequestStarted();
    }

    void submitRequest(AIChatService chatService) {
        this.executeRequestWorker(chatService, this.pendingUserMessage, this.activeRequestId);
    }

    void refreshPendingMemorySnapshot() {
        this.pendingMemorySize = this.callbacks.snapshotMemorySize();
    }

    void cancelActiveRequest() {
        if (!this.isRequestActive()) {
            return;
        }
        this.requestCancellation.cancel();
        ++this.activeRequestId;
        if (this.activeWorker != null) {
            this.activeWorker.cancel(true);
        }
        this.requestInProgress = false;
        this.restorePendingRequest();
    }

    void restorePendingRequest() {
        this.callbacks.truncateMemoryToSize(this.pendingMemorySize);
        this.callbacks.synchronizeTranscriptWithMemory();
        this.callbacks.rebuildHistoryFromTranscript();
        this.activeWorker = null;
        this.requestInProgress = false;
        this.callbacks.onRequestRestored(this.pendingUserMessage);
        this.callbacks.onRequestFinished();
        this.callbacks.refreshTokenCounters();
        this.clearPendingRequestState();
    }

    void resetPendingState() {
        this.clearPendingRequestState();
    }

    private void executeRequestWorker(final AIChatService chatService, final String userMessage, final int requestId) {
        this.activeWorker = new SwingWorker<String, Void>(){

            @Override
            protected String doInBackground() {
                return chatService.chat(userMessage);
            }

            @Override
            protected void done() {
                if (requestId != ChatRequestFlow.this.activeRequestId || ChatRequestFlow.this.requestCancellation.isCancelled()) {
                    return;
                }
                try {
                    ChatRequestFlow.this.callbacks.onAssistantResponse((String)this.get());
                    ChatRequestFlow.this.finishRequest();
                }
                catch (Exception error) {
                    if (ChatRequestFlow.this.retryAfterContextTooLarge(error, chatService, requestId)) {
                        return;
                    }
                    ChatRequestFlow.this.callbacks.onAssistantError(String.valueOf(error.getMessage()));
                    ChatRequestFlow.this.restorePendingRequest();
                }
            }
        };
        this.activeWorker.execute();
    }

    private boolean retryAfterContextTooLarge(Exception error, AIChatService chatService, int requestId) {
        if (!this.isContextTooLargeError(error)) {
            return false;
        }
        if (this.pendingContextTooLargeRetryCount >= this.contextTooLargeMaxRetries) {
            return false;
        }
        this.callbacks.truncateMemoryToSize(this.pendingMemorySize);
        if (!this.callbacks.evictOldestTurn()) {
            return false;
        }
        ++this.pendingContextTooLargeRetryCount;
        this.callbacks.synchronizeTranscriptWithMemory();
        this.callbacks.rebuildHistoryFromTranscript();
        this.callbacks.refreshTokenCounters();
        this.executeRequestWorker(chatService, this.pendingUserMessage, requestId);
        return true;
    }

    private boolean isContextTooLargeError(Exception error) {
        if (error == null || error.getMessage() == null) {
            return false;
        }
        String message = error.getMessage().toLowerCase();
        return message.contains("context") && (message.contains("too large") || message.contains("length") || message.contains("maximum context"));
    }

    private void finishRequest() {
        this.applyPostResponseCompaction();
        this.activeWorker = null;
        this.requestInProgress = false;
        this.callbacks.onRequestFinished();
        this.clearPendingRequestState();
    }

    private void clearPendingRequestState() {
        this.pendingMemorySize = 0;
        this.pendingUserMessage = null;
        this.pendingContextTooLargeRetryCount = 0;
        this.pendingResponseUsage = null;
    }

    private void applyPostResponseCompaction() {
        boolean evicted;
        boolean bl = evicted = this.chatMemory != null && this.chatMemory.onResponseTokenUsage(this.pendingResponseUsage);
        if (evicted) {
            this.callbacks.onPostResponseEviction();
        }
    }

    static interface RequestCallbacks {
        public void onRequestStarted();

        public void onRequestFinished();

        public void onRequestRestored(String var1);

        public void onAssistantResponse(String var1);

        public void onAssistantError(String var1);

        public int snapshotMemorySize();

        public void truncateMemoryToSize(int var1);

        public void synchronizeTranscriptWithMemory();

        public void rebuildHistoryFromTranscript();

        public boolean evictOldestTurn();

        public void onPostResponseEviction();

        public void refreshTokenCounters();

        public boolean isToolCallHistoryVisible();

        public void onToolSummaryAppended(ChatMemoryRenderEntry var1);
    }
}

