# SPDX-License-Identifier: GPL-2.0-or-later
# MonoidalCategories: Monoidal and monoidal (co)closed categories
#
# Implementations
#
# THIS FILE IS AUTOMATICALLY GENERATED, SEE CAP_project/CAP/gap/MethodRecordTools.gi

## CoevaluationForDual
InstallMethod( AddCoevaluationForDual,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "CoevaluationForDual", category, func, -1 );
    
end );

InstallMethod( AddCoevaluationForDual,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "CoevaluationForDual", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## CoevaluationForDualWithGivenTensorProduct
InstallMethod( AddCoevaluationForDualWithGivenTensorProduct,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "CoevaluationForDualWithGivenTensorProduct", category, func, -1 );
    
end );

InstallMethod( AddCoevaluationForDualWithGivenTensorProduct,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "CoevaluationForDualWithGivenTensorProduct", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( CoevaluationForDualWithGivenTensorProduct,
                    "CoevaluationForDualWithGivenTensorProduct by calling CoevaluationForDual with the WithGiven argument(s) dropped",
                    [
                        [ CoevaluationForDual, 1 ],
                    ],
  function( cat, s, a, r )
    
    return CoevaluationForDual( cat, a );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( CoevaluationForDual,
                    "CoevaluationForDual by calling CoevaluationForDualWithGivenTensorProduct with the WithGiven object(s)",
                    [
                        [ CoevaluationForDualWithGivenTensorProduct, 1 ],
                        [ TensorUnit, 1 ],
                        [ TensorProductOnObjects, 1 ],
                        [ DualOnObjects, 1 ],
                    ],
  function( cat, a )
    
    return CoevaluationForDualWithGivenTensorProduct( cat, TensorUnit( cat ), a, TensorProductOnObjects( cat, a, DualOnObjects( cat, a ) ) );
    
end : is_with_given_derivation := true );

## IsomorphismFromInternalHomToTensorProductWithDualObject
InstallMethod( AddIsomorphismFromInternalHomToTensorProductWithDualObject,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsomorphismFromInternalHomToTensorProductWithDualObject", category, func, -1 );
    
end );

InstallMethod( AddIsomorphismFromInternalHomToTensorProductWithDualObject,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsomorphismFromInternalHomToTensorProductWithDualObject", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## IsomorphismFromTensorProductWithDualObjectToInternalHom
InstallMethod( AddIsomorphismFromTensorProductWithDualObjectToInternalHom,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "IsomorphismFromTensorProductWithDualObjectToInternalHom", category, func, -1 );
    
end );

InstallMethod( AddIsomorphismFromTensorProductWithDualObjectToInternalHom,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "IsomorphismFromTensorProductWithDualObjectToInternalHom", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## MorphismFromBidual
InstallMethod( AddMorphismFromBidual,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "MorphismFromBidual", category, func, -1 );
    
end );

InstallMethod( AddMorphismFromBidual,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "MorphismFromBidual", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## MorphismFromBidualWithGivenBidual
InstallMethod( AddMorphismFromBidualWithGivenBidual,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "MorphismFromBidualWithGivenBidual", category, func, -1 );
    
end );

InstallMethod( AddMorphismFromBidualWithGivenBidual,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "MorphismFromBidualWithGivenBidual", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( MorphismFromBidualWithGivenBidual,
                    "MorphismFromBidualWithGivenBidual by calling MorphismFromBidual with the WithGiven argument(s) dropped",
                    [
                        [ MorphismFromBidual, 1 ],
                    ],
  function( cat, a, s )
    
    return MorphismFromBidual( cat, a );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( MorphismFromBidual,
                    "MorphismFromBidual by calling MorphismFromBidualWithGivenBidual with the WithGiven object(s)",
                    [
                        [ MorphismFromBidualWithGivenBidual, 1 ],
                        [ DualOnObjects, 2 ],
                    ],
  function( cat, a )
    
    return MorphismFromBidualWithGivenBidual( cat, a, DualOnObjects( cat, DualOnObjects( cat, a ) ) );
    
end : is_with_given_derivation := true );

## MorphismFromInternalHomToTensorProduct
InstallMethod( AddMorphismFromInternalHomToTensorProduct,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "MorphismFromInternalHomToTensorProduct", category, func, -1 );
    
end );

InstallMethod( AddMorphismFromInternalHomToTensorProduct,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "MorphismFromInternalHomToTensorProduct", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## MorphismFromInternalHomToTensorProductWithGivenObjects
InstallMethod( AddMorphismFromInternalHomToTensorProductWithGivenObjects,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "MorphismFromInternalHomToTensorProductWithGivenObjects", category, func, -1 );
    
end );

InstallMethod( AddMorphismFromInternalHomToTensorProductWithGivenObjects,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "MorphismFromInternalHomToTensorProductWithGivenObjects", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( MorphismFromInternalHomToTensorProductWithGivenObjects,
                    "MorphismFromInternalHomToTensorProductWithGivenObjects by calling MorphismFromInternalHomToTensorProduct with the WithGiven argument(s) dropped",
                    [
                        [ MorphismFromInternalHomToTensorProduct, 1 ],
                    ],
  function( cat, s, a, b, r )
    
    return MorphismFromInternalHomToTensorProduct( cat, a, b );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( MorphismFromInternalHomToTensorProduct,
                    "MorphismFromInternalHomToTensorProduct by calling MorphismFromInternalHomToTensorProductWithGivenObjects with the WithGiven object(s)",
                    [
                        [ MorphismFromInternalHomToTensorProductWithGivenObjects, 1 ],
                        [ InternalHomOnObjects, 1 ],
                        [ TensorProductOnObjects, 1 ],
                        [ DualOnObjects, 1 ],
                    ],
  function( cat, a, b )
    
    return MorphismFromInternalHomToTensorProductWithGivenObjects( cat, InternalHomOnObjects( cat, a, b ), a, b, TensorProductOnObjects( cat, DualOnObjects( cat, a ), b ) );
    
end : is_with_given_derivation := true );

## RankMorphism
InstallMethod( AddRankMorphism,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "RankMorphism", category, func, -1 );
    
end );

InstallMethod( AddRankMorphism,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "RankMorphism", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## TensorProductInternalHomCompatibilityMorphismInverse
InstallMethod( AddTensorProductInternalHomCompatibilityMorphismInverse,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "TensorProductInternalHomCompatibilityMorphismInverse", category, func, -1 );
    
end );

InstallMethod( AddTensorProductInternalHomCompatibilityMorphismInverse,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "TensorProductInternalHomCompatibilityMorphismInverse", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

## TensorProductInternalHomCompatibilityMorphismInverseWithGivenObjects
InstallMethod( AddTensorProductInternalHomCompatibilityMorphismInverseWithGivenObjects,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "TensorProductInternalHomCompatibilityMorphismInverseWithGivenObjects", category, func, -1 );
    
end );

InstallMethod( AddTensorProductInternalHomCompatibilityMorphismInverseWithGivenObjects,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "TensorProductInternalHomCompatibilityMorphismInverseWithGivenObjects", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);

AddDerivationToCAP( TensorProductInternalHomCompatibilityMorphismInverseWithGivenObjects,
                    "TensorProductInternalHomCompatibilityMorphismInverseWithGivenObjects by calling TensorProductInternalHomCompatibilityMorphismInverse with the WithGiven argument(s) dropped",
                    [
                        [ TensorProductInternalHomCompatibilityMorphismInverse, 1 ],
                    ],
  function( cat, source, list, range )
    
    return TensorProductInternalHomCompatibilityMorphismInverse( cat, list );
        
end : is_with_given_derivation := true );

AddDerivationToCAP( TensorProductInternalHomCompatibilityMorphismInverse,
                    "TensorProductInternalHomCompatibilityMorphismInverse by calling TensorProductInternalHomCompatibilityMorphismInverseWithGivenObjects with the WithGiven object(s)",
                    [
                        [ TensorProductInternalHomCompatibilityMorphismInverseWithGivenObjects, 1 ],
                        [ InternalHomOnObjects, 3 ],
                        [ TensorProductOnObjects, 3 ],
                    ],
  function( cat, list )
    
    return TensorProductInternalHomCompatibilityMorphismInverseWithGivenObjects( cat, InternalHomOnObjects( cat, TensorProductOnObjects( cat, list[1], list[3] ), TensorProductOnObjects( cat, list[2], list[4] ) ), list, TensorProductOnObjects( cat, InternalHomOnObjects( cat, list[1], list[2] ), InternalHomOnObjects( cat, list[3], list[4] ) ) );
    
end : is_with_given_derivation := true );

## TraceMap
InstallMethod( AddTraceMap,
               [ IsCapCategory, IsFunction ],
               
  function( category, func )
    
    AddCapOperation( "TraceMap", category, func, -1 );
    
end );

InstallMethod( AddTraceMap,
               [ IsCapCategory, IsFunction, IsInt ],
               
    FunctionWithNamedArguments(
        [
            [ "IsPrecompiledDerivation", false ],
        ],
        function( CAP_NAMED_ARGUMENTS, category, func, weight )
            
            AddCapOperation( "TraceMap", category, func, weight : IsPrecompiledDerivation := CAP_NAMED_ARGUMENTS.IsPrecompiledDerivation );
            
        end
    )
);
