/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.geonames;

import java.util.ArrayList;
import java.util.List;
import org.fibs.geotag.Settings;

public class GeonamesService {
    static final String FIND_NEARBY = "findNearby";
    static final String FIND_NEARBY_WIKIPEDIA = "findNearbyWikipedia";
    static final String ALTITUDE = "srtm3";
    private String serviceName;
    private List<Parameter> parameters = new ArrayList<Parameter>();

    public GeonamesService(String name) {
        this.serviceName = name;
    }

    public void addParameter(String name, String value) {
        this.parameters.add(new Parameter(name, value));
    }

    public void addParameter(String name, int value) {
        this.parameters.add(new Parameter(name, "" + value));
    }

    public void addParameter(String name, double value) {
        this.parameters.add(new Parameter(name, "" + value));
    }

    String getServiceName() {
        return this.serviceName;
    }

    List<Parameter> getParameters() {
        return this.parameters;
    }

    public String buildURL() {
        StringBuilder url = new StringBuilder("http://");
        url.append(Settings.get(Settings.SETTING.GEONAMES_URL, "api.geonames.org"));
        url.append('/').append(this.getServiceName()).append('?');
        for (Parameter parameter : this.getParameters()) {
            url.append(parameter.getName()).append('=').append(parameter.getValue());
            url.append('&');
        }
        url.append("username=");
        url.append("geotag");
        return url.toString();
    }

    private static class Parameter {
        private String name;
        private String value;

        public Parameter(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

