/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.Util;
import java.security.Key;
import java.security.SecureRandom;
import java.text.MessageFormat;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

final class SecureStringUtil {
    static final String CIPHER_TRANSFORMATION = "AES/GCM/NoPadding";
    static final String KEYGEN_ALGORITHEM = "AES";
    static final int IV_LENGTH = 12;
    static final int KEY_SIZE = 256;
    static final int TAG_LENGTH = 16;
    SecretKeySpec secretKey;
    private Cipher encryptCipher;
    private Cipher decryptCipher;
    private static SecureStringUtil instance;

    static SecureStringUtil getInstance() throws SQLServerException {
        if (instance == null) {
            instance = new SecureStringUtil();
        }
        return instance;
    }

    private SecureStringUtil() throws SQLServerException {
        try {
            KeyGenerator keygen = KeyGenerator.getInstance(KEYGEN_ALGORITHEM);
            keygen.init(256);
            this.secretKey = new SecretKeySpec(keygen.generateKey().getEncoded(), KEYGEN_ALGORITHEM);
            this.encryptCipher = Cipher.getInstance(CIPHER_TRANSFORMATION);
            this.decryptCipher = Cipher.getInstance(CIPHER_TRANSFORMATION);
        }
        catch (Exception e) {
            MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_SecureStringInitFailed"));
            Object[] msgArgs = new Object[]{e.getMessage()};
            throw new SQLServerException((Object)this, form.format(msgArgs), null, 0, false);
        }
    }

    byte[] getEncryptedBytes(char[] chars) throws SQLServerException {
        if (chars == null) {
            return null;
        }
        byte[] iv = new byte[12];
        SecureRandom random = new SecureRandom();
        random.nextBytes(iv);
        GCMParameterSpec ivParamSpec = new GCMParameterSpec(128, iv);
        try {
            this.encryptCipher.init(1, (Key)this.secretKey, ivParamSpec);
            byte[] cipherText = this.encryptCipher.doFinal(Util.charsToBytes(chars));
            byte[] bytes = new byte[iv.length + cipherText.length];
            System.arraycopy(iv, 0, bytes, 0, iv.length);
            System.arraycopy(cipherText, 0, bytes, iv.length, cipherText.length);
            return bytes;
        }
        catch (Exception e) {
            MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_EncryptionFailed"));
            Object[] msgArgs = new Object[]{e.getMessage()};
            throw new SQLServerException((Object)this, form.format(msgArgs), null, 0, false);
        }
    }

    char[] getDecryptedChars(byte[] bytes) throws SQLServerException {
        char[] cArray;
        block6: {
            if (bytes == null) {
                return null;
            }
            byte[] iv = new byte[12];
            System.arraycopy(bytes, 0, iv, 0, 12);
            GCMParameterSpec ivParamSpec = new GCMParameterSpec(128, iv);
            byte[] plainText = null;
            try {
                this.decryptCipher.init(2, (Key)this.secretKey, ivParamSpec);
                plainText = this.decryptCipher.doFinal(bytes, 12, bytes.length - 12);
                cArray = Util.bytesToChars(plainText);
                if (plainText == null) break block6;
            }
            catch (Exception e) {
                try {
                    MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_DecryptionFailed"));
                    Object[] msgArgs = new Object[]{e.getMessage()};
                    throw new SQLServerException((Object)this, form.format(msgArgs), null, 0, false);
                }
                catch (Throwable throwable) {
                    if (plainText != null) {
                        Arrays.fill(plainText, (byte)0);
                    }
                    throw throwable;
                }
            }
            Arrays.fill(plainText, (byte)0);
        }
        return cArray;
    }
}

