/*
 * Decompiled with CFR 0.152.
 */
package ghidra.jython;

import db.Transaction;
import generic.jar.ResourceFile;
import ghidra.app.plugin.core.interpreter.InterpreterConsole;
import ghidra.app.script.GhidraState;
import ghidra.app.script.ScriptControls;
import ghidra.framework.plugintool.PluginTool;
import ghidra.jython.JythonPlugin;
import ghidra.jython.JythonScript;
import ghidra.program.model.listing.Program;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import org.python.core.PyException;
import org.python.core.PyObject;

class JythonPluginExecutionThread
extends Thread {
    private JythonPlugin plugin;
    private String cmd;
    private AtomicBoolean moreInputWanted;

    JythonPluginExecutionThread(JythonPlugin plugin, String cmd, AtomicBoolean moreInputWanted) {
        super("Jython plugin execution thread");
        this.plugin = plugin;
        this.cmd = cmd;
        this.moreInputWanted = moreInputWanted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        TaskMonitor interactiveTaskMonitor = this.plugin.getInteractiveTaskMonitor();
        JythonScript interactiveScript = this.plugin.getInteractiveScript();
        Program program = this.plugin.getCurrentProgram();
        InterpreterConsole console = this.plugin.getConsole();
        try (Transaction tx = program != null ? program.openTransaction("Jython command") : null;){
            interactiveTaskMonitor.clearCancelled();
            interactiveScript.setSourceFile(new ResourceFile(new File("jython")));
            PluginTool tool = this.plugin.getTool();
            interactiveScript.set(new GhidraState(tool, tool.getProject(), program, this.plugin.getProgramLocation(), this.plugin.getProgramSelection(), this.plugin.getProgramHighlight()), new ScriptControls(console, interactiveTaskMonitor));
            this.moreInputWanted.set(false);
            this.moreInputWanted.set(this.plugin.getInterpreter().push(this.cmd, this.plugin.getInteractiveScript()));
        }
        catch (PyException pye) {
            String exceptionName = PyException.exceptionClassName((PyObject)pye.type);
            if (exceptionName.equalsIgnoreCase("exceptions.SystemExit")) {
                this.plugin.reset();
            } else {
                console.getErrWriter().println("Suppressing exception: " + PyException.exceptionClassName((PyObject)pye.type));
            }
        }
        catch (StackOverflowError soe) {
            console.getErrWriter().println("Stack overflow!");
        }
        finally {
            interactiveScript.end(false);
        }
    }
}

