/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.nav;

import ghidra.framework.options.SaveState;
import ghidra.program.model.listing.Program;
import ghidra.program.util.AddressFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class LocationMemento {
    private static final String PROGRAM_PATH = "PROGRAM_PATH_";
    private static final String PROGRAM_ID = "PROGRAM_ID";
    private static final String MEMENTO_CLASS = "MEMENTO_CLASS";
    protected final ProgramLocation programLocation;
    private final Program program;

    public LocationMemento(Program program, ProgramLocation location) {
        this.program = program;
        this.programLocation = location;
    }

    public LocationMemento(SaveState saveState, Program[] programs) {
        String programPath = saveState.getString(PROGRAM_PATH, null);
        long programID = saveState.getLong(PROGRAM_ID, -1L);
        this.program = this.getProgram(programs, programPath, programID);
        if (this.program == null) {
            throw new IllegalArgumentException("Unable to find program: " + programPath);
        }
        this.programLocation = ProgramLocation.getLocation((Program)this.program, (SaveState)saveState);
        if (this.programLocation == null) {
            throw new IllegalArgumentException("Unable to create a program location!");
        }
    }

    public boolean isValid() {
        return this.program != null && this.programLocation != null;
    }

    private Program getProgram(Program[] programs, String pathName, long programID) {
        for (Program potentialProgram : programs) {
            if (potentialProgram.getUniqueProgramID() != programID) continue;
            return potentialProgram;
        }
        return null;
    }

    public String getLocationDescription() {
        return this.programLocation.getAddress().toString();
    }

    public Program getProgram() {
        return this.program;
    }

    public ProgramLocation getProgramLocation() {
        return this.programLocation;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LocationMemento)) {
            return false;
        }
        LocationMemento other = (LocationMemento)obj;
        return this.program == other.program && this.compareLocations(this.programLocation, other.programLocation);
    }

    public int hashCode() {
        boolean isGeneric;
        int prime = 31;
        int result = 1;
        result = 31 * result + this.program.hashCode();
        Class<?> clazz = this.programLocation.getClass();
        boolean bl = isGeneric = this.programLocation instanceof AddressFieldLocation || clazz == ProgramLocation.class;
        if (!isGeneric) {
            result = 31 * result + this.programLocation.getClass().hashCode();
        }
        result = 31 * result + this.programLocation.getAddress().hashCode();
        return result;
    }

    public String toString() {
        return "LocationMemento[location=" + String.valueOf(this.programLocation) + "]";
    }

    private boolean compareLocations(ProgramLocation loc1, ProgramLocation loc2) {
        if (loc1 == null || loc2 == null) {
            return false;
        }
        if (loc1.equals((Object)loc2)) {
            return true;
        }
        if (!SystemUtilities.isEqual((Object)loc1.getAddress(), (Object)loc2.getAddress())) {
            return false;
        }
        if (loc1.getClass() == loc2.getClass()) {
            return true;
        }
        boolean isAddr1 = loc1 instanceof AddressFieldLocation || loc1.getClass() == ProgramLocation.class;
        boolean isAddr2 = loc2 instanceof AddressFieldLocation || loc2.getClass() == ProgramLocation.class;
        return isAddr1 & isAddr2;
    }

    public void saveState(SaveState saveState) {
        saveState.putString(MEMENTO_CLASS, this.getClass().getName());
        saveState.putString(PROGRAM_PATH, this.program.getDomainFile().toString());
        saveState.putLong(PROGRAM_ID, this.program.getUniqueProgramID());
        this.programLocation.saveState(saveState);
    }

    public static LocationMemento getLocationMemento(SaveState saveState, Program[] programs) {
        String className = saveState.getString(MEMENTO_CLASS, null);
        if (className == null) {
            return null;
        }
        try {
            Class<?> mementoClass = Class.forName(className);
            Constructor<?> constructor = mementoClass.getConstructor(SaveState.class, Program[].class);
            return (LocationMemento)constructor.newInstance(saveState, programs);
        }
        catch (ClassNotFoundException mementoClass) {
        }
        catch (InstantiationException e) {
            Msg.showError(ProgramLocation.class, null, (String)"Programming Error", (Object)("Class " + className + " must have public constructor!"), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            Msg.showError(ProgramLocation.class, null, (String)"Programming Error", (Object)("Class " + className + " must have public constructor!"), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            Msg.showError(ProgramLocation.class, null, (String)"Programming Error", (Object)("Class " + className + " must have a public constructor that takes a SaveState and a Program[]!"), (Throwable)e);
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)cause;
            }
            String message = cause == null ? "" : cause.getMessage();
            throw new IllegalArgumentException("Unexpected exception restoring memento: " + message);
        }
        return null;
    }
}

