/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr;

import docking.ComponentProvider;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.support.GTreeNodeTransferable;
import ghidra.app.context.ProgramActionContext;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.DataTypesProvider;
import ghidra.app.plugin.core.datamgr.archive.BuiltInSourceArchive;
import ghidra.app.plugin.core.datamgr.archive.ProjectArchive;
import ghidra.app.plugin.core.datamgr.tree.DataTypeArchiveGTree;
import ghidra.app.plugin.core.datamgr.tree.DataTypeNode;
import ghidra.app.plugin.core.datamgr.tree.ProjectArchiveNode;
import ghidra.framework.main.datatable.DomainFileContext;
import ghidra.framework.model.DomainFile;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.SourceArchive;
import ghidra.program.model.listing.Program;
import java.awt.Component;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.tree.TreePath;

public class DataTypesActionContext
extends ProgramActionContext
implements DomainFileContext {
    private final GTreeNode clickedNode;
    private final boolean isToolbarAction;
    private DataTypeArchiveGTree archiveGTree;
    private List<DomainFile> domainFiles;
    private List<GTreeNode> clipboardNodes;

    public DataTypesActionContext(DataTypesProvider provider, Program program, DataTypeArchiveGTree archiveGTree, GTreeNode clickedNode) {
        this(provider, program, archiveGTree, clickedNode, false);
    }

    public DataTypesActionContext(DataTypesProvider provider, Program program, DataTypeArchiveGTree archiveGTree, GTreeNode clickedNode, boolean isToolbarAction) {
        super((ComponentProvider)provider, program, (Component)((Object)archiveGTree));
        this.archiveGTree = archiveGTree;
        this.clickedNode = clickedNode;
        this.isToolbarAction = isToolbarAction;
    }

    public List<GTreeNode> getClipboardNodes() {
        if (this.clipboardNodes != null) {
            return this.clipboardNodes;
        }
        DataTypesProvider dtProvider = (DataTypesProvider)this.getComponentProvider();
        DataTypeManagerPlugin plugin = dtProvider.getPlugin();
        Clipboard clipboard = plugin.getClipboard();
        Transferable transferable = clipboard.getContents((Object)this);
        if (transferable instanceof GTreeNodeTransferable) {
            GTreeNodeTransferable gtTransferable = (GTreeNodeTransferable)transferable;
            this.clipboardNodes = gtTransferable.getAllData();
        }
        if (this.clipboardNodes == null) {
            this.clipboardNodes = Collections.emptyList();
        }
        return this.clipboardNodes;
    }

    public boolean isToolbarAction() {
        return this.isToolbarAction;
    }

    public GTreeNode getClickedNode() {
        return this.clickedNode;
    }

    public List<DomainFile> getSelectedFiles() {
        if (this.domainFiles == null) {
            TreePath[] selectionPaths = this.archiveGTree.getSelectionPaths();
            this.domainFiles = new ArrayList<DomainFile>();
            for (TreePath path : selectionPaths) {
                Object lastPathComponent = path.getLastPathComponent();
                if (!(lastPathComponent instanceof ProjectArchiveNode)) continue;
                ProjectArchiveNode node = (ProjectArchiveNode)((Object)lastPathComponent);
                ProjectArchive archive = (ProjectArchive)node.getArchive();
                DomainFile originalDomainFile = archive.getDomainFile();
                this.domainFiles.add(originalDomainFile);
            }
        }
        return this.domainFiles;
    }

    public int getFileCount() {
        return this.getSelectedFiles().size();
    }

    public boolean isInActiveProject() {
        return true;
    }

    public List<GTreeNode> getSelectedNodes() {
        Object contextObject = this.getContextObject();
        GTree gTree = (GTree)contextObject;
        return gTree.getSelectedNodes();
    }

    public List<DataTypeNode> getDisassociatableNodes() {
        Object contextObject = this.getContextObject();
        GTree gTree = (GTree)contextObject;
        TreePath[] selectionPaths = gTree.getSelectionPaths();
        return this.getDisassociatableNodes(selectionPaths);
    }

    private List<DataTypeNode> getDisassociatableNodes(TreePath[] paths) {
        ArrayList<DataTypeNode> nodes = new ArrayList<DataTypeNode>();
        for (TreePath treePath : paths) {
            DataTypeNode node = this.getDisassociatableNode(treePath);
            if (node == null) continue;
            nodes.add(node);
        }
        return nodes;
    }

    private DataTypeNode getDisassociatableNode(TreePath path) {
        GTreeNode node = (GTreeNode)path.getLastPathComponent();
        if (!(node instanceof DataTypeNode)) {
            return null;
        }
        DataTypeNode dataTypeNode = (DataTypeNode)node;
        DataType dataType = dataTypeNode.getDataType();
        DataTypeManager dataTypeManager = dataType.getDataTypeManager();
        SourceArchive sourceArchive = dataType.getSourceArchive();
        if (sourceArchive == null || dataTypeManager == null || sourceArchive.equals((Object)BuiltInSourceArchive.INSTANCE) || sourceArchive.getSourceArchiveID().equals((Object)dataTypeManager.getUniversalID())) {
            return null;
        }
        return dataTypeNode;
    }
}

