/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.pe.ArchitectureDataDirectory;
import ghidra.app.util.bin.format.pe.BaseRelocationDataDirectory;
import ghidra.app.util.bin.format.pe.BoundImportDataDirectory;
import ghidra.app.util.bin.format.pe.COMDescriptorDataDirectory;
import ghidra.app.util.bin.format.pe.DataDirectory;
import ghidra.app.util.bin.format.pe.DebugDataDirectory;
import ghidra.app.util.bin.format.pe.DelayImportDataDirectory;
import ghidra.app.util.bin.format.pe.ExceptionDataDirectory;
import ghidra.app.util.bin.format.pe.ExportDataDirectory;
import ghidra.app.util.bin.format.pe.GlobalPointerDataDirectory;
import ghidra.app.util.bin.format.pe.ImageCor20Header;
import ghidra.app.util.bin.format.pe.ImportAddressTableDataDirectory;
import ghidra.app.util.bin.format.pe.ImportDataDirectory;
import ghidra.app.util.bin.format.pe.LoadConfigDataDirectory;
import ghidra.app.util.bin.format.pe.NTHeader;
import ghidra.app.util.bin.format.pe.PortableExecutable;
import ghidra.app.util.bin.format.pe.ResourceDataDirectory;
import ghidra.app.util.bin.format.pe.SecurityDataDirectory;
import ghidra.app.util.bin.format.pe.TLSDataDirectory;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Pointer32DataType;
import ghidra.program.model.data.Pointer64DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.DataConverter;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.RandomAccessFile;

public class OptionalHeader
implements StructConverter {
    public static final int IMAGE_DLLCHARACTERISTICS_HIGH_ENTROPY_VA = 32;
    public static final int IMAGE_DLLCHARACTERISTICS_DYNAMIC_BASE = 64;
    public static final int IMAGE_DLLCHARACTERISTICS_FORCE_INTEGRITY = 128;
    public static final int IMAGE_DLLCHARACTERISTICS_NX_COMPAT = 256;
    public static final int IMAGE_DLLCHARACTERISTICS_NO_ISOLATION = 512;
    public static final int IMAGE_DLLCHARACTERISTICS_NO_SEH = 1024;
    public static final int IMAGE_DLLCHARACTERISTICS_NO_BIND = 2048;
    public static final int IMAGE_DLLCHARACTERISTICS_APPCONTAINER = 4096;
    public static final int IMAGE_DLLCHARACTERISTICS_WDM_DRIVER = 8192;
    public static final int IMAGE_DLLCHARACTERISTICS_GUARD_CF = 16384;
    public static final int IMAGE_DLLCHARACTERISTICS_TERMINAL_SERVER_AWARE = 32768;
    public static final byte IMAGE_NUMBEROF_DIRECTORY_ENTRIES = 16;
    public static final byte IMAGE_DIRECTORY_ENTRY_EXPORT = 0;
    public static final byte IMAGE_DIRECTORY_ENTRY_IMPORT = 1;
    public static final byte IMAGE_DIRECTORY_ENTRY_RESOURCE = 2;
    public static final byte IMAGE_DIRECTORY_ENTRY_EXCEPTION = 3;
    public static final byte IMAGE_DIRECTORY_ENTRY_SECURITY = 4;
    public static final byte IMAGE_DIRECTORY_ENTRY_BASERELOC = 5;
    public static final byte IMAGE_DIRECTORY_ENTRY_DEBUG = 6;
    public static final byte IMAGE_DIRECTORY_ENTRY_ARCHITECTURE = 7;
    public static final byte IMAGE_DIRECTORY_ENTRY_GLOBALPTR = 8;
    public static final byte IMAGE_DIRECTORY_ENTRY_TLS = 9;
    public static final byte IMAGE_DIRECTORY_ENTRY_LOAD_CONFIG = 10;
    public static final byte IMAGE_DIRECTORY_ENTRY_BOUND_IMPORT = 11;
    public static final byte IMAGE_DIRECTORY_ENTRY_IAT = 12;
    public static final byte IMAGE_DIRECTORY_ENTRY_DELAY_IMPORT = 13;
    public static final byte IMAGE_DIRECTORY_ENTRY_COM_DESCRIPTOR = 14;
    public static final byte IMAGE_DIRECTORY_ENTRY_COMHEADER = 14;
    protected short magic;
    protected byte majorLinkerVersion;
    protected byte minorLinkerVersion;
    protected int sizeOfCode;
    protected int sizeOfInitializedData;
    protected int sizeOfUninitializedData;
    protected int addressOfEntryPoint;
    protected int baseOfCode;
    protected int baseOfData;
    protected long imageBase;
    protected int sectionAlignment;
    protected int fileAlignment;
    protected short majorOperatingSystemVersion;
    protected short minorOperatingSystemVersion;
    protected short majorImageVersion;
    protected short minorImageVersion;
    protected short majorSubsystemVersion;
    protected short minorSubsystemVersion;
    protected int win32VersionValue;
    protected int sizeOfImage;
    protected int sizeOfHeaders;
    protected int checkSum;
    protected short subsystem;
    protected short dllCharacteristics;
    protected long sizeOfStackReserve;
    protected long sizeOfStackCommit;
    protected long sizeOfHeapReserve;
    protected long sizeOfHeapCommit;
    protected int loaderFlags;
    protected int numberOfRvaAndSizes;
    protected DataDirectory[] dataDirectory;
    protected NTHeader ntHeader;
    protected BinaryReader reader;
    protected int startIndex;
    private long startOfDataDirs;

    OptionalHeader(NTHeader ntHeader, BinaryReader reader, int startIndex) throws IOException {
        this.ntHeader = ntHeader;
        this.reader = reader;
        this.startIndex = startIndex;
        this.parse();
    }

    protected void parse() throws IOException {
        int characteristics;
        this.reader.setPointerIndex(this.startIndex);
        this.magic = this.reader.readNextShort();
        if (this.magic != 263 && this.magic != 267 && this.magic != 523) {
            Msg.warn((Object)this, (Object)"Unsupported magic value: 0x%x. Assuming 32-bit.".formatted(this.magic));
        }
        this.majorLinkerVersion = this.reader.readNextByte();
        this.minorLinkerVersion = this.reader.readNextByte();
        this.sizeOfCode = this.reader.readNextInt();
        this.sizeOfInitializedData = this.reader.readNextInt();
        this.sizeOfUninitializedData = this.reader.readNextInt();
        this.addressOfEntryPoint = this.reader.readNextInt();
        if (this.addressOfEntryPoint < 0) {
            Msg.warn((Object)this, (Object)("Negative entry point " + Integer.toHexString(this.addressOfEntryPoint)));
        }
        if (this.addressOfEntryPoint == 0 && ((characteristics = this.ntHeader.getFileHeader().getCharacteristics()) & 0x2000) == 0) {
            Msg.warn((Object)this, (Object)"Zero entry point for non-DLL");
        }
        this.baseOfCode = this.reader.readNextInt();
        if (this.is64bit()) {
            this.baseOfData = -1;
            this.imageBase = this.reader.readNextLong();
        } else {
            this.baseOfData = this.reader.readNextInt();
            this.imageBase = Integer.toUnsignedLong(this.reader.readNextInt());
        }
        this.sectionAlignment = this.reader.readNextInt();
        this.fileAlignment = this.reader.readNextInt();
        if (this.fileAlignment < 512) {
            Msg.warn((Object)this, (Object)("Unusual file alignment: 0x" + Integer.toHexString(this.fileAlignment)));
        }
        this.majorOperatingSystemVersion = this.reader.readNextShort();
        this.minorOperatingSystemVersion = this.reader.readNextShort();
        this.majorImageVersion = this.reader.readNextShort();
        this.minorImageVersion = this.reader.readNextShort();
        this.majorSubsystemVersion = this.reader.readNextShort();
        this.minorSubsystemVersion = this.reader.readNextShort();
        this.win32VersionValue = this.reader.readNextInt();
        this.sizeOfImage = this.reader.readNextInt();
        this.sizeOfHeaders = this.reader.readNextInt();
        if (this.sizeOfHeaders >= this.sizeOfImage) {
            Msg.warn((Object)this, (Object)"Size of headers >= size of image: forced load");
        }
        this.checkSum = this.reader.readNextInt();
        this.subsystem = this.reader.readNextShort();
        this.dllCharacteristics = this.reader.readNextShort();
        if (this.is64bit()) {
            this.sizeOfStackReserve = this.reader.readNextLong();
            this.sizeOfStackCommit = this.reader.readNextLong();
            this.sizeOfHeapReserve = this.reader.readNextLong();
            this.sizeOfHeapCommit = this.reader.readNextLong();
        } else {
            this.sizeOfStackReserve = this.reader.readNextUnsignedInt();
            this.sizeOfStackCommit = this.reader.readNextUnsignedInt();
            this.sizeOfHeapReserve = this.reader.readNextUnsignedInt();
            this.sizeOfHeapCommit = this.reader.readNextUnsignedInt();
        }
        this.loaderFlags = this.reader.readNextInt();
        this.numberOfRvaAndSizes = this.reader.readNextInt();
        if (this.numberOfRvaAndSizes != 16) {
            Msg.warn((Object)this, (Object)("Non-standard # of data directories: " + this.numberOfRvaAndSizes));
            if (this.numberOfRvaAndSizes > 16 || this.numberOfRvaAndSizes < 0) {
                Msg.warn((Object)this, (Object)"Forcing # of data directories to: 16");
                this.numberOfRvaAndSizes = 16;
            }
        }
        this.startOfDataDirs = this.reader.getPointerIndex();
    }

    public void processDataDirectories(MessageLog log, TaskMonitor monitor) {
        this.reader.setPointerIndex(this.startOfDataDirs);
        this.dataDirectory = new DataDirectory[this.numberOfRvaAndSizes];
        if (this.numberOfRvaAndSizes == 0) {
            return;
        }
        int ndata = 0;
        monitor.setMessage("Parsing exports...");
        try {
            this.dataDirectory[ndata] = new ExportDataDirectory(this.ntHeader, this.reader);
        }
        catch (RuntimeException re) {
            if (PortableExecutable.DEBUG) {
                throw re;
            }
        }
        catch (IOException e) {
            log.appendMsg(ExportDataDirectory.class.getSimpleName(), e.getMessage());
        }
        if (++ndata == this.numberOfRvaAndSizes) {
            return;
        }
        monitor.setMessage("Parsing imports...");
        try {
            this.dataDirectory[ndata] = new ImportDataDirectory(this.ntHeader, this.reader);
        }
        catch (RuntimeException re) {
            if (PortableExecutable.DEBUG) {
                throw re;
            }
        }
        catch (IOException e) {
            log.appendMsg(ImportDataDirectory.class.getSimpleName(), e.getMessage());
        }
        if (++ndata == this.numberOfRvaAndSizes) {
            return;
        }
        monitor.setMessage("Parsing resources...");
        try {
            this.dataDirectory[ndata] = new ResourceDataDirectory(this.ntHeader, this.reader);
        }
        catch (RuntimeException re) {
            if (PortableExecutable.DEBUG) {
                throw re;
            }
        }
        catch (IOException e) {
            log.appendMsg(ResourceDataDirectory.class.getSimpleName(), e.getMessage());
        }
        if (++ndata == this.numberOfRvaAndSizes) {
            return;
        }
        monitor.setMessage("Parsing exceptions...");
        try {
            this.dataDirectory[ndata] = new ExceptionDataDirectory(this.ntHeader, this.reader);
        }
        catch (RuntimeException re) {
            if (PortableExecutable.DEBUG) {
                throw re;
            }
        }
        catch (IOException e) {
            log.appendMsg(ExceptionDataDirectory.class.getSimpleName(), e.getMessage());
        }
        if (++ndata == this.numberOfRvaAndSizes) {
            return;
        }
        monitor.setMessage("Parsing security...");
        try {
            this.dataDirectory[ndata] = new SecurityDataDirectory(this.ntHeader, this.reader);
        }
        catch (RuntimeException re) {
            if (PortableExecutable.DEBUG) {
                throw re;
            }
        }
        catch (IOException e) {
            log.appendMsg(SecurityDataDirectory.class.getSimpleName(), e.getMessage());
        }
        if (++ndata == this.numberOfRvaAndSizes) {
            return;
        }
        monitor.setMessage("Parsing relocations...");
        try {
            this.dataDirectory[ndata] = new BaseRelocationDataDirectory(this.ntHeader, this.reader);
        }
        catch (RuntimeException re) {
            if (PortableExecutable.DEBUG) {
                throw re;
            }
        }
        catch (IOException e) {
            log.appendMsg(BaseRelocationDataDirectory.class.getSimpleName(), e.getMessage());
        }
        if (++ndata == this.numberOfRvaAndSizes) {
            return;
        }
        monitor.setMessage("Parsing debug information...");
        try {
            this.dataDirectory[ndata] = new DebugDataDirectory(this.ntHeader, this.reader);
        }
        catch (RuntimeException re) {
            if (PortableExecutable.DEBUG) {
                throw re;
            }
        }
        catch (IOException e) {
            log.appendMsg(DebugDataDirectory.class.getSimpleName(), e.getMessage());
        }
        if (++ndata == this.numberOfRvaAndSizes) {
            return;
        }
        monitor.setMessage("Parsing architecture...");
        try {
            this.dataDirectory[ndata] = new ArchitectureDataDirectory(this.ntHeader, this.reader);
        }
        catch (RuntimeException re) {
            if (PortableExecutable.DEBUG) {
                throw re;
            }
        }
        catch (IOException e) {
            log.appendMsg(ArchitectureDataDirectory.class.getSimpleName(), e.getMessage());
        }
        if (++ndata == this.numberOfRvaAndSizes) {
            return;
        }
        monitor.setMessage("Parsing global pointer...");
        try {
            this.dataDirectory[ndata] = new GlobalPointerDataDirectory(this.ntHeader, this.reader);
        }
        catch (RuntimeException re) {
            if (PortableExecutable.DEBUG) {
                throw re;
            }
        }
        catch (IOException e) {
            log.appendMsg(GlobalPointerDataDirectory.class.getSimpleName(), e.getMessage());
        }
        if (++ndata == this.numberOfRvaAndSizes) {
            return;
        }
        monitor.setMessage("Parsing TLS data...");
        try {
            this.dataDirectory[ndata] = new TLSDataDirectory(this.ntHeader, this.reader);
        }
        catch (RuntimeException re) {
            if (PortableExecutable.DEBUG) {
                throw re;
            }
        }
        catch (IOException e) {
            log.appendMsg(GlobalPointerDataDirectory.class.getSimpleName(), e.getMessage());
        }
        if (++ndata == this.numberOfRvaAndSizes) {
            return;
        }
        monitor.setMessage("Parsing load config data...");
        try {
            this.dataDirectory[ndata] = new LoadConfigDataDirectory(this.ntHeader, this.reader);
        }
        catch (RuntimeException re) {
            if (PortableExecutable.DEBUG) {
                throw re;
            }
        }
        catch (IOException e) {
            log.appendMsg(LoadConfigDataDirectory.class.getSimpleName(), e.getMessage());
        }
        if (++ndata == this.numberOfRvaAndSizes) {
            return;
        }
        monitor.setMessage("Parsing bound imports...");
        try {
            this.dataDirectory[ndata] = new BoundImportDataDirectory(this.ntHeader, this.reader);
        }
        catch (RuntimeException re) {
            if (PortableExecutable.DEBUG) {
                throw re;
            }
        }
        catch (IOException e) {
            log.appendMsg(BoundImportDataDirectory.class.getSimpleName(), e.getMessage());
        }
        if (++ndata == this.numberOfRvaAndSizes) {
            return;
        }
        monitor.setMessage("Parsing import address table...");
        try {
            this.dataDirectory[ndata] = new ImportAddressTableDataDirectory(this.ntHeader, this.reader);
        }
        catch (RuntimeException re) {
            if (PortableExecutable.DEBUG) {
                throw re;
            }
        }
        catch (IOException e) {
            log.appendMsg(ImportAddressTableDataDirectory.class.getSimpleName(), e.getMessage());
        }
        if (++ndata == this.numberOfRvaAndSizes) {
            return;
        }
        monitor.setMessage("Parsing delay imports...");
        try {
            this.dataDirectory[ndata] = new DelayImportDataDirectory(this.ntHeader, this.reader);
        }
        catch (RuntimeException re) {
            if (PortableExecutable.DEBUG) {
                throw re;
            }
        }
        catch (IOException e) {
            log.appendMsg(DelayImportDataDirectory.class.getSimpleName(), e.getMessage());
        }
        if (++ndata == this.numberOfRvaAndSizes) {
            return;
        }
        monitor.setMessage("Parsing COM descriptors...");
        try {
            this.dataDirectory[ndata] = new COMDescriptorDataDirectory(this.ntHeader, this.reader);
        }
        catch (RuntimeException re) {
            if (PortableExecutable.DEBUG) {
                throw re;
            }
        }
        catch (IOException e) {
            log.appendMsg(COMDescriptorDataDirectory.class.getSimpleName(), e.getMessage());
        }
        if (++ndata == this.numberOfRvaAndSizes) {
            return;
        }
        this.dataDirectory[ndata] = null;
    }

    public boolean is64bit() {
        return this.magic == 523;
    }

    public byte getMajorLinkerVersion() {
        return this.majorLinkerVersion;
    }

    public byte getMinorLinkerVersion() {
        return this.minorLinkerVersion;
    }

    public long getSizeOfCode() {
        return this.sizeOfCode;
    }

    public void setSizeOfCode(long size) {
        this.sizeOfCode = (int)size;
    }

    public long getSizeOfInitializedData() {
        return Integer.toUnsignedLong(this.sizeOfInitializedData);
    }

    public void setSizeOfInitializedData(long size) {
        this.sizeOfInitializedData = (int)size;
    }

    public long getSizeOfUninitializedData() {
        return Integer.toUnsignedLong(this.sizeOfUninitializedData);
    }

    public void setSizeOfUninitializedData(long size) {
        this.sizeOfUninitializedData = (int)size;
    }

    public long getAddressOfEntryPoint() {
        return Integer.toUnsignedLong(this.addressOfEntryPoint);
    }

    public long getBaseOfCode() {
        return Integer.toUnsignedLong(this.baseOfCode);
    }

    public long getBaseOfData() {
        return Integer.toUnsignedLong(this.baseOfData);
    }

    public long getImageBase() {
        return this.imageBase;
    }

    public int getSectionAlignment() {
        return this.sectionAlignment;
    }

    public int getFileAlignment() {
        return this.fileAlignment;
    }

    public short getMajorOperatingSystemVersion() {
        return this.majorOperatingSystemVersion;
    }

    public short getMinorOperatingSystemVersion() {
        return this.minorOperatingSystemVersion;
    }

    public short getMajorImageVersion() {
        return this.majorImageVersion;
    }

    public short getMinorImageVersion() {
        return this.minorImageVersion;
    }

    public short getMajorSubsystemVersion() {
        return this.majorSubsystemVersion;
    }

    public short getMinorSubsystemVersion() {
        return this.minorSubsystemVersion;
    }

    public int getWin32VersionValue() {
        return this.win32VersionValue;
    }

    public long getSizeOfImage() {
        return Integer.toUnsignedLong(this.sizeOfImage);
    }

    public void setSizeOfImage(long size) {
        this.sizeOfImage = (int)size;
    }

    public long getSizeOfHeaders() {
        return Integer.toUnsignedLong(this.sizeOfHeaders);
    }

    public void setSizeOfHeaders(long size) {
        this.sizeOfHeaders = (int)size;
    }

    public int getChecksum() {
        return this.checkSum;
    }

    public int getSubsystem() {
        return this.subsystem;
    }

    public short getDllCharacteristics() {
        return this.dllCharacteristics;
    }

    public long getSizeOfStackReserve() {
        return this.sizeOfStackReserve;
    }

    public long getSizeOfStackCommit() {
        return this.sizeOfStackCommit;
    }

    public long getSizeOfHeapReserve() {
        return this.sizeOfHeapReserve;
    }

    public long getSizeOfHeapCommit() {
        return this.sizeOfHeapCommit;
    }

    public int getLoaderFlags() {
        return this.loaderFlags;
    }

    public long getNumberOfRvaAndSizes() {
        return Integer.toUnsignedLong(this.numberOfRvaAndSizes);
    }

    public DataDirectory[] getDataDirectories() {
        return this.dataDirectory;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException {
        StructureDataType ddstruct = new StructureDataType("IMAGE_DATA_DIRECTORY", 0);
        ddstruct.add(IBO32, "VirtualAddress", null);
        ddstruct.add(DWORD, "Size", null);
        ddstruct.setCategoryPath(new CategoryPath("/PE"));
        StructureDataType struct = new StructureDataType(this.getName(), 0);
        struct.add(WORD, "Magic", null);
        struct.add(BYTE, "MajorLinkerVersion", null);
        struct.add(BYTE, "MinorLinkerVersion", null);
        struct.add(DWORD, "SizeOfCode", null);
        struct.add(DWORD, "SizeOfInitializedData", null);
        struct.add(DWORD, "SizeOfUninitializedData", null);
        struct.add(IBO32, "AddressOfEntryPoint", null);
        struct.add(IBO32, "BaseOfCode", null);
        if (this.is64bit()) {
            struct.add((DataType)new Pointer64DataType(), "ImageBase", null);
        } else {
            struct.add(IBO32, "BaseOfData", null);
            struct.add((DataType)new Pointer32DataType(), "ImageBase", null);
        }
        struct.add(DWORD, "SectionAlignment", null);
        struct.add(DWORD, "FileAlignment", null);
        struct.add(WORD, "MajorOperatingSystemVersion", null);
        struct.add(WORD, "MinorOperatingSystemVersion", null);
        struct.add(WORD, "MajorImageVersion", null);
        struct.add(WORD, "MinorImageVersion", null);
        struct.add(WORD, "MajorSubsystemVersion", null);
        struct.add(WORD, "MinorSubsystemVersion", null);
        struct.add(DWORD, "Win32VersionValue", null);
        struct.add(DWORD, "SizeOfImage", null);
        struct.add(DWORD, "SizeOfHeaders", null);
        struct.add(DWORD, "CheckSum", null);
        struct.add(WORD, "Subsystem", null);
        struct.add(WORD, "DllCharacteristics", null);
        if (this.is64bit()) {
            struct.add(QWORD, "SizeOfStackReserve", null);
            struct.add(QWORD, "SizeOfStackCommit", null);
            struct.add(QWORD, "SizeOfHeapReserve", null);
            struct.add(QWORD, "SizeOfHeapCommit", null);
        } else {
            struct.add(DWORD, "SizeOfStackReserve", null);
            struct.add(DWORD, "SizeOfStackCommit", null);
            struct.add(DWORD, "SizeOfHeapReserve", null);
            struct.add(DWORD, "SizeOfHeapCommit", null);
        }
        struct.add(DWORD, "LoaderFlags", null);
        struct.add(DWORD, "NumberOfRvaAndSizes", null);
        struct.add((DataType)new ArrayDataType((DataType)ddstruct, this.numberOfRvaAndSizes, ddstruct.getLength()), "DataDirectory", null);
        struct.setCategoryPath(new CategoryPath("/PE"));
        return struct;
    }

    public void writeHeader(RandomAccessFile raf, DataConverter dc) throws IOException {
        raf.write(dc.getBytes(this.magic));
        raf.write(new byte[]{this.majorLinkerVersion});
        raf.write(new byte[]{this.minorLinkerVersion});
        raf.write(dc.getBytes(this.sizeOfCode));
        raf.write(dc.getBytes(this.sizeOfInitializedData));
        raf.write(dc.getBytes(this.sizeOfUninitializedData));
        raf.write(dc.getBytes(this.addressOfEntryPoint));
        raf.write(dc.getBytes(this.baseOfCode));
        if (this.is64bit()) {
            raf.write(dc.getBytes(this.imageBase));
        } else {
            raf.write(dc.getBytes(this.baseOfData));
            raf.write(dc.getBytes((int)this.imageBase));
        }
        raf.write(dc.getBytes(this.sectionAlignment));
        raf.write(dc.getBytes(this.fileAlignment));
        raf.write(dc.getBytes(this.majorOperatingSystemVersion));
        raf.write(dc.getBytes(this.minorOperatingSystemVersion));
        raf.write(dc.getBytes(this.majorImageVersion));
        raf.write(dc.getBytes(this.minorImageVersion));
        raf.write(dc.getBytes(this.majorSubsystemVersion));
        raf.write(dc.getBytes(this.minorSubsystemVersion));
        raf.write(dc.getBytes(this.win32VersionValue));
        raf.write(dc.getBytes(this.sizeOfImage));
        raf.write(dc.getBytes(this.sizeOfHeaders));
        raf.write(dc.getBytes(this.checkSum));
        raf.write(dc.getBytes(this.subsystem));
        raf.write(dc.getBytes(this.dllCharacteristics));
        if (this.is64bit()) {
            raf.write(dc.getBytes(this.sizeOfStackReserve));
            raf.write(dc.getBytes(this.sizeOfStackCommit));
            raf.write(dc.getBytes(this.sizeOfHeapReserve));
            raf.write(dc.getBytes(this.sizeOfHeapCommit));
        } else {
            raf.write(dc.getBytes((int)this.sizeOfStackReserve));
            raf.write(dc.getBytes((int)this.sizeOfStackCommit));
            raf.write(dc.getBytes((int)this.sizeOfHeapReserve));
            raf.write(dc.getBytes((int)this.sizeOfHeapCommit));
        }
        raf.write(dc.getBytes(this.loaderFlags));
        raf.write(dc.getBytes(this.numberOfRvaAndSizes));
        for (int i = 0; i < 16; ++i) {
            if (this.dataDirectory[i] != null) {
                raf.write(dc.getBytes(this.dataDirectory[i].getVirtualAddress()));
                raf.write(dc.getBytes(this.dataDirectory[i].getSize()));
                continue;
            }
            raf.write(dc.getBytes(0));
            raf.write(dc.getBytes(0));
        }
    }

    public void validateDataDirectories(Program program) {
        Memory memory = program.getMemory();
        int sizeint = 4;
        Address addr = program.getImageBase().add(this.startOfDataDirs);
        for (int i = 0; i < this.numberOfRvaAndSizes; ++i) {
            try {
                int virtualAddress = memory.getInt(addr, false);
                addr = addr.add((long)sizeint);
                int size = memory.getInt(addr, false);
                addr = addr.add((long)sizeint);
                if (this.dataDirectory[i] == null || !this.dataDirectory[i].hasParsedCorrectly()) continue;
                if (this.dataDirectory[i].getVirtualAddress() != virtualAddress) {
                    Msg.warn((Object)this, (Object)("Correcting dataDirectory[" + i + "] va:" + Integer.toHexString(this.dataDirectory[i].getVirtualAddress()) + "->" + Integer.toHexString(virtualAddress)));
                    this.dataDirectory[i].setVirtualAddress(virtualAddress);
                }
                if (this.dataDirectory[i].getSize() == size) continue;
                Msg.warn((Object)this, (Object)("Correcting dataDirectory[" + i + "] sz:" + Integer.toHexString(this.dataDirectory[i].getSize()) + "->" + Integer.toHexString(size)));
                this.dataDirectory[i].setSize(size);
                continue;
            }
            catch (AddressOutOfBoundsException | MemoryAccessException e) {
                Msg.error((Object)this, (Object)"Problem validating data directories", (Throwable)e);
            }
        }
    }

    public boolean isCLI() throws IOException {
        long origPointerIndex = this.reader.getPointerIndex();
        this.reader.setPointerIndex(this.startOfDataDirs + 112L);
        ImageCor20Header cor20 = new COMDescriptorDataDirectory(this.ntHeader, this.reader).getHeader();
        this.reader.setPointerIndex(origPointerIndex);
        if (cor20 == null) {
            return false;
        }
        boolean intermediateLanguageOnly = (cor20.getFlags() & 1) == 1;
        return intermediateLanguageOnly && cor20.getManagedNativeHeader().getVirtualAddress() == 0;
    }

    private String getName() {
        return "IMAGE_OPTIONAL_HEADER" + (this.is64bit() ? "64" : "32");
    }
}

