/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.encode;

import org.keycloak.models.ClientSessionContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.oidc.encode.AccessTokenContext;
import org.keycloak.protocol.oidc.encode.DefaultTokenContextEncoderProviderFactory;
import org.keycloak.protocol.oidc.encode.TokenContextEncoderProvider;
import org.keycloak.protocol.oidc.mappers.AbstractOIDCProtocolMapper;

public class DefaultTokenContextEncoderProvider
implements TokenContextEncoderProvider {
    public static final String UNKNOWN = "na";
    private final KeycloakSession session;
    private final DefaultTokenContextEncoderProviderFactory factory;

    public DefaultTokenContextEncoderProvider(KeycloakSession session, DefaultTokenContextEncoderProviderFactory factory) {
        this.session = session;
        this.factory = factory;
    }

    @Override
    public AccessTokenContext getTokenContextFromClientSessionContext(ClientSessionContext clientSessionContext, String rawTokenId) {
        String createdFromPersistent;
        UserSessionModel userSession = clientSessionContext.getClientSession().getUserSession();
        AccessTokenContext.SessionType sessionType = userSession.getPersistenceState() == UserSessionModel.SessionPersistenceState.TRANSIENT ? ((createdFromPersistent = userSession.getNote("created_from_persistent")) != null ? ("offline".equals(createdFromPersistent) ? AccessTokenContext.SessionType.OFFLINE_TRANSIENT_CLIENT : AccessTokenContext.SessionType.ONLINE_TRANSIENT_CLIENT) : AccessTokenContext.SessionType.TRANSIENT) : (clientSessionContext.isOfflineTokenRequested() ? AccessTokenContext.SessionType.OFFLINE : AccessTokenContext.SessionType.ONLINE);
        boolean useLightweightToken = AbstractOIDCProtocolMapper.getShouldUseLightweightToken(this.session);
        AccessTokenContext.TokenType tokenType = useLightweightToken ? AccessTokenContext.TokenType.LIGHTWEIGHT : AccessTokenContext.TokenType.REGULAR;
        String grantType = (String)clientSessionContext.getAttribute("grant_type", String.class);
        if (grantType == null) {
            grantType = UNKNOWN;
        }
        return new AccessTokenContext(sessionType, tokenType, grantType, rawTokenId);
    }

    @Override
    public AccessTokenContext getTokenContextFromTokenId(String encodedTokenId) {
        int indexOf = encodedTokenId.indexOf(58);
        if (indexOf == -1) {
            return new AccessTokenContext(AccessTokenContext.SessionType.UNKNOWN, AccessTokenContext.TokenType.UNKNOWN, UNKNOWN, encodedTokenId);
        }
        String encodedContext = encodedTokenId.substring(0, indexOf);
        String rawId = encodedTokenId.substring(indexOf + 1);
        if (encodedContext.length() != 6) {
            throw new IllegalArgumentException("Incorrect token id: '" + encodedTokenId + "'. Expected length of 6.");
        }
        String stShortcut = encodedContext.substring(0, 2);
        String ttShortcut = encodedContext.substring(2, 4);
        String gtShortcut = encodedContext.substring(4, 6);
        AccessTokenContext.SessionType st = this.factory.getSessionTypeByShortcut(stShortcut);
        if (st == null) {
            throw new IllegalArgumentException("Incorrect token id: " + encodedTokenId + ". Unknown value '" + stShortcut + "' for session type");
        }
        AccessTokenContext.TokenType tt = this.factory.getTokenTypeByShortcut(ttShortcut);
        if (tt == null) {
            throw new IllegalArgumentException("Incorrect token id: " + encodedTokenId + ". Unknown value '" + ttShortcut + "' for token type");
        }
        String gt = this.factory.getGrantTypeByShortcut(gtShortcut);
        if (gt == null) {
            throw new IllegalArgumentException("Incorrect token id: " + encodedTokenId + ". Unknown value '" + gtShortcut + "' for grant type");
        }
        return new AccessTokenContext(st, tt, gt, rawId);
    }

    @Override
    public String encodeTokenId(AccessTokenContext tokenContext) {
        if (tokenContext.getSessionType() == AccessTokenContext.SessionType.UNKNOWN) {
            throw new IllegalStateException("Cannot encode token with unknown sessionType");
        }
        if (tokenContext.getTokenType() == AccessTokenContext.TokenType.UNKNOWN) {
            throw new IllegalStateException("Cannot encode token with unknown tokenType");
        }
        String grantShort = this.factory.getShortcutByGrantType(tokenContext.getGrantType());
        if (grantShort == null) {
            throw new IllegalStateException("Cannot encode token with unknown grantType: " + tokenContext.getGrantType());
        }
        return tokenContext.getSessionType().getShortcut() + tokenContext.getTokenType().getShortcut() + grantShort + ":" + tokenContext.getRawTokenId();
    }

    public void close() {
    }
}

