/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.LongBuffer;
import java.util.zip.Checksum;
import org.apache.lucene.util.BitUtil;

public class BufferedChecksum
implements Checksum {
    private final Checksum in;
    private final byte[] buffer;
    private int upto;
    public static final int DEFAULT_BUFFERSIZE = 1024;

    public BufferedChecksum(Checksum in) {
        this(in, 1024);
    }

    public BufferedChecksum(Checksum in, int bufferSize) {
        this.in = in;
        this.buffer = new byte[bufferSize];
    }

    @Override
    public void update(int b) {
        if (this.upto == this.buffer.length) {
            this.flush();
        }
        this.buffer[this.upto++] = (byte)b;
    }

    @Override
    public void update(byte[] b, int off, int len) {
        if (len >= this.buffer.length) {
            this.flush();
            this.in.update(b, off, len);
        } else {
            if (this.upto + len > this.buffer.length) {
                this.flush();
            }
            System.arraycopy(b, off, this.buffer, this.upto, len);
            this.upto += len;
        }
    }

    void updateShort(short val) {
        if (this.upto + 2 > this.buffer.length) {
            this.flush();
        }
        BitUtil.VH_LE_SHORT.set(this.buffer, this.upto, val);
        this.upto += 2;
    }

    void updateInt(int val) {
        if (this.upto + 4 > this.buffer.length) {
            this.flush();
        }
        BitUtil.VH_LE_INT.set(this.buffer, this.upto, val);
        this.upto += 4;
    }

    void updateLong(long val) {
        if (this.upto + 8 > this.buffer.length) {
            this.flush();
        }
        BitUtil.VH_LE_LONG.set(this.buffer, this.upto, val);
        this.upto += 8;
    }

    void updateLongs(long[] vals, int offset, int len) {
        if (this.upto > 0) {
            int remainingCapacityInLong = Math.min((this.buffer.length - this.upto) / 8, len);
            int i = 0;
            while (i < remainingCapacityInLong) {
                this.updateLong(vals[offset]);
                ++i;
                ++offset;
                --len;
            }
            if (0 == len) {
                return;
            }
        }
        LongBuffer b = ByteBuffer.wrap(this.buffer).order(ByteOrder.LITTLE_ENDIAN).asLongBuffer();
        int capacityInLong = this.buffer.length / 8;
        while (len > 0) {
            this.flush();
            int l = Math.min(capacityInLong, len);
            b.put(0, vals, offset, l);
            this.upto += l * 8;
            offset += l;
            len -= l;
        }
    }

    @Override
    public long getValue() {
        this.flush();
        return this.in.getValue();
    }

    @Override
    public void reset() {
        this.upto = 0;
        this.in.reset();
    }

    private void flush() {
        if (this.upto > 0) {
            this.in.update(this.buffer, 0, this.upto);
        }
        this.upto = 0;
    }
}

