/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.keystore.model;

import java.util.Objects;

public class MRDiscovery {
    private final String region;

    protected MRDiscovery(BuilderImpl builder) {
        this.region = builder.region();
    }

    public String region() {
        return this.region;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected String region;

        protected BuilderImpl() {
        }

        protected BuilderImpl(MRDiscovery model) {
            this.region = model.region();
        }

        @Override
        public Builder region(String region) {
            this.region = region;
            return this;
        }

        @Override
        public String region() {
            return this.region;
        }

        @Override
        public MRDiscovery build() {
            if (Objects.isNull(this.region())) {
                throw new IllegalArgumentException("Missing value for required field `region`");
            }
            if (Objects.nonNull(this.region()) && this.region().length() < 1) {
                throw new IllegalArgumentException("The size of `region` must be greater than or equal to 1");
            }
            if (Objects.nonNull(this.region()) && this.region().length() > 32) {
                throw new IllegalArgumentException("The size of `region` must be less than or equal to 32");
            }
            return new MRDiscovery(this);
        }
    }

    public static interface Builder {
        public Builder region(String var1);

        public String region();

        public MRDiscovery build();
    }
}

