/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.internal.params;

import org.bouncycastle.crypto.internal.DerivationParameters;
import org.bouncycastle.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class KDFFeedbackParameters
implements DerivationParameters {
    public static final int BEFORE_ITER = 0;
    public static final int AFTER_ITER = 1;
    public static final int AFTER_FIXED = 2;
    private static final int UNUSED_R = -1;
    private final int counterLocation;
    private final byte[] ki;
    private final byte[] iv;
    private final boolean useCounter;
    private final int r;
    private final byte[] fixedInputData;

    private KDFFeedbackParameters(int n, byte[] byArray, byte[] byArray2, byte[] byArray3, int n2, boolean bl) {
        if (byArray == null) {
            throw new IllegalArgumentException("A KDF requires Ki (a seed) as input");
        }
        this.counterLocation = n;
        this.ki = Arrays.clone(byArray);
        this.fixedInputData = byArray3 == null ? new byte[0] : Arrays.clone(byArray3);
        this.r = n2;
        this.iv = byArray2 == null ? new byte[0] : Arrays.clone(byArray2);
        this.useCounter = bl;
    }

    public static KDFFeedbackParameters createWithCounter(int n, byte[] byArray, byte[] byArray2, byte[] byArray3, int n2) {
        if (n2 != 8 && n2 != 16 && n2 != 24 && n2 != 32) {
            throw new IllegalArgumentException("Length of counter should be 8, 16, 24 or 32");
        }
        return new KDFFeedbackParameters(n, byArray, byArray2, byArray3, n2, true);
    }

    public static KDFFeedbackParameters createWithoutCounter(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return new KDFFeedbackParameters(0, byArray, byArray2, byArray3, -1, false);
    }

    public int getCounterLocation() {
        return this.counterLocation;
    }

    public byte[] getKI() {
        return this.ki;
    }

    public byte[] getIV() {
        return this.iv;
    }

    public boolean useCounter() {
        return this.useCounter;
    }

    public int getR() {
        return this.r;
    }

    public byte[] getFixedInputData() {
        return Arrays.clone(this.fixedInputData);
    }
}

