/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.designer;

import java.io.IOException;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.ResolverStyle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.handler.designer.SchemaSuggester;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.ManagedIndexSchema;
import org.apache.solr.schema.NumberType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.TextField;
import org.apache.solr.update.processor.ParseBooleanFieldUpdateProcessorFactory;
import org.apache.solr.update.processor.ParseDateFieldUpdateProcessorFactory;
import org.apache.solr.update.processor.ParseDoubleFieldUpdateProcessorFactory;
import org.apache.solr.update.processor.ParseLongFieldUpdateProcessorFactory;
import org.apache.solr.util.LocaleUtils;

public class DefaultSchemaSuggester
implements SchemaSuggester {
    private static final List<String> DEFAULT_DATE_TIME_PATTERNS = Arrays.asList("yyyy-MM-dd['T'[HH:mm[:ss[.SSS]][z", "yyyy-MM-dd['T'[HH:mm[:ss[,SSS]][z", "yyyy-MM-dd HH:mm[:ss[.SSS]][z", "yyyy-MM-dd HH:mm[:ss[,SSS]][z", "[EEE, ]dd MMM yyyy HH:mm[:ss] z", "EEEE, dd-MMM-yy HH:mm:ss z", "EEE MMM ppd HH:mm:ss [z ]yyyy");
    private static final String FORMATS_PARAM = "format";
    private static final String DEFAULT_TIME_ZONE_PARAM = "defaultTimeZone";
    private static final String LOCALE_PARAM = "locale";
    private static final String TRUE_VALUES_PARAM = "trueValue";
    private static final String FALSE_VALUES_PARAM = "falseValue";
    private static final String CASE_SENSITIVE_PARAM = "caseSensitive";
    private static final String TYPE_CHANGE_ERROR = "Failed to parse all sample values as %s for changing type for field %s to %s";
    private final Set<String> trueValues = Set.of("true");
    private final Set<String> falseValues = Set.of("false");
    private final List<DateTimeFormatter> dateTimeFormatters = new ArrayList<DateTimeFormatter>();
    private boolean caseSensitive = false;

    @Override
    public void validateTypeChange(SchemaField field, FieldType toType, List<SolrInputDocument> docs) throws IOException {
        NumberType toNumType = toType.getNumberType();
        if (toNumType != null) {
            this.validateNumericTypeChange(field, toType, docs, toNumType);
        }
    }

    protected void validateNumericTypeChange(SchemaField field, FieldType toType, List<SolrInputDocument> docs, NumberType toNumType) {
        List<Object> fieldValues = docs.stream().map(d -> d.getFieldValue(field.getName())).filter(Objects::nonNull).flatMap(c -> c instanceof Collection ? ((Collection)c).stream() : Stream.of(c)).collect(Collectors.toList());
        switch (toNumType) {
            case DOUBLE: 
            case FLOAT: {
                if (this.isFloatOrDouble(fieldValues, Locale.ROOT) != null) break;
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, String.format(Locale.ROOT, TYPE_CHANGE_ERROR, toNumType.name(), field.getName(), toType.getTypeName()));
            }
            case LONG: 
            case INTEGER: {
                if (this.isIntOrLong(fieldValues, Locale.ROOT) != null) break;
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, String.format(Locale.ROOT, TYPE_CHANGE_ERROR, toNumType.name(), field.getName(), toType.getTypeName()));
            }
            case DATE: {
                if (this.isDateTime(fieldValues)) break;
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, String.format(Locale.ROOT, TYPE_CHANGE_ERROR, toNumType.name(), field.getName(), toType.getTypeName()));
            }
        }
    }

    @Override
    public Optional<SchemaField> suggestField(String fieldName, List<Object> sampleValues, IndexSchema schema, List<String> langs) {
        if (schema.isDynamicField(fieldName)) {
            return Optional.of(schema.getFieldOrNull(fieldName));
        }
        Locale locale = Locale.ROOT;
        boolean isMV = this.isMultiValued(sampleValues);
        String fieldTypeName = this.guessFieldType(fieldName, sampleValues, schema, isMV, locale);
        FieldType fieldType = schema.getFieldTypeByName(fieldTypeName);
        if (fieldType == null) {
            throw new IllegalStateException("FieldType '" + fieldTypeName + "' not found in the schema!");
        }
        Map<String, String> fieldProps = this.guessFieldProps(fieldName, fieldType, sampleValues, isMV, schema);
        SchemaField schemaField = schema.newField(fieldName, fieldTypeName, fieldProps);
        return Optional.of(schemaField);
    }

    @Override
    public ManagedIndexSchema adaptExistingFieldToData(SchemaField schemaField, List<Object> sampleValues, ManagedIndexSchema schema) {
        if (!schemaField.multiValued() && this.isMultiValued(sampleValues)) {
            SimpleOrderedMap<Object> fieldProps = schemaField.getNamedPropertyValues(false);
            fieldProps.add("multiValued", (Object)true);
            fieldProps.remove("name");
            fieldProps.remove("type");
            schema = schema.replaceField(schemaField.getName(), schemaField.getType(), fieldProps.asShallowMap());
        }
        return schema;
    }

    @Override
    public Map<String, List<Object>> transposeDocs(List<SolrInputDocument> docs) {
        HashMap<String, List<Object>> mapByField = new HashMap<String, List<Object>>();
        docs.forEach(doc -> doc.getFieldNames().forEach(f -> {
            if (!"_version_".equals(f)) {
                List values = mapByField.computeIfAbsent((String)f, k -> new ArrayList());
                Collection fieldValues = doc.getFieldValues(f);
                if (fieldValues != null && !fieldValues.isEmpty()) {
                    if (fieldValues.size() == 1) {
                        values.add(fieldValues.iterator().next());
                    } else {
                        values.add(fieldValues);
                    }
                }
            }
        }));
        return mapByField;
    }

    protected String guessFieldType(String fieldName, List<Object> sampleValues, IndexSchema schema, boolean isMV, Locale locale) {
        Object type = null;
        List<Object> flattened = sampleValues.stream().flatMap(c -> c instanceof Collection ? ((Collection)c).stream() : Stream.of(c)).filter(Objects::nonNull).collect(Collectors.toList());
        if (this.isBoolean(flattened)) {
            type = isMV ? "booleans" : "boolean";
        } else {
            String intType = this.isIntOrLong(flattened, locale);
            if (intType != null) {
                type = isMV ? intType + "s" : intType;
            } else {
                String floatType = this.isFloatOrDouble(flattened, locale);
                if (floatType != null) {
                    Object object = type = isMV ? floatType + "s" : floatType;
                }
            }
        }
        if (type == null) {
            if (this.isDateTime(flattened)) {
                type = isMV ? "pdates" : "pdate";
            } else if (this.isText(flattened)) {
                Object object = type = "en".equals(locale.getLanguage()) ? "text_en" : "text_general";
            }
        }
        if (type == null) {
            type = isMV ? "strings" : "string";
        }
        return type;
    }

    protected boolean isText(List<Object> values) {
        if (values == null || values.isEmpty()) {
            return false;
        }
        int maxLength = -1;
        int maxTerms = -1;
        for (Object next : values) {
            String[] terms;
            if (!(next instanceof String)) {
                return false;
            }
            String cs = (String)next;
            int len = cs.length();
            if (len > maxLength) {
                maxLength = len;
            }
            if ((terms = cs.split("\\s+")).length <= maxTerms) continue;
            maxTerms = terms.length;
        }
        return maxLength > 60 || maxTerms > 12 || maxTerms > 4 && values.size() >= 10 && (float)Set.of(values).size() / (float)values.size() > 0.9f;
    }

    protected String isFloatOrDouble(List<Object> values, Locale locale) {
        NumberFormat format = NumberFormat.getInstance(locale);
        format.setParseIntegerOnly(false);
        format.setRoundingMode(RoundingMode.CEILING);
        for (Object next : values) {
            Object parsed = ParseDoubleFieldUpdateProcessorFactory.parsePossibleDouble(next, format);
            if (parsed != null) continue;
            return null;
        }
        return "pdouble";
    }

    protected boolean isBoolean(List<Object> values) {
        for (Object next : values) {
            Object parsed = ParseBooleanFieldUpdateProcessorFactory.parsePossibleBoolean(next, this.caseSensitive, this.trueValues, this.falseValues);
            if (parsed != null) continue;
            return false;
        }
        return true;
    }

    protected String isIntOrLong(List<Object> values, Locale locale) {
        NumberFormat format = NumberFormat.getInstance(locale);
        format.setParseIntegerOnly(true);
        long maxLong = Long.MIN_VALUE;
        for (Object next : values) {
            Object parsed = ParseLongFieldUpdateProcessorFactory.parsePossibleLong(next, format);
            if (parsed == null) {
                return null;
            }
            long parsedLong = ((Number)parsed).longValue();
            if (parsedLong <= maxLong) continue;
            maxLong = parsedLong;
        }
        return maxLong < 10000L ? "pint" : "plong";
    }

    protected boolean isDateTime(List<Object> values) {
        if (this.dateTimeFormatters.isEmpty()) {
            return false;
        }
        for (Object next : values) {
            Object parsedDate = ParseDateFieldUpdateProcessorFactory.parsePossibleDate(next, this.dateTimeFormatters, new ParsePosition(0));
            if (parsedDate != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isMultiValued(String name, List<SolrInputDocument> docs) {
        Map<String, List<Object>> transposed = this.transposeDocs(docs);
        List<Object> sampleValues = transposed.get(name);
        return sampleValues != null && this.isMultiValued(sampleValues);
    }

    protected boolean isMultiValued(List<Object> sampleValues) {
        for (Object next : sampleValues) {
            if (!(next instanceof Collection)) continue;
            return true;
        }
        return false;
    }

    protected Map<String, String> guessFieldProps(String fieldName, FieldType fieldType, List<Object> sampleValues, boolean isMV, IndexSchema schema) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("indexed", "true");
        if (isMV && !fieldType.isMultiValued()) {
            props.put("multiValued", "true");
        }
        boolean docValues = true;
        if (fieldType instanceof TextField) {
            docValues = false;
        } else {
            HashMap<String, String> tmpProps = new HashMap<String, String>(props);
            tmpProps.put("docValues", "true");
            try {
                fieldType.checkSchemaField(schema.newField(fieldName, fieldType.getTypeName(), tmpProps));
            }
            catch (SolrException solrException) {
                docValues = false;
            }
        }
        props.put("docValues", String.valueOf(docValues));
        if (!docValues) {
            props.put("stored", "true");
        } else {
            props.put("stored", "false");
            props.put("useDocValuesAsStored", "true");
        }
        return props;
    }

    @Override
    public void init(NamedList<?> args) {
        this.initDateTimeFormatters(args);
        this.initBooleanParsing(args);
    }

    protected void initDateTimeFormatters(NamedList<?> args) {
        List<String> dateTimePatterns;
        Locale locale = Locale.US;
        String localeParam = (String)args.remove(LOCALE_PARAM);
        if (null != localeParam) {
            locale = LocaleUtils.toLocale(localeParam);
        }
        ZoneId defaultTimeZone = ZoneOffset.UTC;
        Object defaultTimeZoneParam = args.remove(DEFAULT_TIME_ZONE_PARAM);
        if (null != defaultTimeZoneParam) {
            defaultTimeZone = ZoneId.of(defaultTimeZoneParam.toString());
        }
        if ((dateTimePatterns = args.removeConfigArgs(FORMATS_PARAM)) == null || dateTimePatterns.isEmpty()) {
            dateTimePatterns = DEFAULT_DATE_TIME_PATTERNS;
        }
        for (String pattern : dateTimePatterns) {
            DateTimeFormatter formatter = new DateTimeFormatterBuilder().parseLenient().parseCaseInsensitive().appendPattern(pattern).toFormatter(locale).withResolverStyle(ResolverStyle.LENIENT).withZone(defaultTimeZone);
            ParseDateFieldUpdateProcessorFactory.validateFormatter(formatter);
            this.dateTimeFormatters.add(formatter);
        }
    }

    protected void initBooleanParsing(NamedList<?> args) {
        Collection falseValuesParam;
        Collection trueValuesParam;
        Object caseSensitiveParam = args.remove(CASE_SENSITIVE_PARAM);
        if (null != caseSensitiveParam) {
            this.caseSensitive = caseSensitiveParam instanceof Boolean ? (Boolean)caseSensitiveParam : Boolean.parseBoolean(caseSensitiveParam.toString());
        }
        if (!(trueValuesParam = args.removeConfigArgs(TRUE_VALUES_PARAM)).isEmpty()) {
            this.trueValues.clear();
            for (String trueVal : trueValuesParam) {
                this.trueValues.add(this.caseSensitive ? trueVal : trueVal.toLowerCase(Locale.ROOT));
            }
        }
        if (!(falseValuesParam = args.removeConfigArgs(FALSE_VALUES_PARAM)).isEmpty()) {
            this.falseValues.clear();
            for (String val : falseValuesParam) {
                String falseVal;
                String string = falseVal = this.caseSensitive ? val : val.toLowerCase(Locale.ROOT);
                if (this.trueValues.contains(falseVal)) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Param 'falseValue' contains a value also in param 'trueValue': '" + val + "'");
                }
                this.falseValues.add(falseVal);
            }
        }
    }
}

