/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request;

import java.util.HashSet;
import java.util.Set;
import org.apache.solr.client.api.model.FileListResponse;
import org.apache.solr.client.api.model.IndexVersionResponse;
import org.apache.solr.client.solrj.InputStreamResponse;
import org.apache.solr.client.solrj.JacksonParsingResponse;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.InputStreamResponseParser;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;

public class ReplicationApi {

    public static class FetchIndexVersion
    extends SolrRequest<FetchIndexVersionResponse> {
        private final String coreName;

        public FetchIndexVersion(String coreName) {
            super(SolrRequest.METHOD.valueOf("GET"), "/cores/{coreName}/replication/indexversion".replace("{coreName}", coreName));
            this.coreName = coreName;
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrRequest.ApiVersion getApiVersion() {
            return SolrRequest.ApiVersion.V2;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        public Set<String> getQueryParams() {
            HashSet<String> queryParams = new HashSet<String>();
            return queryParams;
        }

        @Override
        protected FetchIndexVersionResponse createResponse(SolrClient client) {
            return new FetchIndexVersionResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class FetchIndexVersionResponse
    extends JacksonParsingResponse<IndexVersionResponse> {
        public FetchIndexVersionResponse() {
            super(IndexVersionResponse.class);
        }
    }

    public static class FetchFileList
    extends SolrRequest<FetchFileListResponse> {
        private final String coreName;
        private final Long generation;

        public FetchFileList(String coreName, Long generation) {
            super(SolrRequest.METHOD.valueOf("GET"), "/cores/{coreName}/replication/files".replace("{coreName}", coreName));
            this.coreName = coreName;
            this.generation = generation;
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrRequest.ApiVersion getApiVersion() {
            return SolrRequest.ApiVersion.V2;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            if (this.generation != null) {
                params.add("generation", this.generation.toString());
            }
            return params;
        }

        @Override
        public Set<String> getQueryParams() {
            HashSet<String> queryParams = new HashSet<String>();
            queryParams.add("generation");
            return queryParams;
        }

        @Override
        protected FetchFileListResponse createResponse(SolrClient client) {
            return new FetchFileListResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class FetchFileListResponse
    extends JacksonParsingResponse<FileListResponse> {
        public FetchFileListResponse() {
            super(FileListResponse.class);
        }
    }

    public static class FetchFile1
    extends SolrRequest<FetchFile1Response> {
        private final String coreName;
        private final String filePath;
        private final String dirType;
        private String offset;
        private String len;
        private Boolean compression;
        private Boolean checksum;
        private Double maxWriteMBPerSec;
        private Long generation;

        public FetchFile1(String coreName, String filePath, String dirType) {
            super(SolrRequest.METHOD.valueOf("GET"), "/cores/{coreName}/replication/files/{filePath}".replace("{coreName}", coreName).replace("{filePath}", filePath));
            this.coreName = coreName;
            this.filePath = filePath;
            this.dirType = dirType;
        }

        public void setOffset(String offset) {
            this.offset = offset;
        }

        public void setLen(String len) {
            this.len = len;
        }

        public void setCompression(Boolean compression) {
            this.compression = compression;
        }

        public void setChecksum(Boolean checksum) {
            this.checksum = checksum;
        }

        public void setMaxWriteMBPerSec(Double maxWriteMBPerSec) {
            this.maxWriteMBPerSec = maxWriteMBPerSec;
        }

        public void setGeneration(Long generation) {
            this.generation = generation;
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrRequest.ApiVersion getApiVersion() {
            return SolrRequest.ApiVersion.V2;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            if (this.dirType != null) {
                params.add("dirType", this.dirType);
            }
            if (this.offset != null) {
                params.add("offset", this.offset);
            }
            if (this.len != null) {
                params.add("len", this.len);
            }
            if (this.compression != null) {
                params.add("compression", this.compression.toString());
            }
            if (this.checksum != null) {
                params.add("checksum", this.checksum.toString());
            }
            if (this.maxWriteMBPerSec != null) {
                params.add("maxWriteMBPerSec", this.maxWriteMBPerSec.toString());
            }
            if (this.generation != null) {
                params.add("generation", this.generation.toString());
            }
            return params;
        }

        @Override
        public Set<String> getQueryParams() {
            HashSet<String> queryParams = new HashSet<String>();
            queryParams.add("dirType");
            queryParams.add("offset");
            queryParams.add("len");
            queryParams.add("compression");
            queryParams.add("checksum");
            queryParams.add("maxWriteMBPerSec");
            queryParams.add("generation");
            return queryParams;
        }

        @Override
        protected FetchFile1Response createResponse(SolrClient client) {
            return new FetchFile1Response();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class FetchFile1Response
    extends InputStreamResponse {
    }
}

