/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.util;

import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonTestInjection {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static volatile Map<String, String> additionalSystemProps = null;
    private static volatile Integer delay = null;
    private static final ConcurrentMap<String, Breakpoint> breakpoints = new ConcurrentHashMap<String, Breakpoint>();

    public static void reset() {
        additionalSystemProps = null;
        delay = null;
    }

    public static void setAdditionalProps(Map<String, String> additionalSystemProps) {
        CommonTestInjection.additionalSystemProps = additionalSystemProps;
    }

    public static Map<String, String> injectAdditionalProps() {
        return additionalSystemProps;
    }

    public static void setDelay(Integer delay) {
        CommonTestInjection.delay = delay;
    }

    public static boolean injectDelay() {
        if (delay != null) {
            try {
                log.info("Start: artificial delay for {}ms", (Object)delay);
                Thread.sleep(delay.intValue());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            finally {
                log.info("Finish: artificial delay for {}ms", (Object)delay);
            }
        }
        return true;
    }

    public static boolean injectBreakpoint(String key, Object ... args) {
        Breakpoint breakpoint = (Breakpoint)breakpoints.get(key);
        if (breakpoint != null) {
            log.info("Breakpoint with key {} is triggered", (Object)key);
            breakpoint.executeAndResume(args);
            log.info("Breakpoint with key {} was executed and normal code execution resumes", (Object)key);
        } else {
            log.debug("Breakpoint with key {} is triggered but there's no implementation set. Skipping...", (Object)key);
        }
        return true;
    }

    public static class BreakpointSetter
    implements Closeable {
        private Set<String> keys = new HashSet<String>();

        public void setImplementation(String key, Breakpoint implementation) {
            if (breakpoints.containsKey(key)) {
                throw new IllegalArgumentException("Cannot redefine Breakpoint implementation with key " + key);
            }
            breakpoints.put(key, implementation);
            this.keys.add(key);
        }

        @Override
        public void close() throws IOException {
            for (String key : this.keys) {
                breakpoints.remove(key);
            }
        }
    }

    public static interface Breakpoint {
        public void executeAndResume(Object ... var1);
    }
}

