/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.attrs;

import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.carrot2.attrs.AcceptingVisitor;
import org.carrot2.attrs.Attr;
import org.carrot2.attrs.Constraint;

public class AttrObject<T extends AcceptingVisitor>
extends Attr<T> {
    private Class<T> clazz;
    private Supplier<T> getter;
    private Consumer<T> setter;
    private Supplier<? extends T> newInstance;

    AttrObject(Class<T> clazz, T defaultValue, String label, List<? extends Constraint<? super T>> constraint, Supplier<? extends T> newInstance, Supplier<T> getter, Consumer<T> setter) {
        super(null, label, constraint);
        this.clazz = clazz;
        this.setter = setter != null ? setter : x$0 -> super.set(x$0);
        this.getter = getter != null ? getter : () -> (AcceptingVisitor)super.get();
        this.newInstance = newInstance;
        this.set(defaultValue);
    }

    @Override
    public void set(T value) {
        super.set(value);
        this.setter.accept(value);
    }

    public <E extends T> E set(E value, Consumer<E> closure) {
        this.set(value);
        closure.accept(value);
        return value;
    }

    @Override
    public T get() {
        return (T)((AcceptingVisitor)this.getter.get());
    }

    public Class<T> getInterfaceClass() {
        return this.clazz;
    }

    public boolean isDefaultClass(Object value) {
        Objects.requireNonNull(value);
        T def = this.newDefaultValue();
        return def != null && Objects.equals(def.getClass(), value.getClass()) && Objects.equals(this.clazz, value.getClass());
    }

    public T newDefaultValue() {
        return (T)((AcceptingVisitor)this.newInstance.get());
    }

    public static <T extends AcceptingVisitor> Builder<T> builder(Class<T> clazz) {
        return new Builder<T>(clazz);
    }

    public static class Builder<T extends AcceptingVisitor>
    extends Attr.BuilderScaffold<T> {
        private Class<T> clazz;
        private Supplier<T> getter;
        private Consumer<T> setter;

        public Builder(Class<T> clazz) {
            this.clazz = clazz;
        }

        public Builder<T> getset(Supplier<T> getter, Consumer<T> setter) {
            this.setter = Objects.requireNonNull(setter);
            this.getter = Objects.requireNonNull(getter);
            return this;
        }

        @Override
        public Builder<T> label(String label) {
            super.label(label);
            return this;
        }

        public AttrObject<T> defaultValue(Supplier<? extends T> newInstance) {
            Objects.requireNonNull(newInstance, "New instance supplier must not be null.");
            return this.defaultValue((AcceptingVisitor)newInstance.get(), newInstance);
        }

        public AttrObject<T> defaultValue(T defaultValue, Supplier<? extends T> newInstance) {
            Objects.requireNonNull(newInstance, "New instance supplier must not be null.");
            return new AttrObject<T>(this.clazz, defaultValue, this.label, this.getConstraint(), newInstance, this.getter, this.setter);
        }
    }
}

