/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.projection;

import java.util.EnumMap;
import java.util.regex.Pattern;
import org.apache.sis.internal.referencing.provider.LambertCylindricalEqualArea;
import org.apache.sis.internal.referencing.provider.Mercator1SP;
import org.apache.sis.internal.util.DoubleDouble;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.matrix.Matrix2;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.projection.AuthalicConversion;
import org.apache.sis.referencing.operation.projection.Initializer;
import org.apache.sis.referencing.operation.projection.NormalizedProjection;
import org.apache.sis.referencing.operation.projection.ProjectionException;
import org.apache.sis.referencing.operation.projection.ProjectionVariant;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class CylindricalEqualArea
extends AuthalicConversion {
    private static final long serialVersionUID = 5659955047326708663L;
    private final Variant variant;

    public CylindricalEqualArea(OperationMethod operationMethod, Parameters parameters) {
        this(CylindricalEqualArea.initializer(operationMethod, parameters));
    }

    private static Initializer initializer(OperationMethod operationMethod, Parameters parameters) {
        Variant variant = (Variant)CylindricalEqualArea.variant((OperationMethod)operationMethod, (ProjectionVariant[])Variant.values(), (ProjectionVariant)Variant.ELLIPSOIDAL);
        EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor<Double>> enumMap = new EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor<Double>>(NormalizedProjection.ParameterRole.class);
        enumMap.put(NormalizedProjection.ParameterRole.SCALE_FACTOR, LambertCylindricalEqualArea.SCALE_FACTOR);
        enumMap.put(NormalizedProjection.ParameterRole.FALSE_EASTING, LambertCylindricalEqualArea.FALSE_EASTING);
        enumMap.put(NormalizedProjection.ParameterRole.FALSE_NORTHING, LambertCylindricalEqualArea.FALSE_NORTHING);
        return new Initializer(operationMethod, parameters, enumMap, variant);
    }

    private CylindricalEqualArea(Initializer initializer) {
        super(initializer, null);
        this.variant = (Variant)initializer.variant;
        MatrixSIS matrixSIS = this.context.getMatrix(ContextualParameters.MatrixRole.DENORMALIZATION);
        double d = initializer.getAndStore(LambertCylindricalEqualArea.LONGITUDE_OF_ORIGIN);
        if (d != 0.0) {
            DoubleDouble doubleDouble = DoubleDouble.createDegreesToRadians();
            doubleDouble.multiplyGuessError(-d);
            matrixSIS.convertBefore(0, null, doubleDouble);
        }
        double d2 = Math.toRadians(initializer.getAndStore(LambertCylindricalEqualArea.STANDARD_PARALLEL));
        DoubleDouble doubleDouble = new DoubleDouble(initializer.scaleAt\u03c6(Math.sin(d2), Math.cos(d2)));
        doubleDouble.multiplyGuessError(initializer.getAndStore(Mercator1SP.SCALE_FACTOR));
        DoubleDouble doubleDouble2 = new DoubleDouble(1.0);
        doubleDouble2.subtract(initializer.eccentricitySquared);
        doubleDouble2.multiply(0.5);
        doubleDouble2.divide(doubleDouble);
        matrixSIS.convertAfter(0, doubleDouble, null);
        matrixSIS.convertAfter(1, doubleDouble2, null);
    }

    CylindricalEqualArea(CylindricalEqualArea cylindricalEqualArea) {
        super(cylindricalEqualArea);
        this.variant = cylindricalEqualArea.variant;
    }

    @Override
    public MathTransform createMapProjection(MathTransformFactory mathTransformFactory) throws FactoryException {
        CylindricalEqualArea cylindricalEqualArea = this;
        if ((this.variant == Variant.SPHERICAL || this.eccentricity == 0.0) && this.getClass() == CylindricalEqualArea.class) {
            cylindricalEqualArea = new Spherical(this);
        }
        return this.context.completeTransform(mathTransformFactory, cylindricalEqualArea);
    }

    @Override
    public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws ProjectionException {
        double d = dArray[n + 1];
        double d2 = Math.sin(d);
        if (dArray2 != null) {
            dArray2[n2] = dArray[n];
            dArray2[n2 + 1] = this.qm(d2);
        }
        return bl ? new Matrix2(1.0, 0.0, 0.0, this.dqm_d\u03c6(d2, Math.cos(d))) : null;
    }

    @Override
    public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) throws TransformException {
        if (dArray != dArray2 || n != n2 || this.getClass() != CylindricalEqualArea.class) {
            super.transform(dArray, n, dArray2, n2, n3);
        } else {
            --n2;
            while (--n3 >= 0) {
                double d = dArray2[n2 += 2];
                dArray2[n2] = this.qm(Math.sin(d));
            }
        }
    }

    @Override
    protected void inverseTransform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
        double d = dArray[n + 1];
        dArray2[n2] = dArray[n];
        dArray2[n2 + 1] = this.\u03c6(d / this.qmPolar);
    }

    private static enum Variant implements ProjectionVariant
    {
        ELLIPSOIDAL(null, "9835"),
        SPHERICAL(Pattern.compile(".*\\bSpherical\\b.*", 2), "9834");

        private final Pattern operationName;
        private final String identifier;

        private Variant(Pattern pattern, String string2) {
            this.operationName = pattern;
            this.identifier = string2;
        }

        @Override
        public Pattern getOperationNamePattern() {
            return this.operationName;
        }

        @Override
        public String getIdentifier() {
            return this.identifier;
        }

        @Override
        public boolean useAuthalicRadius() {
            return this == SPHERICAL;
        }
    }

    private static final class Spherical
    extends CylindricalEqualArea {
        private static final long serialVersionUID = 1063449347697947732L;

        Spherical(CylindricalEqualArea cylindricalEqualArea) {
            super(cylindricalEqualArea);
            this.context.getMatrix(ContextualParameters.MatrixRole.DENORMALIZATION).convertAfter(1, 2, null);
        }

        @Override
        public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) {
            double d = dArray[n + 1];
            if (dArray2 != null) {
                dArray2[n2] = dArray[n];
                dArray2[n2 + 1] = Math.sin(d);
            }
            return bl ? new Matrix2(1.0, 0.0, 0.0, Math.cos(d)) : null;
        }

        @Override
        public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) throws TransformException {
            if (dArray != dArray2 || n != n2) {
                super.transform(dArray, n, dArray2, n2, n3);
            } else {
                --n2;
                while (--n3 >= 0) {
                    double d = dArray2[n2 += 2];
                    dArray2[n2] = Math.sin(d);
                }
            }
        }

        @Override
        protected void inverseTransform(double[] dArray, int n, double[] dArray2, int n2) {
            double d = dArray[n + 1];
            dArray2[n2] = dArray[n];
            dArray2[n2 + 1] = Math.asin(d);
        }
    }
}

