/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.common;

import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import org.graalvm.visualvm.lib.common.Profiler;

public final class CommonUtils {
    public static void runInEventDispatchThread(Runnable r) {
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    public static void runInEventDispatchThreadAndWait(Runnable r) {
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(r);
            }
            catch (InvocationTargetException e) {
                Profiler.getDefault().notifyException(8, e);
            }
            catch (InterruptedException e) {
                Profiler.getDefault().notifyException(8, e);
            }
        }
    }
}

