/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeConstraint;
import org.jkiss.dbeaver.model.data.DBDAttributeConstraintBase;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomCheckboxCellEditor;
import org.jkiss.dbeaver.ui.controls.CustomTreeEditor;
import org.jkiss.dbeaver.ui.controls.NamedObjectPatternFilter;
import org.jkiss.dbeaver.ui.controls.TreeContentProvider;
import org.jkiss.dbeaver.ui.controls.ViewerColumnController;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.dbeaver.ui.controls.resultset.internal.ResultSetMessages;
import org.jkiss.dbeaver.ui.controls.resultset.spreadsheet.SpreadsheetPresentation;
import org.jkiss.dbeaver.ui.dialogs.HelpEnabledDialog;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

class FilterSettingsDialog
extends HelpEnabledDialog {
    private static final String DIALOG_ID = "DBeaver.FilterSettingsDialog";
    private final Comparator<DBDAttributeBinding> POSITION_SORTER = (o1, o2) -> {
        DBDAttributeConstraint c1 = this.getBindingConstraint((DBDAttributeBinding)o1);
        DBDAttributeConstraint c2 = this.getBindingConstraint((DBDAttributeBinding)o2);
        return c1.getVisualPosition() - c2.getVisualPosition();
    };
    private final Comparator<DBDAttributeBinding> ALPHA_SORTER = Comparator.comparing(DBDAttributeBinding::getName);
    private final ResultSetViewer resultSetViewer;
    private final List<DBDAttributeBinding> attributes;
    private TreeViewer columnsViewer;
    private ViewerColumnController<Object, Object> columnsController;
    private DBDDataFilter dataFilter;
    private Text whereText;
    private Text orderText;
    private List<DBDAttributeConstraint> constraints;
    private ToolItem moveTopButton;
    private ToolItem moveUpButton;
    private ToolItem moveDownButton;
    private ToolItem moveBottomButton;
    private final Comparator<DBDAttributeBinding> activeSorter = this.POSITION_SORTER;
    private FilterSettingsTreeEditor treeEditor;

    FilterSettingsDialog(ResultSetViewer resultSetViewer) {
        super(resultSetViewer.getControl().getShell(), "data-filter");
        this.resultSetViewer = resultSetViewer;
        this.dataFilter = new DBDDataFilter(resultSetViewer.getModel().getDataFilter());
        this.constraints = new ArrayList<DBDAttributeConstraint>(this.dataFilter.getConstraints());
        this.constraints.sort(Comparator.comparingInt(DBDAttributeConstraintBase::getVisualPosition));
        DBDAttributeBinding[] modelAttrs = resultSetViewer.getModel().getAttributes();
        this.attributes = new ArrayList<DBDAttributeBinding>(modelAttrs.length);
        Collections.addAll(this.attributes, modelAttrs);
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return UIUtils.getDialogSettings((String)DIALOG_ID);
    }

    protected Composite createDialogArea(Composite parent) {
        this.getShell().setText(ResultSetMessages.controls_resultset_filter_title);
        this.getShell().setImage(DBeaverIcons.getImage((DBPImage)UIIcon.FILTER));
        Composite composite = super.createDialogArea(parent);
        CTabFolder tabFolder = new CTabFolder(composite, 0);
        GridData gd = new GridData(1808);
        gd.minimumWidth = 200;
        gd.widthHint = 400;
        tabFolder.setLayoutData((Object)gd);
        Composite columnsGroup = UIUtils.createComposite((Composite)tabFolder, (int)1);
        columnsGroup.setLayoutData((Object)new GridData(768));
        new FilteredTree(columnsGroup, 65538, (PatternFilter)new NamedObjectPatternFilter(), true, false){

            protected TreeViewer doCreateTreeViewer(Composite parent, int style) {
                FilterSettingsDialog.this.columnsViewer = new TreeViewer(parent, style);
                FilterSettingsDialog.this.columnsController = new ViewerColumnController(FilterSettingsDialog.class.getSimpleName(), (ColumnViewer)FilterSettingsDialog.this.columnsViewer);
                return FilterSettingsDialog.this.columnsViewer;
            }
        };
        this.columnsController.addColumn(ResultSetMessages.controls_resultset_filter_column_name, null, 16384, true, false, new CellLabelProvider(){

            public void update(ViewerCell cell) {
                DBDAttributeBinding binding = (DBDAttributeBinding)cell.getElement();
                DBDAttributeConstraint constraint = FilterSettingsDialog.this.getBindingConstraint(binding);
                cell.setText(constraint.getAttribute().getName());
                cell.setImage(DBeaverIcons.getImage((DBPImage)DBValueFormatting.getObjectImage((DBPObject)binding.getMetaAttribute())));
            }
        });
        this.columnsController.addColumn("#", null, 16384, true, false, new CellLabelProvider(){

            public void update(ViewerCell cell) {
                DBDAttributeBinding binding = (DBDAttributeBinding)cell.getElement();
                DBDAttributeConstraint constraint = FilterSettingsDialog.this.getBindingConstraint(binding);
                cell.setText(String.valueOf(constraint.getOriginalVisualPosition() + 1));
            }
        });
        this.columnsController.addBooleanColumn(ResultSetMessages.controls_resultset_filter_column_visible, null, 16384, true, false, item -> {
            DBDAttributeBinding binding = (DBDAttributeBinding)item;
            DBDAttributeConstraint constraint = this.getBindingConstraint(binding);
            return constraint.isVisible();
        }, new EditingSupport((ColumnViewer)this.columnsViewer){

            protected CellEditor getCellEditor(Object element) {
                return new CustomCheckboxCellEditor((Composite)((TreeViewer)this.getViewer()).getTree(), true);
            }

            protected boolean canEdit(Object element) {
                return true;
            }

            protected Object getValue(Object element) {
                DBDAttributeBinding binding = (DBDAttributeBinding)element;
                DBDAttributeConstraint constraint = FilterSettingsDialog.this.getBindingConstraint(binding);
                return constraint.isVisible();
            }

            protected void setValue(Object element, Object value) {
                DBDAttributeBinding binding = (DBDAttributeBinding)element;
                DBDAttributeConstraint constraint = FilterSettingsDialog.this.getBindingConstraint(binding);
                constraint.setVisible(((Boolean)value).booleanValue());
            }
        });
        this.columnsController.addBooleanColumn(ResultSetMessages.controls_resultset_filter_column_pinned, null, 16384, true, false, item -> {
            DBDAttributeBinding binding = (DBDAttributeBinding)item;
            DBDAttributeConstraint constraint = this.getBindingConstraint(binding);
            return constraint.hasOption("pinned");
        }, new EditingSupport((ColumnViewer)this.columnsViewer){

            protected CellEditor getCellEditor(Object element) {
                return new CustomCheckboxCellEditor((Composite)((TreeViewer)this.getViewer()).getTree(), true);
            }

            protected boolean canEdit(Object element) {
                DBDAttributeBinding binding = (DBDAttributeBinding)element;
                return binding == binding.getTopParent();
            }

            protected Object getValue(Object element) {
                DBDAttributeBinding binding = (DBDAttributeBinding)element;
                DBDAttributeConstraint constraint = FilterSettingsDialog.this.getBindingConstraint(binding);
                return constraint.hasOption("pinned");
            }

            protected void setValue(Object element, Object value) {
                DBDAttributeBinding binding = (DBDAttributeBinding)element;
                DBDAttributeConstraint constraint = FilterSettingsDialog.this.getBindingConstraint(binding);
                if (CommonUtils.getBoolean((Object)value, (boolean)false)) {
                    constraint.setOption("pinned", (Object)SpreadsheetPresentation.getNextPinIndex(FilterSettingsDialog.this.dataFilter));
                } else {
                    constraint.removeOption("pinned");
                }
            }
        });
        if (this.resultSetViewer.getDataSource() != null && this.resultSetViewer.getDataSource().getInfo().supportsResultSetOrdering()) {
            this.columnsController.addColumn(ResultSetMessages.controls_resultset_filter_column_order, null, 16384, true, false, new CellLabelProvider(){

                public void update(ViewerCell cell) {
                    DBDAttributeBinding binding = (DBDAttributeBinding)cell.getElement();
                    DBDAttributeConstraint constraint = FilterSettingsDialog.this.getBindingConstraint(binding);
                    if (constraint.getOrderPosition() > 0) {
                        cell.setText(" " + constraint.getOrderPosition());
                        cell.setImage(DBeaverIcons.getImage((DBPImage)(constraint.isOrderDescending() ? UIIcon.SORT_INCREASE : UIIcon.SORT_DECREASE)));
                    } else {
                        cell.setText(null);
                        cell.setImage(null);
                    }
                }
            });
        }
        this.columnsController.addColumn(ResultSetMessages.controls_resultset_filter_column_criteria, null, 16384, true, false, new CellLabelProvider(){

            public void update(ViewerCell cell) {
                DBDAttributeBinding binding = (DBDAttributeBinding)cell.getElement();
                DBDAttributeConstraint constraint = FilterSettingsDialog.this.getBindingConstraint(binding);
                DBCExecutionContext executionContext = FilterSettingsDialog.this.resultSetViewer.getExecutionContext();
                if (executionContext != null) {
                    cell.setText(SQLUtils.getConstraintCondition((DBPDataSource)executionContext.getDataSource(), (DBDAttributeConstraint)constraint, null, (boolean)true));
                } else {
                    cell.setText(null);
                }
            }
        });
        this.columnsController.createColumns(false);
        this.columnsViewer.setContentProvider((IContentProvider)new TreeContentProvider(){

            public Object[] getChildren(Object parentElement) {
                List nestedBindings = ((DBDAttributeBinding)parentElement).getNestedBindings();
                if (nestedBindings == null || nestedBindings.isEmpty()) {
                    return null;
                }
                Object[] res = nestedBindings.toArray(new DBDAttributeBinding[0]);
                Arrays.sort(res, FilterSettingsDialog.this.activeSorter);
                return res;
            }

            public boolean hasChildren(Object element) {
                List nestedBindings = ((DBDAttributeBinding)element).getNestedBindings();
                return nestedBindings != null && !nestedBindings.isEmpty();
            }
        });
        Tree columnsTree = this.columnsViewer.getTree();
        gd = new GridData(1808);
        gd.heightHint = 300;
        columnsTree.setLayoutData((Object)gd);
        columnsTree.setHeaderVisible(true);
        columnsTree.setLinesVisible(true);
        this.treeEditor = new FilterSettingsTreeEditor(columnsTree);
        Composite tph = UIUtils.createComposite((Composite)columnsGroup, (int)1);
        ToolBar toolbar = new ToolBar(tph, 0x800100);
        toolbar.setLayoutData((Object)new GridData(768));
        this.moveTopButton = FilterSettingsDialog.createToolItem(toolbar, ResultSetMessages.dialog_toolbar_move_to_top, UIIcon.ARROW_TOP, () -> this.moveSelectedItems(false, false));
        this.moveTopButton.setEnabled(false);
        this.moveUpButton = FilterSettingsDialog.createToolItem(toolbar, ResultSetMessages.dialog_toolbar_move_up, UIIcon.ARROW_UP, () -> this.moveSelectedItems(false, true));
        this.moveUpButton.setEnabled(false);
        this.moveDownButton = FilterSettingsDialog.createToolItem(toolbar, ResultSetMessages.dialog_toolbar_move_down, UIIcon.ARROW_DOWN, () -> this.moveSelectedItems(true, true));
        this.moveDownButton.setEnabled(false);
        this.moveBottomButton = FilterSettingsDialog.createToolItem(toolbar, ResultSetMessages.dialog_toolbar_move_to_bottom, UIIcon.ARROW_BOTTOM, () -> this.moveSelectedItems(true, false));
        this.moveBottomButton.setEnabled(false);
        UIUtils.createToolBarSeparator((ToolBar)toolbar, (int)512);
        FilterSettingsDialog.createToolItem(toolbar, ResultSetMessages.dialog_toolbar_sort, UIIcon.SORT, () -> {
            this.attributes.sort(this.ALPHA_SORTER);
            int i = 0;
            while (i < this.attributes.size()) {
                DBDAttributeConstraint constraint = this.getBindingConstraint(this.attributes.get(i));
                constraint.setVisualPosition(i);
                ++i;
            }
            this.refreshData();
        });
        UIUtils.createToolBarSeparator((ToolBar)toolbar, (int)512);
        ToolItem showAllButton = FilterSettingsDialog.createToolItem(toolbar, ResultSetMessages.dialog_toolbar_show_all, null, () -> {
            for (DBDAttributeConstraint constraint : this.constraints) {
                constraint.setVisible(true);
            }
            this.refreshData();
        });
        showAllButton.setImage(UIUtils.getShardImage((String)"IMG_ETOOL_DEF_PERSPECTIVE"));
        ToolItem showNoneButton = FilterSettingsDialog.createToolItem(toolbar, ResultSetMessages.dialog_toolbar_show_none, null, () -> {
            for (DBDAttributeConstraint constraint : this.constraints) {
                constraint.setVisible(false);
            }
            this.refreshData();
        });
        showNoneButton.setImage(UIUtils.getShardImage((String)"IMG_ELCL_REMOVEALL"));
        FilterSettingsDialog.createToolItem(toolbar, ResultSetMessages.dialog_toolbar_reset, UIIcon.REFRESH, () -> {
            this.dataFilter.reset();
            this.constraints = new ArrayList<DBDAttributeConstraint>(this.dataFilter.getConstraints());
            this.refreshData();
            this.orderText.setText("");
            this.whereText.setText("");
        });
        this.columnsViewer.addSelectionChangedListener(event -> this.updateButtons());
        CTabItem libsTab = new CTabItem(tabFolder, 0);
        libsTab.setText(ResultSetMessages.controls_resultset_filter_group_columns);
        libsTab.setToolTipText(ResultSetMessages.controls_resultset_filter_group_columns_tooltip_text);
        libsTab.setControl((Control)columnsGroup);
        this.createCustomFilters(tabFolder);
        this.columnsViewer.setInput(this.attributes);
        this.refreshData();
        UIUtils.asyncExec(() -> {
            UIUtils.resizeShell((Shell)this.getShell());
            UIUtils.packColumns((Tree)this.columnsViewer.getTree(), (boolean)true, (float[])new float[]{0.45f, 0.05f, 0.05f, 0.05f, 0.05f, 0.35f});
        });
        if (!this.resultSetViewer.supportsDataFilter()) {
            Label warnLabel = new Label(composite, 0);
            warnLabel.setText(ResultSetMessages.controls_resultset_filter_warning_custom_order_disabled);
            warnLabel.setForeground(parent.getDisplay().getSystemColor(3));
        }
        return parent;
    }

    private int getItemsCount() {
        return this.columnsViewer.getTree().getItemCount();
    }

    private void refreshData() {
        this.attributes.sort(this.activeSorter);
        this.columnsViewer.refresh();
        this.columnsViewer.expandAll();
    }

    private void moveColumns(TreeItem curItem, int newIndex, boolean reverse) {
        DBDAttributeConstraint start = this.getBindingConstraint((DBDAttributeBinding)curItem.getData());
        DBDAttributeConstraint end = this.getBindingConstraint((DBDAttributeBinding)this.columnsViewer.getTree().getItem(newIndex).getData());
        int startingVisualPosition = start.getVisualPosition();
        int endingVisualPosition = end.getVisualPosition();
        int currentVisualPosition = startingVisualPosition;
        if (!reverse) {
            int i = startingVisualPosition - 1;
            while (i >= endingVisualPosition) {
                currentVisualPosition = this.swapVisualPositions(currentVisualPosition, i);
                --i;
            }
        } else {
            int i = startingVisualPosition + 1;
            while (i <= endingVisualPosition) {
                currentVisualPosition = this.swapVisualPositions(currentVisualPosition, i);
                ++i;
            }
        }
        this.refreshData();
    }

    private int swapVisualPositions(int currentVisualPosition, int i) {
        DBDAttributeConstraint currentConstraint = this.constraints.get(currentVisualPosition);
        currentVisualPosition = currentConstraint.getVisualPosition();
        DBDAttributeConstraint swappingConstraint = this.constraints.get(i);
        int swappingConstraintVisualPosition = swappingConstraint.getVisualPosition();
        currentConstraint.setVisualPosition(swappingConstraintVisualPosition);
        swappingConstraint.setVisualPosition(currentVisualPosition);
        Collections.swap(this.constraints, i, currentVisualPosition);
        return swappingConstraintVisualPosition;
    }

    private void moveColumns(int curIndex, int newIndex) {
        if (curIndex == newIndex) {
            return;
        }
        DBDAttributeConstraint curAttr = this.getBindingConstraint((DBDAttributeBinding)this.columnsViewer.getTree().getItem(curIndex).getData());
        for (DBDAttributeConstraint c : this.constraints) {
            if (newIndex < curIndex) {
                if (c.getVisualPosition() < newIndex || c.getVisualPosition() >= curIndex) continue;
                c.setVisualPosition(c.getVisualPosition() + 1);
                continue;
            }
            if (c.getVisualPosition() <= curIndex || c.getVisualPosition() > newIndex) continue;
            c.setVisualPosition(c.getVisualPosition() - 1);
        }
        curAttr.setVisualPosition(newIndex);
        this.refreshData();
        this.moveTopButton.setEnabled(newIndex > 0);
        this.moveUpButton.setEnabled(newIndex > 0);
        this.moveDownButton.setEnabled(newIndex < this.getItemsCount() - 1);
        this.moveBottomButton.setEnabled(newIndex < this.getItemsCount() - 1);
    }

    private void createCustomFilters(CTabFolder tabFolder) {
        Composite filterGroup = new Composite((Composite)tabFolder, 0);
        filterGroup.setLayoutData((Object)new GridData(1808));
        filterGroup.setLayout((Layout)new GridLayout(1, false));
        UIUtils.createControlLabel((Composite)filterGroup, (String)ResultSetMessages.controls_resultset_filter_label_where);
        this.whereText = new Text(filterGroup, 2818);
        this.whereText.setLayoutData((Object)new GridData(1808));
        if (this.dataFilter.getWhere() != null) {
            this.whereText.setText(this.dataFilter.getWhere());
        }
        UIUtils.createControlLabel((Composite)filterGroup, (String)ResultSetMessages.controls_resultset_filter_label_orderby);
        this.orderText = new Text(filterGroup, 2818);
        this.orderText.setLayoutData((Object)new GridData(1808));
        if (this.dataFilter.getOrder() != null) {
            this.orderText.setText(this.dataFilter.getOrder());
        }
        if (!this.resultSetViewer.supportsDataFilter()) {
            filterGroup.setEnabled(false);
            ControlEnableState.disable((Control)filterGroup);
        }
        CTabItem libsTab = new CTabItem(tabFolder, 0);
        libsTab.setText(ResultSetMessages.controls_resultset_filter_group_custom);
        libsTab.setToolTipText(ResultSetMessages.controls_resultset_filter_group_custom_tooltip_text);
        libsTab.setControl((Control)filterGroup);
    }

    public int open() {
        return super.open();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
    }

    protected void okPressed() {
        this.columnsViewer.applyEditorValue();
        this.treeEditor.okPressed();
        boolean hasVisibleColumns = false;
        for (DBDAttributeConstraint constraint : this.dataFilter.getConstraints()) {
            if (!constraint.isVisible()) continue;
            hasVisibleColumns = true;
            break;
        }
        if (!hasVisibleColumns) {
            UIUtils.showMessageBox((Shell)this.getShell(), (String)"Bad filter", (String)"You have to set at least one column visible", (int)8);
            return;
        }
        if (!CommonUtils.isEmpty((String)this.orderText.getText())) {
            this.dataFilter.setOrder(this.orderText.getText());
        } else {
            this.dataFilter.setOrder(null);
        }
        if (!CommonUtils.isEmpty((String)this.whereText.getText())) {
            this.dataFilter.setWhere(this.whereText.getText());
        } else {
            this.dataFilter.setWhere(null);
        }
        boolean filtersChanged = true;
        if (this.dataFilter.equalFilters(this.resultSetViewer.getModel().getDataFilter(), true)) {
            filtersChanged = false;
        }
        this.resultSetViewer.setDataFilter(this.dataFilter, filtersChanged);
        super.okPressed();
    }

    private void updateButtons() {
        Tree tree = this.columnsViewer.getTree();
        TreeItem[] selection = tree.getSelection();
        boolean moveDownEnabled = selection.length > 0 && tree.indexOf(selection[selection.length - 1]) != tree.getItemCount() - 1;
        boolean moveUpEnabled = selection.length > 0 && tree.indexOf(selection[0]) != 0;
        boolean moveToBottomEnabled = selection.length > 0 && tree.indexOf(selection[0]) != tree.getItemCount() - selection.length;
        boolean moveToTopEnabled = selection.length > 0 && tree.indexOf(selection[selection.length - 1]) != selection.length - 1;
        this.moveBottomButton.setEnabled(moveToBottomEnabled);
        this.moveDownButton.setEnabled(moveDownEnabled);
        this.moveTopButton.setEnabled(moveToTopEnabled);
        this.moveUpButton.setEnabled(moveUpEnabled);
    }

    private void moveSelectedItems(boolean reverse, boolean singleStep) {
        Tree tree = this.columnsViewer.getTree();
        TreeItem[] selection = tree.getSelection();
        int j = 0;
        if (reverse) {
            int i = selection.length - 1;
            while (i >= 0) {
                if (!singleStep || tree.indexOf(selection[i]) != tree.getItemCount() - 1 - j) {
                    this.moveColumns(selection[i], !singleStep ? this.getItemsCount() - 1 - j++ : tree.indexOf(selection[i]) + 1, true);
                    this.updateButtons();
                }
                --i;
            }
        } else {
            TreeItem[] treeItemArray = selection;
            int n = selection.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem treeItem = treeItemArray[n2];
                if (!singleStep || tree.indexOf(treeItem) != j) {
                    this.moveColumns(treeItem, !singleStep ? j++ : tree.indexOf(treeItem) - 1, false);
                    this.updateButtons();
                }
                ++n2;
            }
        }
    }

    @NotNull
    private DBDAttributeConstraint getBindingConstraint(DBDAttributeBinding binding) {
        for (DBDAttributeConstraint constraint : this.constraints) {
            if (!constraint.matches((DBSAttributeBase)binding, true)) continue;
            return constraint;
        }
        throw new IllegalStateException("Can't find constraint for binding " + String.valueOf(binding));
    }

    private static ToolItem createToolItem(ToolBar toolBar, String text, DBIcon icon, final Runnable action) {
        ToolItem item = new ToolItem(toolBar, 8);
        if (icon != null) {
            item.setImage(DBeaverIcons.getImage((DBPImage)icon));
        }
        if (text != null) {
            item.setToolTipText(text);
        }
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                action.run();
            }
        });
        return item;
    }

    class CheckStateProvider
    implements ICheckStateProvider {
        CheckStateProvider() {
        }

        public boolean isChecked(Object element) {
            return FilterSettingsDialog.this.getBindingConstraint((DBDAttributeBinding)element).isVisible();
        }

        public boolean isGrayed(Object element) {
            return false;
        }
    }

    class ColumnLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ColumnLabelProvider() {
        }

        @Nullable
        public Image getColumnImage(Object element, int columnIndex) {
            DBDAttributeConstraint constraint;
            DBDAttributeBinding binding = (DBDAttributeBinding)element;
            if (columnIndex == 0) {
                return DBeaverIcons.getImage((DBPImage)DBValueFormatting.getObjectImage((DBPObject)binding.getMetaAttribute()));
            }
            if (columnIndex == 2 && (constraint = FilterSettingsDialog.this.getBindingConstraint(binding)).getOrderPosition() > 0) {
                return DBeaverIcons.getImage((DBPImage)(constraint.isOrderDescending() ? UIIcon.SORT_INCREASE : UIIcon.SORT_DECREASE));
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            DBDAttributeBinding binding = (DBDAttributeBinding)element;
            DBDAttributeConstraint constraint = FilterSettingsDialog.this.getBindingConstraint(binding);
            switch (columnIndex) {
                case 0: {
                    return constraint.getAttribute().getName();
                }
                case 1: {
                    return String.valueOf(constraint.getOriginalVisualPosition() + 1);
                }
                case 2: {
                    int orderPosition = constraint.getOrderPosition();
                    if (orderPosition > 0) {
                        return " " + String.valueOf(orderPosition);
                    }
                    return "";
                }
                case 3: {
                    String condition;
                    DBCExecutionContext executionContext = FilterSettingsDialog.this.resultSetViewer.getExecutionContext();
                    if (executionContext != null && (condition = SQLUtils.getConstraintCondition((DBPDataSource)executionContext.getDataSource(), (DBDAttributeConstraint)constraint, null, (boolean)true)) != null) {
                        return condition;
                    }
                    return "";
                }
            }
            return "";
        }
    }

    private class FilterSettingsTreeEditor
    extends CustomTreeEditor {
        private static final int COLUMN_ORDER_INDEX = 4;
        private static final int COLUMN_CRITERIA_INDEX = 5;
        private final Tree columnsTree;
        @Nullable
        private TreeItem lastTreeItem;
        @Nullable
        private Control lastEditor;

        public FilterSettingsTreeEditor(Tree columnsTree) {
            super(columnsTree);
            this.firstTraverseIndex = 5;
            this.lastTraverseIndex = 5;
            this.columnsTree = columnsTree;
        }

        protected Control createEditor(Tree tree, int index, TreeItem item) {
            if (index == 4) {
                this.toggleColumnOrder(item);
                return null;
            }
            if (index == 5 && FilterSettingsDialog.this.resultSetViewer.supportsDataFilter()) {
                Text text = new Text((Composite)this.columnsTree, 2048);
                text.setText(item.getText(index));
                text.selectAll();
                this.lastEditor = text;
                this.lastTreeItem = item;
                return text;
            }
            return null;
        }

        protected void saveEditorValue(Control control, int index, TreeItem item) {
            Text text = (Text)control;
            String criteria = text.getText().trim();
            DBDAttributeConstraint constraint = FilterSettingsDialog.this.getBindingConstraint((DBDAttributeBinding)item.getData());
            if (CommonUtils.isEmpty((String)criteria)) {
                constraint.setCriteria(null);
            } else {
                constraint.setCriteria(criteria);
            }
            item.setText(5, criteria);
        }

        public void okPressed() {
            if (RuntimeUtils.isMacOS() && this.lastTreeItem != null && this.lastEditor != null) {
                this.saveEditorValue(this.lastEditor, 5, this.lastTreeItem);
            }
        }

        private void toggleColumnOrder(TreeItem item) {
            DBDAttributeConstraint constraint = FilterSettingsDialog.this.getBindingConstraint((DBDAttributeBinding)item.getData());
            if (constraint.getOrderPosition() == 0) {
                constraint.setOrderPosition(FilterSettingsDialog.this.dataFilter.getMaxOrderingPosition() + 1);
                constraint.setOrderDescending(false);
            } else if (!constraint.isOrderDescending()) {
                constraint.setOrderDescending(true);
            } else {
                constraint.setOrderPosition(0);
                constraint.setOrderDescending(false);
            }
            FilterSettingsDialog.this.columnsViewer.refresh();
        }
    }
}

