/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.stream.Collectors;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.StringUtils;

public class Introspector {
    private final Class<?> theClass;
    private final String field;

    public Introspector(Class<?> theClass, String field) {
        if (field == null || field.isEmpty()) {
            throw new RuntimeException("Field may not be empty: " + this);
        }
        this.theClass = theClass;
        this.field = field;
    }

    private Method getGetMethod() throws IntrospectorException {
        String methodName = "get" + Introspector.fromSnakeCase(this.field);
        try {
            return this.theClass.getMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException ex) {
            throw new IntrospectorException(this.theClass.getName() + "." + methodName, ex);
        }
    }

    private Method getSetMethod(Class<?> argType) throws IntrospectorException {
        String methodName = "set" + Introspector.fromSnakeCase(this.field);
        try {
            return this.theClass.getMethod(methodName, argType);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new IntrospectorException(this.theClass.getName() + "." + methodName, e);
        }
    }

    private static String fromSnakeCase(String nameInSnakeCase) {
        StringBuilder sb = new StringBuilder();
        for (String s : nameInSnakeCase.split("-")) {
            sb.append(StringUtils.capitalize(s));
        }
        return sb.toString();
    }

    private Class<?> getMethodReturnType(Method method) throws IntrospectorException {
        Class<?> ret;
        try {
            ret = method.getReturnType();
        }
        catch (Exception e) {
            throw new IntrospectorException(this.theClass.getName() + "." + method.getName() + " return type.", e);
        }
        return ret;
    }

    private Method getToStringConverter(Class<?> argType) throws NoSuchMethodException {
        return argType.isEnum() ? argType.getMethod("name", new Class[0]) : String.class.getMethod("valueOf", argType);
    }

    private Method getFromStringConverter(Class<?> argType) {
        Method method;
        if (argType.isEnum()) {
            try {
                method = Enum.class.getMethod("valueOf", Class.class, String.class);
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw new RuntimeException("Enum.getMethod(valueOf(Class, String)): " + argType, e);
            }
        }
        if (argType.isPrimitive()) {
            if (argType == Integer.TYPE) {
                argType = Integer.class;
            } else if (argType == Boolean.TYPE) {
                argType = Boolean.class;
            } else if (argType == Float.TYPE) {
                argType = Float.class;
            } else if (argType == Double.TYPE) {
                argType = Double.class;
            } else if (argType == Character.TYPE) {
                argType = Character.class;
            } else {
                throw new IllegalArgumentException("Need compatible class for primitive " + argType.getName());
            }
        }
        try {
            method = argType.getMethod("valueOf", String.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new IllegalArgumentException(argType.getName() + ".getMethod(valueOf(String))", e);
        }
        return method;
    }

    public String getter(Object obj) throws IntrospectorException {
        Method convertMethod;
        Method getMethod = this.getGetMethod();
        Class<?> fieldType = this.getMethodReturnType(getMethod);
        if (fieldType == String.class) {
            try {
                return (String)getMethod.invoke(obj, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new IntrospectorException(getMethod.getName() + "(obj)", e);
            }
        }
        Object result = null;
        try {
            result = getMethod.invoke(obj, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new IntrospectorException(getMethod.getName() + "(obj)", e);
        }
        try {
            convertMethod = this.getToStringConverter(fieldType);
        }
        catch (NoSuchMethodException nsme) {
            throw new IntrospectorException("No String converter found for " + fieldType, nsme);
        }
        if (Modifier.isStatic(convertMethod.getModifiers())) {
            try {
                return (String)convertMethod.invoke(null, result);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new IntrospectorException(convertMethod.getName() + "(null, result)", e);
            }
        }
        try {
            return (String)convertMethod.invoke(result, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new IntrospectorException(convertMethod.getName() + "(result)", e);
        }
    }

    public void setter(Object obj, String value) throws IntrospectorException {
        Method getMethod = this.getGetMethod();
        Class<?> fieldType = this.getMethodReturnType(getMethod);
        Method setMethod = this.getSetMethod(fieldType);
        if (fieldType == String.class) {
            try {
                setMethod.invoke(obj, value);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new IntrospectorException(setMethod.getName() + "(obj, " + value + ")", e);
            }
        }
        Method convertMethod = this.getFromStringConverter(fieldType);
        Object result = null;
        if (fieldType.isEnum()) {
            try {
                result = convertMethod.invoke(null, fieldType, value);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new IntrospectorException(convertMethod.getName() + "(null, " + fieldType.getName() + ", " + value + ")", e);
            }
        }
        try {
            result = convertMethod.invoke(null, value);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new IntrospectorException(convertMethod.getName() + "(null, " + value + ")", e);
        }
        try {
            setMethod.invoke(obj, result);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new IntrospectorException(setMethod.getName() + "(result)", e);
        }
    }

    public static Class<?> getClassByName(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }

    public static <T> Constructor<T> getConstructor(Class<T> cl, Class[] types) {
        Constructor<T> constructor;
        try {
            constructor = cl.getDeclaredConstructor(types);
        }
        catch (NoSuchMethodException | SecurityException ex) {
            constructor = null;
        }
        return constructor;
    }

    public static <T> T construct(Constructor<T> constructor, Object[] params) throws IntrospectorException {
        T instance;
        try {
            instance = constructor.newInstance(params);
        }
        catch (InvocationTargetException ite) {
            throw new IntrospectorException(ite);
        }
        catch (IllegalAccessException | InstantiationException ex) {
            instance = null;
        }
        return instance;
    }

    public static Object instantiate(String tag, Class[] types, Object[] params) throws IntrospectorException {
        Class<?> messageClass;
        try {
            messageClass = Class.forName(tag);
        }
        catch (ClassNotFoundException ex) {
            throw new IntrospectorException("Unable to find class " + tag, ex);
        }
        return Introspector.instantiate(messageClass, types, params);
    }

    public static <T> T instantiate(Class<T> messageClass, Class[] types, Object[] params) throws IntrospectorException {
        T instance;
        Constructor<T> constructor;
        String tag = messageClass.getName();
        try {
            constructor = messageClass.getDeclaredConstructor(types);
        }
        catch (NoSuchMethodException | SecurityException ex) {
            throw new IntrospectorException("Unable to find constructor " + StringUtils.lastPart(tag, ".") + "(" + CollectionUtils.transform(types, CollectionUtils.alwaysTrue(), Class::getName, Collectors.joining(",")) + ")", ex);
        }
        try {
            instance = constructor.newInstance(params);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
            throw new IntrospectorException("Failed to construct " + StringUtils.lastPart(tag, "."), ex);
        }
        return instance;
    }

    public static <T> T invokeMethod(Object object, String methodName, Class<T> returnClass) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return returnClass.cast(object.getClass().getMethod(methodName, new Class[0]).invoke(object, new Object[0]));
    }

    public static void invokeVoidMethod(Object object, String methodName) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        object.getClass().getMethod(methodName, new Class[0]).invoke(object, new Object[0]);
    }

    public static class IntrospectorException
    extends ReflectiveOperationException {
        public IntrospectorException(Throwable cause) {
            super(cause);
        }

        public IntrospectorException(String err, Throwable cause) {
            super(err, cause);
        }
    }
}

