/*
 * Decompiled with CFR 0.152.
 */
package com.drew.imaging.jpeg.test;

import com.drew.imaging.jpeg.JpegSegmentData;
import com.drew.lang.test.TestHelper;
import java.io.File;
import junit.framework.TestCase;

public class JpegSegmentDataTest
extends TestCase {
    public JpegSegmentDataTest(String name) {
        super(name);
    }

    public void testAddAndGetSegment() throws Exception {
        JpegSegmentData segmentData = new JpegSegmentData();
        byte segmentMarker = 12;
        byte[] segmentBytes = new byte[]{1, 2, 3};
        segmentData.addSegment(segmentMarker, segmentBytes);
        JpegSegmentDataTest.assertEquals((int)1, (int)segmentData.getSegmentCount(segmentMarker));
        TestHelper.assertEqualArrays(segmentBytes, segmentData.getSegment(segmentMarker));
    }

    public void testContainsSegment() throws Exception {
        JpegSegmentData segmentData = new JpegSegmentData();
        byte segmentMarker = 12;
        byte[] segmentBytes = new byte[]{1, 2, 3};
        JpegSegmentDataTest.assertTrue((!segmentData.containsSegment(segmentMarker) ? 1 : 0) != 0);
        segmentData.addSegment(segmentMarker, segmentBytes);
        JpegSegmentDataTest.assertTrue((boolean)segmentData.containsSegment(segmentMarker));
    }

    public void testAddingMultipleSegments() throws Exception {
        JpegSegmentData segmentData = new JpegSegmentData();
        byte segmentMarker1 = 12;
        byte segmentMarker2 = 21;
        byte[] segmentBytes1 = new byte[]{1, 2, 3};
        byte[] segmentBytes2 = new byte[]{3, 2, 1};
        segmentData.addSegment(segmentMarker1, segmentBytes1);
        segmentData.addSegment(segmentMarker2, segmentBytes2);
        JpegSegmentDataTest.assertEquals((int)1, (int)segmentData.getSegmentCount(segmentMarker1));
        JpegSegmentDataTest.assertEquals((int)1, (int)segmentData.getSegmentCount(segmentMarker2));
        TestHelper.assertEqualArrays(segmentBytes1, segmentData.getSegment(segmentMarker1));
        TestHelper.assertEqualArrays(segmentBytes2, segmentData.getSegment(segmentMarker2));
    }

    public void testSegmentWithMultipleOccurrences() throws Exception {
        JpegSegmentData segmentData = new JpegSegmentData();
        byte segmentMarker = 12;
        byte[] segmentBytes1 = new byte[]{1, 2, 3};
        byte[] segmentBytes2 = new byte[]{3, 2, 1};
        segmentData.addSegment(segmentMarker, segmentBytes1);
        segmentData.addSegment(segmentMarker, segmentBytes2);
        JpegSegmentDataTest.assertEquals((int)2, (int)segmentData.getSegmentCount(segmentMarker));
        TestHelper.assertEqualArrays(segmentBytes1, segmentData.getSegment(segmentMarker));
        TestHelper.assertEqualArrays(segmentBytes1, segmentData.getSegment(segmentMarker, 0));
        TestHelper.assertEqualArrays(segmentBytes2, segmentData.getSegment(segmentMarker, 1));
    }

    public void testRemoveSegmentOccurrence() throws Exception {
        JpegSegmentData segmentData = new JpegSegmentData();
        byte segmentMarker = 12;
        byte[] segmentBytes1 = new byte[]{1, 2, 3};
        byte[] segmentBytes2 = new byte[]{3, 2, 1};
        segmentData.addSegment(segmentMarker, segmentBytes1);
        segmentData.addSegment(segmentMarker, segmentBytes2);
        JpegSegmentDataTest.assertEquals((int)2, (int)segmentData.getSegmentCount(segmentMarker));
        TestHelper.assertEqualArrays(segmentBytes1, segmentData.getSegment(segmentMarker, 0));
        segmentData.removeSegmentOccurrence(segmentMarker, 0);
        TestHelper.assertEqualArrays(segmentBytes2, segmentData.getSegment(segmentMarker, 0));
    }

    public void testRemoveSegment() throws Exception {
        JpegSegmentData segmentData = new JpegSegmentData();
        byte segmentMarker = 12;
        byte[] segmentBytes1 = new byte[]{1, 2, 3};
        byte[] segmentBytes2 = new byte[]{3, 2, 1};
        segmentData.addSegment(segmentMarker, segmentBytes1);
        segmentData.addSegment(segmentMarker, segmentBytes2);
        JpegSegmentDataTest.assertEquals((int)2, (int)segmentData.getSegmentCount(segmentMarker));
        JpegSegmentDataTest.assertTrue((boolean)segmentData.containsSegment(segmentMarker));
        TestHelper.assertEqualArrays(segmentBytes1, segmentData.getSegment(segmentMarker, 0));
        segmentData.removeSegment(segmentMarker);
        JpegSegmentDataTest.assertTrue((!segmentData.containsSegment(segmentMarker) ? 1 : 0) != 0);
        JpegSegmentDataTest.assertEquals((int)0, (int)segmentData.getSegmentCount(segmentMarker));
    }

    public void testToAndFromFile() throws Exception {
        JpegSegmentData segmentData = new JpegSegmentData();
        byte segmentMarker = 12;
        byte[] segmentBytes = new byte[]{1, 2, 3};
        segmentData.addSegment(segmentMarker, segmentBytes);
        JpegSegmentDataTest.assertTrue((boolean)segmentData.containsSegment(segmentMarker));
        File tempFile = File.createTempFile("JpegSegmentDataTest", "tmp");
        JpegSegmentData.ToFile(tempFile, segmentData);
        JpegSegmentDataTest.assertTrue((boolean)tempFile.exists());
        JpegSegmentDataTest.assertTrue((tempFile.length() > 0L ? 1 : 0) != 0);
        segmentData = JpegSegmentData.FromFile(tempFile);
        tempFile.delete();
        JpegSegmentDataTest.assertTrue((!tempFile.exists() ? 1 : 0) != 0);
        JpegSegmentDataTest.assertNotNull((Object)segmentData);
        JpegSegmentDataTest.assertTrue((boolean)segmentData.containsSegment(segmentMarker));
        TestHelper.assertEqualArrays(segmentBytes, segmentData.getSegment(segmentMarker));
    }
}

