/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow.x11;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.StructAccessor;
import com.jogamp.common.os.MachineDataInfo;
import java.nio.ByteBuffer;
import jogamp.common.os.MachineDataInfoRuntime;
import jogamp.nativewindow.x11.XRenderDirectFormat;

public class XRenderPictFormat {
    StructAccessor accessor;
    private static final int mdIdx = MachineDataInfoRuntime.getStatic().ordinal();
    private final MachineDataInfo md;
    private static final int[] XRenderPictFormat_size = new int[]{32, 32, 32, 32, 32, 32, 32, 40, 40, 40};
    private static final int[] id_offset = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int[] type_offset = new int[]{4, 4, 4, 4, 4, 4, 4, 8, 8, 8};
    private static final int[] depth_offset = new int[]{8, 8, 8, 8, 8, 8, 8, 12, 12, 12};
    private static final int[] direct_offset = new int[]{12, 12, 12, 12, 12, 12, 12, 16, 16, 16};
    private static final int[] direct_size = new int[]{16, 16, 16, 16, 16, 16, 16, 16, 16, 16};
    private static final int[] colormap_offset = new int[]{28, 28, 28, 28, 28, 28, 28, 32, 32, 32};

    public static int size() {
        return XRenderPictFormat_size[mdIdx];
    }

    public static XRenderPictFormat create() {
        return XRenderPictFormat.create(Buffers.newDirectByteBuffer((int)XRenderPictFormat.size()));
    }

    public static XRenderPictFormat create(ByteBuffer byteBuffer) {
        return new XRenderPictFormat(byteBuffer);
    }

    XRenderPictFormat(ByteBuffer byteBuffer) {
        this.md = MachineDataInfo.StaticConfig.values()[XRenderPictFormat.mdIdx].md;
        this.accessor = new StructAccessor(byteBuffer);
    }

    public ByteBuffer getBuffer() {
        return this.accessor.getBuffer();
    }

    public XRenderPictFormat setId(long l) {
        this.accessor.setLongAt(id_offset[mdIdx], l, this.md.pointerSizeInBytes());
        return this;
    }

    public long getId() {
        return this.accessor.getLongAt(id_offset[mdIdx], this.md.pointerSizeInBytes());
    }

    public XRenderPictFormat setType(int n) {
        this.accessor.setIntAt(type_offset[mdIdx], n, this.md.intSizeInBytes());
        return this;
    }

    public int getType() {
        return this.accessor.getIntAt(type_offset[mdIdx], this.md.intSizeInBytes());
    }

    public XRenderPictFormat setDepth(int n) {
        this.accessor.setIntAt(depth_offset[mdIdx], n, this.md.intSizeInBytes());
        return this;
    }

    public int getDepth() {
        return this.accessor.getIntAt(depth_offset[mdIdx], this.md.intSizeInBytes());
    }

    public XRenderDirectFormat getDirect() {
        return XRenderDirectFormat.create(this.accessor.slice(direct_offset[mdIdx], direct_size[mdIdx]));
    }

    public XRenderPictFormat setColormap(long l) {
        this.accessor.setLongAt(colormap_offset[mdIdx], l, this.md.pointerSizeInBytes());
        return this;
    }

    public long getColormap() {
        return this.accessor.getLongAt(colormap_offset[mdIdx], this.md.pointerSizeInBytes());
    }
}

