/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.comparesegments;

import tim.prune.data.DataPoint;
import tim.prune.data.Timestamp;

public class IntersectionResult
implements Comparable<IntersectionResult> {
    private final ResultPoint _firstPoint;
    private final ResultPoint _secondPoint;

    public IntersectionResult(DataPoint dataPoint, DataPoint dataPoint2, Timestamp timestamp, Timestamp timestamp2, double d, double d2, double d3, double d4) {
        this._firstPoint = new ResultPoint(dataPoint, timestamp, d, d3);
        this._secondPoint = new ResultPoint(dataPoint2, timestamp2, d2, d4);
    }

    private IntersectionResult(ResultPoint resultPoint, ResultPoint resultPoint2) {
        this._firstPoint = resultPoint;
        this._secondPoint = resultPoint2;
    }

    IntersectionResult reverse() {
        return new IntersectionResult(this._secondPoint, this._firstPoint);
    }

    public DataPoint getFirstPoint() {
        return this._firstPoint._point;
    }

    public DataPoint getSecondPoint() {
        return this._secondPoint._point;
    }

    public long getFirstDurationSeconds(IntersectionResult intersectionResult) {
        return this._firstPoint._timestamp.getSecondsSince(intersectionResult._firstPoint._timestamp);
    }

    public long getSecondDurationSeconds(IntersectionResult intersectionResult) {
        return this._secondPoint._timestamp.getSecondsSince(intersectionResult._secondPoint._timestamp);
    }

    public double getFirstDistanceRadians(IntersectionResult intersectionResult) {
        return this._firstPoint._distance - intersectionResult._firstPoint._distance;
    }

    public double getSecondDistanceRadians(IntersectionResult intersectionResult) {
        return this._secondPoint._distance - intersectionResult._secondPoint._distance;
    }

    public double getDeltaSpeedRadiansPerSec() {
        return this._secondPoint._speed - this._firstPoint._speed;
    }

    @Override
    public int compareTo(IntersectionResult intersectionResult) {
        if (intersectionResult == null || this._firstPoint._timestamp.isBefore(intersectionResult._firstPoint._timestamp)) {
            return -1;
        }
        if (intersectionResult._firstPoint._timestamp.isBefore(this._firstPoint._timestamp)) {
            return 1;
        }
        int n = Double.compare(this._firstPoint._distance, intersectionResult._firstPoint._distance);
        if (n != 0) {
            return n;
        }
        if (this._secondPoint._timestamp.isBefore(intersectionResult._secondPoint._timestamp)) {
            return -1;
        }
        if (intersectionResult._secondPoint._timestamp.isBefore(this._secondPoint._timestamp)) {
            return 1;
        }
        return Double.compare(this._secondPoint._distance, intersectionResult._secondPoint._distance);
    }

    private static class ResultPoint {
        private final DataPoint _point;
        private final Timestamp _timestamp;
        private final double _distance;
        private final double _speed;

        private ResultPoint(DataPoint dataPoint, Timestamp timestamp, double d, double d2) {
            this._point = dataPoint;
            this._timestamp = timestamp;
            this._distance = d;
            this._speed = d2;
        }
    }
}

