/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Segments structures in images based on a second derivative image
features.


IMPORTANT
The SegmentationLevelSetImageFilter class and the LaplacianSegmentationLevelSetFunction class contain additional information necessary to the full
understanding of how to use this filter.
OVERVIEW
This class is a level set method segmentation filter. It constructs a
speed function which is zero at image edges as detected by a Laplacian
filter. The evolving level set front will therefore tend to lock onto
zero crossings in the image. The level set front moves fastest near
edges.

The Laplacian segmentation filter is intended primarily as a tool for
refining existing segmentations. The initial isosurface (as given in
the seed input image) should ideally be very close to the segmentation
boundary of interest. The idea is that a rough segmentation can be
refined by allowing the isosurface to deform slightly to achieve a
better fit to the edge features of an image. One example of such an
application is to refine the output of a hand segmented image.

Because values in the Laplacian feature image will tend to be low
except near edge features, this filter is not effective for segmenting
large image regions from small seed surfaces.
INPUTS
This filter requires two inputs. The first input is a seed image. This
seed image must contain an isosurface that you want to use as the seed
for your segmentation. It can be a binary, graylevel, or floating
point image. The only requirement is that it contain a closed
isosurface that you will identify as the seed by setting the
IsosurfaceValue parameter of the filter. For a binary image you will
want to set your isosurface value halfway between your on and off
values (i.e. for 0's and 1's, use an isosurface value of 0.5).

The second input is the feature image. This is the image from which
the speed function will be calculated. For most applications, this is
the image that you want to segment. The desired isosurface in your
seed image should lie within the region of your feature image that you
are trying to segment.
 Note that this filter does no preprocessing of the feature image
before thresholding. Because second derivative calculations are highly
sensitive to noise, isotropic or anisotropic smoothing of the feature
image can dramatically improve the results.


See SegmentationLevelSetImageFilter for more information on Inputs.
OUTPUTS
The filter outputs a single, scalar, real-valued image. Positive
*values in the output image are inside the segmented region and
negative *values in the image are outside of the inside region. The
zero crossings of *the image correspond to the position of the level
set front.

See SparseFieldLevelSetImageFilter and SegmentationLevelSetImageFilter for more information.
PARAMETERS
This filter has no parameters other than those described in SegmentationLevelSetImageFilter .

See:
 SegmentationLevelSetImageFilter

 LaplacianSegmentationLevelSetFunction ,

 SparseFieldLevelSetImageFilter

 itk::simple::LaplacianSegmentationLevelSet for the procedural interface

 itk::LaplacianSegmentationLevelSetImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkLaplacianSegmentationLevelSetImageFilter.h
*/
public class LaplacianSegmentationLevelSetImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected LaplacianSegmentationLevelSetImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.LaplacianSegmentationLevelSetImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(LaplacianSegmentationLevelSetImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(LaplacianSegmentationLevelSetImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::LaplacianSegmentationLevelSetImageFilter::~LaplacianSegmentationLevelSetImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_LaplacianSegmentationLevelSetImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::LaplacianSegmentationLevelSetImageFilter::LaplacianSegmentationLevelSetImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  LaplacianSegmentationLevelSetImageFilter() {
    this(SimpleITKJNI.new_LaplacianSegmentationLevelSetImageFilter(), true);
  }

  /**
Self&amp; itk::simple::LaplacianSegmentationLevelSetImageFilter::SetMaximumRMSError(double MaximumRMSError)
*/
public  void setMaximumRMSError(double MaximumRMSError) {
    SimpleITKJNI.LaplacianSegmentationLevelSetImageFilter_setMaximumRMSError(swigCPtr, this, MaximumRMSError);
  }

  /**
double itk::simple::LaplacianSegmentationLevelSetImageFilter::GetMaximumRMSError() const
*/
public  double getMaximumRMSError() {
    return SimpleITKJNI.LaplacianSegmentationLevelSetImageFilter_getMaximumRMSError(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::LaplacianSegmentationLevelSetImageFilter::SetPropagationScaling(double PropagationScaling)
*/
public  void setPropagationScaling(double PropagationScaling) {
    SimpleITKJNI.LaplacianSegmentationLevelSetImageFilter_setPropagationScaling(swigCPtr, this, PropagationScaling);
  }

  /**
double itk::simple::LaplacianSegmentationLevelSetImageFilter::GetPropagationScaling() const
*/
public  double getPropagationScaling() {
    return SimpleITKJNI.LaplacianSegmentationLevelSetImageFilter_getPropagationScaling(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::LaplacianSegmentationLevelSetImageFilter::SetCurvatureScaling(double CurvatureScaling)
*/
public  void setCurvatureScaling(double CurvatureScaling) {
    SimpleITKJNI.LaplacianSegmentationLevelSetImageFilter_setCurvatureScaling(swigCPtr, this, CurvatureScaling);
  }

  /**
double itk::simple::LaplacianSegmentationLevelSetImageFilter::GetCurvatureScaling() const
*/
public  double getCurvatureScaling() {
    return SimpleITKJNI.LaplacianSegmentationLevelSetImageFilter_getCurvatureScaling(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::LaplacianSegmentationLevelSetImageFilter::SetNumberOfIterations(uint32_t NumberOfIterations)
*/
public  void setNumberOfIterations(long NumberOfIterations) {
    SimpleITKJNI.LaplacianSegmentationLevelSetImageFilter_setNumberOfIterations(swigCPtr, this, NumberOfIterations);
  }

  /**
uint32_t itk::simple::LaplacianSegmentationLevelSetImageFilter::GetNumberOfIterations() const
*/
public  long getNumberOfIterations() {
    return SimpleITKJNI.LaplacianSegmentationLevelSetImageFilter_getNumberOfIterations(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::LaplacianSegmentationLevelSetImageFilter::SetReverseExpansionDirection(bool ReverseExpansionDirection)
*/
public  void setReverseExpansionDirection(boolean ReverseExpansionDirection) {
    SimpleITKJNI.LaplacianSegmentationLevelSetImageFilter_setReverseExpansionDirection(swigCPtr, this, ReverseExpansionDirection);
  }

  /**
Self&amp; itk::simple::LaplacianSegmentationLevelSetImageFilter::ReverseExpansionDirectionOn()

Set the value of ReverseExpansionDirection to true or false
respectfully.

*/
public  void reverseExpansionDirectionOn() {
    SimpleITKJNI.LaplacianSegmentationLevelSetImageFilter_reverseExpansionDirectionOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::LaplacianSegmentationLevelSetImageFilter::ReverseExpansionDirectionOff()
*/
public  void reverseExpansionDirectionOff() {
    SimpleITKJNI.LaplacianSegmentationLevelSetImageFilter_reverseExpansionDirectionOff(swigCPtr, this);
  }

  /**
bool itk::simple::LaplacianSegmentationLevelSetImageFilter::GetReverseExpansionDirection() const
*/
public  boolean getReverseExpansionDirection() {
    return SimpleITKJNI.LaplacianSegmentationLevelSetImageFilter_getReverseExpansionDirection(swigCPtr, this);
  }

  /**
uint32_t itk::simple::LaplacianSegmentationLevelSetImageFilter::GetElapsedIterations() const

Number of iterations run.


This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public  long getElapsedIterations() {
    return SimpleITKJNI.LaplacianSegmentationLevelSetImageFilter_getElapsedIterations(swigCPtr, this);
  }

  /**
double itk::simple::LaplacianSegmentationLevelSetImageFilter::GetRMSChange() const

The Root Mean Square of the levelset upon termination.


This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public  double getRMSChange() {
    return SimpleITKJNI.LaplacianSegmentationLevelSetImageFilter_getRMSChange(swigCPtr, this);
  }

  /**
std::string itk::simple::LaplacianSegmentationLevelSetImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.LaplacianSegmentationLevelSetImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::LaplacianSegmentationLevelSetImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.LaplacianSegmentationLevelSetImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::LaplacianSegmentationLevelSetImageFilter::Execute(Image &amp;&amp;initialImage, const Image &amp;featureImage)

Execute the filter on the input image

*/
public  Image execute(Image initialImage, Image featureImage) {
    return new Image(SimpleITKJNI.LaplacianSegmentationLevelSetImageFilter_execute(swigCPtr, this, Image.getCPtr(initialImage), initialImage, Image.getCPtr(featureImage), featureImage), true);
  }

}
