/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.OptionalDouble;
import kafka.network.ConnectionQuotas;
import kafka.server.ClientQuotaManager;
import kafka.server.QuotaFactory;
import kafka.server.metadata.ClientIdEntity;
import kafka.server.metadata.ClientQuotaMetadataManager$;
import kafka.server.metadata.DefaultClientIdEntity$;
import kafka.server.metadata.DefaultIpEntity$;
import kafka.server.metadata.DefaultUserDefaultClientIdEntity$;
import kafka.server.metadata.DefaultUserEntity$;
import kafka.server.metadata.DefaultUserExplicitClientIdEntity;
import kafka.server.metadata.ExplicitUserDefaultClientIdEntity;
import kafka.server.metadata.ExplicitUserExplicitClientIdEntity;
import kafka.server.metadata.IpEntity;
import kafka.server.metadata.QuotaEntity;
import kafka.server.metadata.UserEntity;
import kafka.utils.Logging;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.image.ClientQuotaDelta;
import org.apache.kafka.image.ClientQuotasDelta;
import org.apache.kafka.server.quota.ClientQuotaEntity;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005Mc\u0001\u0002\b\u0010\u0001YA\u0011b\t\u0001\u0003\u0006\u0004%\ta\u0004\u0013\t\u0011M\u0002!\u0011!Q\u0001\n\u0015B\u0011\u0002\u000e\u0001\u0003\u0006\u0004%\taD\u001b\t\u0011q\u0002!\u0011!Q\u0001\nYBQ!\u0010\u0001\u0005\u0002yBQa\u0011\u0001\u0005\u0002\u0011CQa\u0011\u0001\u0005\nUCa!\u001a\u0001\u0005\u0002=1\u0007\"B7\u0001\t\u0013qwaBA\u0004\u001f!\u0005\u0011\u0011\u0002\u0004\u0007\u001d=A\t!a\u0003\t\ruZA\u0011AA\u0007\u0011\u001d\tya\u0003C\u0001\u0003#\u0011!d\u00117jK:$\u0018+^8uC6+G/\u00193bi\u0006l\u0015M\\1hKJT!\u0001E\t\u0002\u00115,G/\u00193bi\u0006T!AE\n\u0002\rM,'O^3s\u0015\u0005!\u0012!B6bM.\f7\u0001A\n\u0004\u0001]i\u0002C\u0001\r\u001c\u001b\u0005I\"\"\u0001\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005qI\"AB!osJ+g\r\u0005\u0002\u001fC5\tqD\u0003\u0002!'\u0005)Q\u000f^5mg&\u0011!e\b\u0002\b\u0019><w-\u001b8h\u00035\tXo\u001c;b\u001b\u0006t\u0017mZ3sgV\tQ\u0005\u0005\u0002'a9\u0011qE\f\b\u0003Q5r!!\u000b\u0017\u000e\u0003)R!aK\u000b\u0002\rq\u0012xn\u001c;?\u0013\u0005!\u0012B\u0001\n\u0014\u0013\ty\u0013#\u0001\u0007Rk>$\u0018MR1di>\u0014\u00180\u0003\u00022e\ti\u0011+^8uC6\u000bg.Y4feNT!aL\t\u0002\u001dE,x\u000e^1NC:\fw-\u001a:tA\u0005\u00012m\u001c8oK\u000e$\u0018n\u001c8Rk>$\u0018m]\u000b\u0002mA\u0011qGO\u0007\u0002q)\u0011\u0011hE\u0001\b]\u0016$xo\u001c:l\u0013\tY\u0004H\u0001\tD_:tWm\u0019;j_:\fVo\u001c;bg\u0006\t2m\u001c8oK\u000e$\u0018n\u001c8Rk>$\u0018m\u001d\u0011\u0002\rqJg.\u001b;?)\ry\u0014I\u0011\t\u0003\u0001\u0002i\u0011a\u0004\u0005\u0006G\u0015\u0001\r!\n\u0005\u0006i\u0015\u0001\rAN\u0001\u0007kB$\u0017\r^3\u0015\u0005\u0015C\u0005C\u0001\rG\u0013\t9\u0015D\u0001\u0003V]&$\b\"B%\u0007\u0001\u0004Q\u0015aC9v_R\f7\u000fR3mi\u0006\u0004\"aS*\u000e\u00031S!!\u0014(\u0002\u000b%l\u0017mZ3\u000b\u0005Qy%B\u0001)R\u0003\u0019\t\u0007/Y2iK*\t!+A\u0002pe\u001eL!\u0001\u0016'\u0003#\rc\u0017.\u001a8u#V|G/Y:EK2$\u0018\rF\u0002F-\u0002DQaV\u0004A\u0002a\u000ba!\u001a8uSRL\bCA-_\u001b\u0005Q&BA.]\u0003\u0015\tXo\u001c;b\u0015\tif*\u0001\u0004d_6lwN\\\u0005\u0003?j\u0013\u0011c\u00117jK:$\u0018+^8uC\u0016sG/\u001b;z\u0011\u0015\tw\u00011\u0001c\u0003)\tXo\u001c;b\t\u0016dG/\u0019\t\u0003\u0017\u000eL!\u0001\u001a'\u0003!\rc\u0017.\u001a8u#V|G/\u0019#fYR\f\u0017!\u00045b]\u0012dW-\u00139Rk>$\u0018\rF\u0002FO2DQ\u0001\u001b\u0005A\u0002%\f\u0001\"\u001b9F]RLG/\u001f\t\u0003\u0001*L!a[\b\u0003\u0017E+x\u000e^1F]RLG/\u001f\u0005\u0006C\"\u0001\rAY\u0001\u001cQ\u0006tG\r\\3Vg\u0016\u00148\t\\5f]R\fVo\u001c;b\u0007\"\fgnZ3\u0015\t\u0015{\u0017o\u001f\u0005\u0006a&\u0001\r![\u0001\fcV|G/Y#oi&$\u0018\u0010C\u0003s\u0013\u0001\u00071/A\u0002lKf\u0004\"\u0001\u001e=\u000f\u0005U4\bCA\u0015\u001a\u0013\t9\u0018$\u0001\u0004Qe\u0016$WMZ\u0005\u0003sj\u0014aa\u0015;sS:<'BA<\u001a\u0011\u0015a\u0018\u00021\u0001~\u0003!qWm\u001e,bYV,\u0007\u0003\u0002\r\u007f\u0003\u0003I!a`\r\u0003\r=\u0003H/[8o!\rA\u00121A\u0005\u0004\u0003\u000bI\"A\u0002#pk\ndW-\u0001\u000eDY&,g\u000e^)v_R\fW*\u001a;bI\u0006$\u0018-T1oC\u001e,'\u000f\u0005\u0002A\u0017M\u00111b\u0006\u000b\u0003\u0003\u0013\t1\u0004\u001e:b]N4WM\u001d+p\u00072LWM\u001c;Rk>$\u0018-\u00128uSRLH\u0003BA\n\u0003#\u0002r\u0001GA\u000b\u00033\tI#C\u0002\u0002\u0018e\u0011a\u0001V;qY\u0016\u0014\u0004\u0003\u0002\r\u007f\u00037\u0001B!!\b\u0002$9\u0019q%a\b\n\u0007\u0005\u0005\u0012#\u0001\nDY&,g\u000e^)v_R\fW*\u00198bO\u0016\u0014\u0018\u0002BA\u0013\u0003O\u0011aBQ1tKV\u001bXM]#oi&$\u0018PC\u0002\u0002\"E\u0001B\u0001\u0007@\u0002,A!\u0011QFA&\u001d\u0011\ty#!\u0012\u000f\t\u0005E\u0012\u0011\t\b\u0005\u0003g\tyD\u0004\u0003\u00026\u0005ub\u0002BA\u001c\u0003wq1!KA\u001d\u0013\u0005\u0011\u0016B\u0001)R\u0013\t!r*\u0003\u0002\u0013\u001d&\u00191,a\u0011\u000b\u0005Iq\u0015\u0002BA$\u0003\u0013\n\u0011c\u00117jK:$\u0018+^8uC\u0016sG/\u001b;z\u0015\rY\u00161I\u0005\u0005\u0003\u001b\nyE\u0001\u0007D_:4\u0017nZ#oi&$\u0018P\u0003\u0003\u0002H\u0005%\u0003\"\u00029\u000e\u0001\u0004I\u0007")
public class ClientQuotaMetadataManager
implements Logging {
    private final QuotaFactory.QuotaManagers quotaManagers;
    private final ConnectionQuotas connectionQuotas;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Tuple2<Option<ClientQuotaManager.BaseUserEntity>, Option<ClientQuotaEntity.ConfigEntity>> transferToClientQuotaEntity(QuotaEntity quotaEntity) {
        return ClientQuotaMetadataManager$.MODULE$.transferToClientQuotaEntity(quotaEntity);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public QuotaFactory.QuotaManagers quotaManagers() {
        return this.quotaManagers;
    }

    public ConnectionQuotas connectionQuotas() {
        return this.connectionQuotas;
    }

    public void update(ClientQuotasDelta quotasDelta) {
        quotasDelta.changes().forEach((key, value) -> this.update((ClientQuotaEntity)key, (ClientQuotaDelta)value));
    }

    private void update(ClientQuotaEntity entity, ClientQuotaDelta quotaDelta) {
        if (entity.entries().containsKey("ip")) {
            Product product;
            Option option = Option$.MODULE$.apply(entity.entries().get("ip"));
            if (option instanceof Some) {
                String ip = (String)((Some)option).value();
                product = new IpEntity(ip);
            } else if (None$.MODULE$.equals(option)) {
                product = DefaultIpEntity$.MODULE$;
            } else {
                throw new MatchError((Object)option);
            }
            Product ipEntity = product;
            this.handleIpQuota((QuotaEntity)ipEntity, quotaDelta);
            return;
        }
        if (entity.entries().containsKey("user") || entity.entries().containsKey("client-id")) {
            String userVal = (String)entity.entries().get("user");
            String clientIdVal = (String)entity.entries().get("client-id");
            Product userClientEntity = entity.entries().containsKey("user") && entity.entries().containsKey("client-id") ? (userVal == null && clientIdVal == null ? DefaultUserDefaultClientIdEntity$.MODULE$ : (userVal == null ? new DefaultUserExplicitClientIdEntity(clientIdVal) : (clientIdVal == null ? new ExplicitUserDefaultClientIdEntity(userVal) : new ExplicitUserExplicitClientIdEntity(userVal, clientIdVal)))) : (entity.entries().containsKey("user") ? (userVal == null ? DefaultUserEntity$.MODULE$ : new UserEntity(userVal)) : (clientIdVal == null ? DefaultClientIdEntity$.MODULE$ : new ClientIdEntity(clientIdVal)));
            quotaDelta.changes().forEach((key, value) -> this.handleUserClientQuotaChange((QuotaEntity)userClientEntity, (String)key, (Option<Object>)OptionConverters.RichOptionalDouble$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptionalDouble(value))));
            return;
        }
        this.warn((Function0<String>)(Function0 & Serializable)() -> "Ignoring unsupported quota entity " + entity + ".");
    }

    public void handleIpQuota(QuotaEntity ipEntity, ClientQuotaDelta quotaDelta) {
        None$ none$;
        if (ipEntity instanceof IpEntity) {
            String ip = ((IpEntity)ipEntity).ip();
            try {
                none$ = new Some((Object)InetAddress.getByName(ip));
            }
            catch (UnknownHostException unknownHostException) {
                throw new IllegalArgumentException("Unable to resolve address " + ip);
            }
        } else if (DefaultIpEntity$.MODULE$.equals(ipEntity)) {
            none$ = None$.MODULE$;
        } else {
            throw new IllegalStateException("Should only handle IP quota entities here");
        }
        None$ inetAddress = none$;
        quotaDelta.changes().forEach((arg_0, arg_1) -> ClientQuotaMetadataManager.$anonfun$handleIpQuota$1(this, ipEntity, (Option)inetAddress, arg_0, arg_1));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleUserClientQuotaChange(QuotaEntity quotaEntity, String key, Option<Object> newValue) {
        ClientQuotaManager clientQuotaManager;
        block9: {
            switch (key == null ? 0 : key.hashCode()) {
                case -1805480786: {
                    if (!"consumer_byte_rate".equals(key)) break;
                    clientQuotaManager = this.quotaManagers().fetch();
                    break block9;
                }
                case -965904822: {
                    if (!"request_percentage".equals(key)) break;
                    clientQuotaManager = this.quotaManagers().request();
                    break block9;
                }
                case -832502454: {
                    if (!"producer_byte_rate".equals(key)) break;
                    clientQuotaManager = this.quotaManagers().produce();
                    break block9;
                }
                case -748852909: {
                    if (!"controller_mutation_rate".equals(key)) break;
                    clientQuotaManager = this.quotaManagers().controllerMutation();
                    break block9;
                }
            }
            this.warn((Function0<String>)(Function0 & Serializable)() -> "Ignoring unexpected quota key " + key + " for entity " + quotaEntity);
            return;
        }
        ClientQuotaManager manager = clientQuotaManager;
        Tuple2<Option<ClientQuotaManager.BaseUserEntity>, Option<ClientQuotaEntity.ConfigEntity>> tuple2 = ClientQuotaMetadataManager$.MODULE$.transferToClientQuotaEntity(quotaEntity);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option userEntity = (Option)tuple2._1();
        Option clientEntity = (Option)tuple2._2();
        Option quotaValue = newValue.map((Function1 & Serializable)x$3 -> ClientQuotaMetadataManager.$anonfun$handleUserClientQuotaChange$2(BoxesRunTime.unboxToDouble((Object)x$3)));
        try {
            void var7_7;
            void var6_6;
            manager.updateQuota((Option<ClientQuotaManager.BaseUserEntity>)var6_6, (Option<ClientQuotaEntity.ConfigEntity>)var7_7, (Option<Quota>)quotaValue);
            return;
        }
        catch (Throwable t) {
            this.error((Function0<String>)(Function0 & Serializable)() -> "Failed to update user-client quota " + quotaEntity, (Function0<Throwable>)(Function0 & Serializable)() -> t);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$handleIpQuota$1(ClientQuotaMetadataManager $this, QuotaEntity ipEntity$1, Option inetAddress$1, String key, OptionalDouble value) {
        if (!key.equals("connection_creation_rate")) {
            $this.warn((Function0<String>)(Function0 & Serializable)() -> "Ignoring unexpected quota key " + key + " for entity " + ipEntity$1);
            return;
        }
        try {
            $this.connectionQuotas().updateIpConnectionRateQuota((Option<InetAddress>)inetAddress$1, (Option<Object>)OptionConverters.RichOptionalDouble$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptionalDouble(value)).map((Function1)(JFunction1.mcID.sp & Serializable)x$1 -> (int)x$1));
            return;
        }
        catch (Throwable t) {
            $this.error((Function0<String>)(Function0 & Serializable)() -> "Failed to update IP quota " + ipEntity$1, (Function0<Throwable>)(Function0 & Serializable)() -> t);
            return;
        }
    }

    public static final /* synthetic */ Quota $anonfun$handleUserClientQuotaChange$2(double x$3) {
        return new Quota(x$3, true);
    }

    public ClientQuotaMetadataManager(QuotaFactory.QuotaManagers quotaManagers, ConnectionQuotas connectionQuotas) {
        this.quotaManagers = quotaManagers;
        this.connectionQuotas = connectionQuotas;
    }
}

