/*
 * Decompiled with CFR 0.152.
 */
package liquibase.util;

import java.util.concurrent.Callable;
import lombok.Generated;

public class Cache<T> {
    private transient Object lock = new Object();
    private volatile transient T value;
    private final Callable<T> generator;
    private boolean generated = false;
    private boolean exceptionIsPermitted = false;
    private Exception exception;
    private volatile transient long timeToLiveMillis;
    private long lastGeneratedTime;

    public Cache(Callable<T> generator) {
        this(generator, false);
    }

    public Cache(Callable<T> generator, boolean exceptionIsPermitted) {
        this(generator, exceptionIsPermitted, 0L);
    }

    public Cache(Callable<T> generator, boolean exceptionIsPermitted, long timeToLiveMillis) {
        this.generator = generator;
        this.exceptionIsPermitted = exceptionIsPermitted;
        this.timeToLiveMillis = timeToLiveMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get() throws Exception {
        if (!this.generated || this.isExpired()) {
            Object object = this.lock;
            synchronized (object) {
                try {
                    this.value = this.generator.call();
                    this.lastGeneratedTime = System.currentTimeMillis();
                    this.exception = null;
                }
                catch (Exception e) {
                    if (this.exceptionIsPermitted) {
                        this.exception = e;
                        this.generated = true;
                    }
                    throw e;
                }
                this.generated = true;
            }
        }
        if (this.exception != null) {
            throw this.exception;
        }
        return this.value;
    }

    public void clearCache() {
        this.generated = false;
        this.lastGeneratedTime = 0L;
        this.exception = null;
    }

    private boolean isExpired() {
        return this.timeToLiveMillis > 0L && System.currentTimeMillis() - this.lastGeneratedTime > this.timeToLiveMillis;
    }

    @Generated
    public boolean isGenerated() {
        return this.generated;
    }
}

