/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.keys.loader;

import org.jboss.logging.Logger;
import org.keycloak.broker.jwtauthorizationgrant.JWTAuthorizationGrantConfig;
import org.keycloak.crypto.PublicKeysWrapper;
import org.keycloak.jose.jwk.JSONWebKeySet;
import org.keycloak.jose.jwk.JWK;
import org.keycloak.keys.PublicKeyLoader;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oidc.utils.JWKSHttpUtils;
import org.keycloak.util.JWKSUtils;
import org.keycloak.util.JsonSerialization;
import org.keycloak.utils.StringUtil;

public class OIDCIdentityProviderPublicKeyLoader
implements PublicKeyLoader {
    private static final Logger logger = Logger.getLogger(OIDCIdentityProviderPublicKeyLoader.class);
    private final KeycloakSession session;
    private final JWTAuthorizationGrantConfig config;

    public OIDCIdentityProviderPublicKeyLoader(KeycloakSession session, JWTAuthorizationGrantConfig config) {
        this.session = session;
        this.config = config;
    }

    public PublicKeysWrapper loadKeys() throws Exception {
        if (this.config.isUseJwksUrl()) {
            String jwksUrl = this.config.getJwksUrl();
            JSONWebKeySet jwks = JWKSHttpUtils.sendJwksRequest(this.session, jwksUrl);
            return JWKSUtils.getKeyWrappersForUse((JSONWebKeySet)jwks, (JWK.Use)JWK.Use.SIG, (boolean)true);
        }
        String publicKeySignatureVerifier = this.config.getPublicKeySignatureVerifier();
        if (StringUtil.isBlank((String)publicKeySignatureVerifier)) {
            return PublicKeysWrapper.EMPTY;
        }
        try {
            JSONWebKeySet jwks = (JSONWebKeySet)JsonSerialization.readValue((String)publicKeySignatureVerifier, JSONWebKeySet.class);
            return JWKSUtils.getKeyWrappersForUse((JSONWebKeySet)jwks, (JWK.Use)JWK.Use.SIG);
        }
        catch (Exception e) {
            logger.warnf((Throwable)e, "Unable to retrieve publicKey for verify signature of identityProvider '%s'.", (Object)this.config.getAlias());
            return PublicKeysWrapper.EMPTY;
        }
    }
}

