/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.netbeans.modules.maven.embedder.ArtifactFixer;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.queries.MavenFileOwnerQueryImpl;
import org.openide.util.Exceptions;

public class NbArtifactFixer
implements ArtifactFixer {
    private static final Logger LOG = Logger.getLogger(NbArtifactFixer.class.getName());
    private final ThreadLocal<Set<String>> gav = new ThreadLocal();
    public static final String FALLBACK_NAME = "F@LLB@CK";
    private static Map<String, File> fallbackPOMs = new HashMap<String, File>();
    private static final ThreadLocal<Set<Artifact>> CAPTURE_PLACEHOLDER_ARTIFACTS = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File resolve(Artifact artifact) {
        ArtifactRepository local;
        block20: {
            String id;
            Set<String> gavSet;
            if (!artifact.getExtension().equals("pom")) {
                return null;
            }
            if (!artifact.getClassifier().isEmpty()) {
                return null;
            }
            local = EmbedderFactory.getProjectEmbedder().getLocalRepository();
            if (local.getLayout() != null) {
                boolean isSnapshot = artifact.isSnapshot();
                org.apache.maven.artifact.DefaultArtifact art = new org.apache.maven.artifact.DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), null, artifact.getExtension(), artifact.getClassifier(), (ArtifactHandler)new DefaultArtifactHandler(artifact.getExtension()));
                if (isSnapshot) {
                    art.setBaseVersion(artifact.getBaseVersion());
                }
                String path = local.pathOf((org.apache.maven.artifact.Artifact)art);
                if (new File(local.getBasedir(), path).exists()) {
                    return null;
                }
            }
            if ((gavSet = this.gav.get()) == null) {
                gavSet = new HashSet<String>();
                this.gav.set(gavSet);
            }
            if (!gavSet.contains(id = artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion())) {
                try {
                    gavSet.add(id);
                    File pom = MavenFileOwnerQueryImpl.getInstance().getOwnerPOM(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
                    if (pom != null) {
                        artifact.setFile(pom);
                        File file = pom;
                        return file;
                    }
                    break block20;
                }
                finally {
                    gavSet.remove(id);
                    if (gavSet.isEmpty()) {
                        this.gav.remove();
                    }
                }
            }
            LOG.log(Level.INFO, "Cycle in NbArtifactFixer resolution (issue #234586): {0}", Arrays.toString(gavSet.toArray()));
        }
        try {
            File f = NbArtifactFixer.createFallbackPOM(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
            artifact.setFile(f);
            Set<Artifact> s = CAPTURE_PLACEHOLDER_ARTIFACTS.get();
            if (s != null) {
                String c = artifact.getProperty("nbResolvingArtifact.classifier", null);
                String e = artifact.getProperty("nbResolvingArtifact.extension", null);
                if ("".equals(c)) {
                    c = null;
                }
                if (c == null && e == null || Objects.equals(c, artifact.getClassifier()) && Objects.equals(e, artifact.getExtension())) {
                    s.add(artifact);
                } else if (local.getLayout() != null) {
                    boolean isSnapshot = artifact.isSnapshot();
                    org.apache.maven.artifact.DefaultArtifact art = new org.apache.maven.artifact.DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), null, e, c, (ArtifactHandler)new DefaultArtifactHandler(e));
                    if (isSnapshot) {
                        art.setBaseVersion(artifact.getBaseVersion());
                    }
                    String path = local.pathOf((org.apache.maven.artifact.Artifact)art);
                    File af = new File(local.getBasedir(), path);
                    art.setFile(af);
                    DefaultArtifact da = new DefaultArtifact(art.getGroupId(), art.getArtifactId(), art.getClassifier(), art.getType(), art.getVersion(), artifact.getProperties(), af);
                    s.add((Artifact)da);
                }
            }
            return f;
        }
        catch (IOException x) {
            Exceptions.printStackTrace((Throwable)x);
            return null;
        }
    }

    public static boolean isFallbackFile(File file) {
        return file.getName().startsWith("fallback") && file.getName().endsWith("netbeans.pom");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized File createFallbackPOM(String groupId, String artifactId, String version) throws IOException {
        String k = groupId + ":" + artifactId + ":" + version;
        File fallbackPOM = fallbackPOMs.get(k);
        if (fallbackPOM == null) {
            fallbackPOM = Files.createTempFile("fallback", ".netbeans.pom", new FileAttribute[0]).toFile();
            fallbackPOM.deleteOnExit();
            try (PrintWriter w = new PrintWriter(fallbackPOM);){
                w.println("<project>");
                w.println("<modelVersion>4.0.0</modelVersion>");
                w.println("<groupId>" + groupId + "</groupId>");
                w.println("<artifactId>" + artifactId + "</artifactId>");
                w.println("<packaging>pom</packaging>");
                w.println("<version>" + version + "</version>");
                w.println("<name>F@LLB@CK</name>");
                w.println("</project>");
                w.flush();
            }
            fallbackPOMs.put(k, fallbackPOM);
        }
        return fallbackPOM;
    }

    private static <T extends Throwable> void sneakyThrow(Throwable exception) throws T {
        throw exception;
    }

    public static <T, E extends Throwable> T collectPlaceholderArtifacts(ExceptionCallable<T, E> code, Consumer<Set<Artifact>> collector) throws E {
        Set<Artifact> save = CAPTURE_PLACEHOLDER_ARTIFACTS.get();
        try {
            CAPTURE_PLACEHOLDER_ARTIFACTS.set(new HashSet());
            T t = code.call();
            return t;
        }
        catch (Error | RuntimeException r) {
            throw r;
        }
        catch (Exception ex) {
            NbArtifactFixer.sneakyThrow(ex);
            throw new Error();
        }
        finally {
            if (collector != null) {
                collector.accept(CAPTURE_PLACEHOLDER_ARTIFACTS.get());
            }
            CAPTURE_PLACEHOLDER_ARTIFACTS.set(save);
        }
    }

    public static interface ExceptionCallable<T, E extends Throwable> {
        public T call() throws E;
    }
}

