/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.configurations;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.maven.model.Profile;
import org.apache.maven.project.MavenProject;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.ProjectProfileHandler;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.embedder.MavenEmbedder;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.openide.util.NbCollections;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ProjectProfileHandlerImpl
implements ProjectProfileHandler {
    private static final String PROFILES = "profiles";
    private static final String ACTIVEPROFILES = "activeProfiles";
    private static final String SEPARATOR = " ";
    private static final String NAMESPACE = null;
    private final List<String> privateProfiles = new ArrayList<String>();
    private final List<String> sharedProfiles = new ArrayList<String>();
    private final AtomicBoolean lazyProfilesSet = new AtomicBoolean(false);
    private final AuxiliaryConfiguration ac;
    private final NbMavenProjectImpl nmp;

    public ProjectProfileHandlerImpl(NbMavenProjectImpl nmp, AuxiliaryConfiguration ac) {
        this.nmp = nmp;
        this.ac = ac;
    }

    private void lazyInit() {
        if (this.lazyProfilesSet.compareAndSet(false, true)) {
            this.privateProfiles.addAll(this.retrieveActiveProfiles(this.ac, false));
            this.sharedProfiles.addAll(this.retrieveActiveProfiles(this.ac, true));
        }
    }

    @Override
    public List<String> getAllProfiles() {
        this.lazyInit();
        HashSet<String> profileIds = new HashSet<String>();
        this.extractProfiles(profileIds);
        profileIds.addAll(NbCollections.checkedMapByFilter((Map)EmbedderFactory.getProjectEmbedder().getSettings().getProfilesAsMap(), String.class, org.apache.maven.settings.Profile.class, (boolean)true).keySet());
        return new ArrayList<String>(profileIds);
    }

    @Override
    public List<String> getActiveProfiles(boolean shared) {
        this.lazyInit();
        return new ArrayList<String>(shared ? this.sharedProfiles : this.privateProfiles);
    }

    @Override
    public List<String> getMergedActiveProfiles(boolean shared) {
        this.lazyInit();
        HashSet<String> profileIds = new HashSet<String>();
        MavenProject mavenProject = this.nmp.getOriginalMavenProject();
        List profiles = mavenProject.getActiveProfiles();
        for (Profile profile : profiles) {
            profileIds.add(profile.getId());
        }
        List profileStrings = EmbedderFactory.getProjectEmbedder().getSettings().getActiveProfiles();
        for (String profile : profileStrings) {
            profileIds.add(profile);
        }
        profileIds.addAll(this.getActiveProfiles(shared));
        return new ArrayList<String>(profileIds);
    }

    @Override
    public void disableProfile(String id, boolean shared) {
        String activeProfiles;
        this.lazyInit();
        Element element = this.ac.getConfigurationFragment(PROFILES, NAMESPACE, shared);
        if (element == null) {
            String root = "project-private";
            Document doc = XMLUtil.createDocument((String)root, (String)NAMESPACE, null, null);
            element = doc.createElementNS(NAMESPACE, PROFILES);
        }
        if ((activeProfiles = element.getAttributeNS(NAMESPACE, ACTIVEPROFILES)) != null && activeProfiles.length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(activeProfiles, SEPARATOR);
            HashSet<String> set = new HashSet<String>(tokenizer.countTokens());
            while (tokenizer.hasMoreTokens()) {
                set.add(tokenizer.nextToken());
            }
            set.remove(id);
            StringBuilder buffer = new StringBuilder();
            for (String profle : set) {
                buffer.append(profle).append(SEPARATOR);
            }
            element.setAttributeNS(NAMESPACE, ACTIVEPROFILES, buffer.toString().trim());
        }
        this.ac.putConfigurationFragment(element, shared);
        if (shared) {
            this.sharedProfiles.remove(id);
        } else {
            this.privateProfiles.remove(id);
        }
    }

    @Override
    public void enableProfile(String id, boolean shared) {
        this.lazyInit();
        Element element = this.ac.getConfigurationFragment(PROFILES, NAMESPACE, shared);
        if (element == null) {
            String root = "project-private";
            Document doc = XMLUtil.createDocument((String)root, (String)NAMESPACE, null, null);
            element = doc.createElementNS(NAMESPACE, PROFILES);
        }
        String activeProfiles = element.getAttributeNS(NAMESPACE, ACTIVEPROFILES);
        element.setAttributeNS(NAMESPACE, ACTIVEPROFILES, activeProfiles + SEPARATOR + id);
        this.ac.putConfigurationFragment(element, shared);
        if (shared) {
            if (!this.sharedProfiles.contains(id)) {
                this.sharedProfiles.add(id);
            }
        } else if (!this.privateProfiles.contains(id)) {
            this.privateProfiles.add(id);
        }
    }

    private void extractProfiles(Set<String> profileIds) {
        Set mod = MavenEmbedder.getAllProjectProfiles((MavenProject)this.nmp.getOriginalMavenProject());
        if (mod != null) {
            profileIds.addAll(mod);
        }
    }

    private List<String> retrieveActiveProfiles(AuxiliaryConfiguration ac, boolean shared) {
        String activeProfiles;
        HashSet<String> prifileides = new HashSet<String>();
        Element element = ac.getConfigurationFragment(PROFILES, NAMESPACE, shared);
        if (element != null && (activeProfiles = element.getAttributeNS(NAMESPACE, ACTIVEPROFILES)) != null && activeProfiles.length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(activeProfiles, SEPARATOR);
            while (tokenizer.hasMoreTokens()) {
                prifileides.add(tokenizer.nextToken());
            }
        }
        return new ArrayList<String>(prifileides);
    }
}

