/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.output;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.ModelUtils;
import org.netbeans.modules.maven.api.output.OutputProcessor;
import org.netbeans.modules.maven.api.output.OutputVisitor;
import org.netbeans.modules.maven.output.Bundle;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;

public class DependencyAnalyzeOutputProcessor
implements OutputProcessor {
    private static final String[] DEPGOALS = new String[]{"mojo-execute#dependency:analyze"};
    private final Pattern start = Pattern.compile(".*Used undeclared dependencies.*", 32);
    private boolean started = false;
    private final Pattern dependency = Pattern.compile("\\s*(?:\\[WARNING|WARN\\])?\\s*(.*):(.*):(.*):(.*):(.*)", 32);
    private final Project project;

    DependencyAnalyzeOutputProcessor(Project project) {
        this.project = project;
    }

    @Override
    public String[] getRegisteredOutputSequences() {
        return DEPGOALS;
    }

    @Override
    public void processLine(String line, OutputVisitor visitor) {
        Matcher match;
        if (this.started) {
            match = this.dependency.matcher(line);
            if (match.matches() && match.groupCount() >= 5) {
                String gr = match.group(1);
                String ar = match.group(2);
                String type = match.group(3);
                String ver = match.group(4);
                String sc = match.group(5);
                visitor.setLine(line + " (Click to add to pom.xml)");
                OutputVisitor.Context context = visitor.getContext();
                Project prj = this.project;
                if (context != null && context.getCurrentProject() != null) {
                    prj = context.getCurrentProject();
                }
                visitor.setOutputListener(new Listener(prj, gr, ar, type, ver, sc), false);
            } else {
                this.started = false;
            }
        }
        if (!this.started && (match = this.start.matcher(line)).matches()) {
            this.started = true;
        }
    }

    @Override
    public void sequenceStart(String sequenceId, OutputVisitor visitor) {
        this.started = false;
    }

    @Override
    public void sequenceEnd(String sequenceId, OutputVisitor visitor) {
    }

    @Override
    public void sequenceFail(String sequenceId, OutputVisitor visitor) {
    }

    private static class Listener
    implements OutputListener {
        private final String group;
        private final String scope;
        private final String version;
        private final String type;
        private final String artifact;
        private final Project project;

        private Listener(Project prj, String gr, String ar, String type, String ver, String sc) {
            this.group = gr;
            this.artifact = ar;
            this.type = type;
            this.version = ver;
            this.scope = sc;
            this.project = prj;
        }

        public void outputLineAction(OutputEvent arg0) {
            ModelUtils.addDependency(this.project.getProjectDirectory().getFileObject("pom.xml"), this.group, this.artifact, this.version, this.type, this.scope, null, false);
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)Bundle.MSG_Dependency(this.group + ":" + this.artifact));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
        }
    }
}

