/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.hcl.terraform;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.languages.hcl.HCLParserResult;
import org.netbeans.modules.languages.hcl.SourceRef;
import org.netbeans.modules.languages.hcl.ast.HCLAttribute;
import org.netbeans.modules.languages.hcl.ast.HCLBlock;
import org.netbeans.modules.languages.hcl.ast.HCLContainer;
import org.netbeans.modules.languages.hcl.ast.HCLDocument;
import org.netbeans.modules.languages.hcl.ast.HCLElement;
import org.netbeans.modules.languages.hcl.ast.HCLIdentifier;
import org.netbeans.modules.languages.hcl.ast.HCLTreeWalker;
import org.netbeans.modules.languages.hcl.terraform.Bundle;
import org.netbeans.modules.parsing.api.Snapshot;

public class TerraformParserResult
extends HCLParserResult {
    private final Map<String, HCLBlock> definedBlocks = new HashMap<String, HCLBlock>();

    public TerraformParserResult(Snapshot snapshot) {
        super(snapshot);
    }

    @Override
    protected void processDocument(HCLDocument doc, SourceRef references) {
        HCLTreeWalker.breadthFirst(doc, this::duplicateAttributeVisitor);
        HCLTreeWalker.breadthFirst(doc, this::checkBlockDeclarationVisitor);
    }

    private boolean checkBlockDeclarationVisitor(HCLTreeWalker.Step step) {
        HCLElement hCLElement = step.node();
        if (hCLElement instanceof HCLBlock) {
            HCLBlock block = (HCLBlock)hCLElement;
            List<HCLIdentifier> decl = block.declaration();
            HCLIdentifier type = decl.get(0);
            BlockType bt = BlockType.get(type.id());
            if (bt != null) {
                if (decl.size() != bt.definitionLength) {
                    this.addError(type, Bundle.INVALID_BLOCK_DECLARATION(bt.type, bt.definitionLength - 1));
                } else if (this.definedBlocks.put(block.id(), block) != null) {
                    switch (bt.ordinal()) {
                        case 0: 
                        case 1: 
                        case 4: 
                        case 6: 
                        case 9: 
                        case 10: 
                        case 12: {
                            this.addError(decl.get(bt.definitionLength - 1), Bundle.DUPLICATE_BLOCK(block.id()));
                        }
                    }
                }
            } else {
                this.addError(type, Bundle.UNKNOWN_BLOCK(type.id()));
            }
        }
        return false;
    }

    private boolean duplicateAttributeVisitor(HCLTreeWalker.Step step) {
        Object object = step.node();
        if (object instanceof HCLDocument) {
            HCLDocument doc = (HCLDocument)object;
            for (HCLAttribute attr : doc.attributes()) {
                this.addError(attr, Bundle.UNEXPECTED_DOCUMENT_ATTRIBUTE(attr.id()));
            }
            return true;
        }
        object = step.node();
        if (object instanceof HCLContainer) {
            HCLContainer c = (HCLContainer)object;
            if (c.hasAttribute()) {
                HashSet<String> defined = new HashSet<String>();
                for (HCLAttribute attr : c.attributes()) {
                    if (defined.add(attr.id())) continue;
                    this.addError(attr.name(), Bundle.DUPLICATE_ATTRIBUTE(attr.id()));
                }
            }
            return false;
        }
        return true;
    }

    public static enum BlockType {
        CHECK("check", 2),
        DATA("data", 3),
        IMPORT("import", 1),
        LOCALS("locals", 1),
        MODULE("module", 2),
        MOVED("moved", 1),
        OUTPUT("output", 2),
        PROVIDER("provider", 2),
        REMOVED("removed", 1),
        RESOURCE("resource", 3),
        RUN("run", 2),
        TERRAFORM("terraform", 1),
        VARIABLE("variable", 2);

        final String type;
        final int definitionLength;
        private static final Map<String, BlockType> TYPES;

        private BlockType(String type, int definitionLenght) {
            this.type = type;
            this.definitionLength = definitionLenght;
        }

        public static BlockType get(String name) {
            return TYPES.get(name);
        }

        static {
            TYPES = new HashMap<String, BlockType>();
            for (BlockType bt : BlockType.values()) {
                TYPES.put(bt.type, bt);
            }
        }
    }
}

