/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui;

import com.sun.jdi.AbsentInformationException;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.Field;
import org.netbeans.api.debugger.jpda.JPDAClassType;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.models.CallStackFrameImpl;
import org.netbeans.modules.debugger.jpda.ui.EditorContextBridge;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.jpda.EditorContext;
import org.netbeans.spi.debugger.jpda.SourcePathProvider;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class SourcePath {
    private ContextProvider contextProvider;
    private SourcePathProvider sourcePathProvider;
    private JPDADebugger debugger;

    public SourcePath(ContextProvider contextProvider) {
        this.contextProvider = contextProvider;
        this.debugger = (JPDADebugger)contextProvider.lookupFirst(null, JPDADebugger.class);
        this.getContext();
    }

    private SourcePathProvider getContext() {
        if (this.sourcePathProvider == null) {
            List l = this.contextProvider.lookup(null, SourcePathProvider.class);
            this.sourcePathProvider = (SourcePathProvider)l.get(0);
            int k = l.size();
            for (int i = 1; i < k; ++i) {
                this.sourcePathProvider = new CompoundContextProvider((SourcePathProvider)l.get(i), this.sourcePathProvider);
            }
        }
        return this.sourcePathProvider;
    }

    static SourcePathProvider getDefaultContext() {
        List providers = DebuggerManager.getDebuggerManager().lookup("netbeans-JPDASession", SourcePathProvider.class);
        for (Object provider : providers) {
            if (!provider.getClass().getName().equals("org.netbeans.modules.debugger.jpda.projects.SourcePathProviderImpl")) continue;
            return (SourcePathProvider)provider;
        }
        return null;
    }

    public String getRelativePath(String url, char directorySeparator, boolean includeExtension) {
        return this.getContext().getRelativePath(url, directorySeparator, includeExtension);
    }

    private String getURL(String relativePath, boolean global) {
        String url = this.getContext().getURL(relativePath, global);
        if (url != null) {
            try {
                new URL(url);
            }
            catch (MalformedURLException muex) {
                Logger.getLogger(SourcePath.class.getName()).log(Level.WARNING, "Malformed URL '" + url + "' produced by " + this.getContext(), muex);
                return null;
            }
        }
        return url;
    }

    public String[] getSourceRoots() {
        return this.getContext().getSourceRoots();
    }

    public String[] getOriginalSourceRoots() {
        return this.getContext().getOriginalSourceRoots();
    }

    public String[] getAdditionalSourceRoots() {
        try {
            Method getProjectSourceRootsMethod = this.getContext().getClass().getMethod("getAdditionalSourceRoots", new Class[0]);
            String[] projectSourceRoots = (String[])getProjectSourceRootsMethod.invoke((Object)this.getContext(), new Object[0]);
            return projectSourceRoots;
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return new String[0];
        }
    }

    public void setSourceRoots(String[] sourceRoots, String[] additionalRoots) {
        try {
            Method setSourceRootsMethod = this.getContext().getClass().getMethod("setSourceRoots", String[].class, String[].class);
            setSourceRootsMethod.invoke((Object)this.getContext(), sourceRoots, additionalRoots);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public void reorderOriginalSourceRoots(int[] permutation) {
        try {
            Method reorderOriginalSourceRootsMethod = this.getContext().getClass().getMethod("reorderOriginalSourceRoots", int[].class);
            reorderOriginalSourceRootsMethod.invoke((Object)this.getContext(), new Object[]{permutation});
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.getContext().addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.getContext().removePropertyChangeListener(l);
    }

    public boolean sourceAvailable(String relativePath, boolean global) {
        return this.getURL(relativePath, global) != null;
    }

    public boolean sourceAvailable(JPDAThread t, String stratumn, boolean global) {
        try {
            String url;
            CallStackFrame[] callStacks = t.getCallStack(0, 1);
            if (callStacks.length > 0 && (url = this.getClassURL(((CallStackFrameImpl)callStacks[0]).getClassType(), stratumn)) != null) {
                return true;
            }
        }
        catch (AbsentInformationException callStacks) {
            // empty catch block
        }
        try {
            return this.sourceAvailable(SourcePath.convertSlash(t.getSourcePath(stratumn)), global);
        }
        catch (AbsentInformationException e) {
            return this.sourceAvailable(SourcePath.convertClassNameToRelativePath(t.getClassName()), global);
        }
    }

    public boolean sourceAvailable(Field f) {
        String url;
        JPDAClassType declaringClass = f.getDeclaringClass();
        if (declaringClass != null && (url = this.getClassURL(declaringClass, null)) != null) {
            return true;
        }
        String className = f.getClassName();
        return this.sourceAvailable(className, true);
    }

    public boolean sourceAvailable(CallStackFrame csf, String stratumn) {
        String url = this.getClassURL(((CallStackFrameImpl)csf).getClassType(), stratumn);
        if (url != null) {
            return true;
        }
        try {
            return this.sourceAvailable(SourcePath.convertSlash(csf.getSourcePath(stratumn)), true);
        }
        catch (AbsentInformationException e) {
            return this.sourceAvailable(SourcePath.convertClassNameToRelativePath(csf.getClassName()), true);
        }
    }

    public String getURL(CallStackFrame csf, String stratumn) {
        return this.getURL(csf, stratumn, null);
    }

    public String getURL(CallStackFrame csf, String stratumn, String[] sourcePathPtr) {
        JPDAClassType classType = ((CallStackFrameImpl)csf).getClassType();
        String url = null;
        if (classType != null) {
            url = this.getClassURL(classType, stratumn);
        }
        if (url == null) {
            String sourcePath;
            try {
                sourcePath = SourcePath.convertSlash(csf.getSourcePath(stratumn));
                url = this.getURL(sourcePath, true);
                if (url == null) {
                    String ds = csf.getDefaultStratum();
                    sourcePath = SourcePath.convertSlash(csf.getSourcePath(ds));
                    url = this.getURL(sourcePath, true);
                }
            }
            catch (AbsentInformationException e) {
                sourcePath = SourcePath.convertClassNameToRelativePath(csf.getClassName());
                url = this.getURL(sourcePath, true);
            }
            if (sourcePathPtr != null) {
                sourcePathPtr[0] = sourcePath;
            }
        }
        return url;
    }

    public String getURL(JPDAThread t, String stratum) {
        return this.getURL(t, stratum, null);
    }

    private String getURL(JPDAThread t, String stratum, String[] sourcePathPtr) {
        String url;
        block5: {
            try {
                CallStackFrame[] callStacks = t.getCallStack(0, 1);
                if (callStacks.length > 0) {
                    url = this.getURL(callStacks[0], stratum, sourcePathPtr);
                } else {
                    String sourcePath = SourcePath.convertSlash(t.getSourcePath(stratum));
                    url = this.getURL(sourcePath, true);
                    if (sourcePathPtr != null) {
                        sourcePathPtr[0] = sourcePath;
                    }
                }
            }
            catch (AbsentInformationException e) {
                String sourcePath = SourcePath.convertClassNameToRelativePath(t.getClassName());
                url = this.getURL(sourcePath, true);
                if (sourcePathPtr == null) break block5;
                sourcePathPtr[0] = sourcePath;
            }
        }
        return url;
    }

    private String getClassURL(JPDAClassType clazz, String stratum) {
        block8: {
            SourcePathProvider context = this.getContext();
            try {
                String url = (String)context.getClass().getMethod("getURL", JPDAClassType.class, String.class).invoke((Object)context, clazz, stratum);
                if (url == null) break block8;
                try {
                    new URL(url);
                }
                catch (MalformedURLException muex) {
                    Logger.getLogger(SourcePath.class.getName()).log(Level.WARNING, "Malformed URL '" + url + "' produced by " + this.getContext(), muex);
                    return null;
                }
                return url;
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (SecurityException securityException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return null;
    }

    public void showSource(JPDAThread t, String stratumn) {
        String[] sourcePathPtr;
        String url;
        int lineNumber = t.getLineNumber(stratumn);
        if (lineNumber < 1) {
            lineNumber = 1;
        }
        if ((url = this.getURL(t, stratumn, sourcePathPtr = new String[1])) == null) {
            String message = NbBundle.getMessage(SourcePath.class, (String)"No_URL_Warning", (Object)sourcePathPtr[0]);
            ErrorManager.getDefault().log(16, message);
            StatusDisplayer.getDefault().setStatusText(message);
            return;
        }
        final int ln = lineNumber;
        final String u = url;
        SwingUtilities.invokeLater(new Runnable(){
            final /* synthetic */ SourcePath this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                EditorContextBridge.getContext().showSource(u, ln, (Object)this.this$0.debugger);
            }
        });
    }

    public void showSource(CallStackFrame csf, String stratumn) {
        int lineNumber;
        String url;
        block7: {
            url = null;
            JPDAClassType classType = ((CallStackFrameImpl)csf).getClassType();
            if (classType != null) {
                url = this.getClassURL(classType, stratumn);
            }
            if (url == null) {
                try {
                    url = this.getURL(SourcePath.convertSlash(csf.getSourcePath(stratumn)), true);
                    if (url == null) {
                        stratumn = csf.getDefaultStratum();
                        url = this.getURL(SourcePath.convertSlash(csf.getSourcePath(stratumn)), true);
                    }
                    if (url == null) {
                        String message = NbBundle.getMessage(SourcePath.class, (String)"No_URL_Warning", (Object)csf.getSourcePath(stratumn));
                        ErrorManager.getDefault().log(16, message);
                        StatusDisplayer.getDefault().setStatusText(message);
                        return;
                    }
                }
                catch (AbsentInformationException e) {
                    url = this.getURL(SourcePath.convertClassNameToRelativePath(csf.getClassName()), true);
                    if (url != null) break block7;
                    String message = NbBundle.getMessage(SourcePath.class, (String)"No_URL_Warning", (Object)csf.getClassName());
                    ErrorManager.getDefault().log(16, message);
                    StatusDisplayer.getDefault().setStatusText(message);
                    return;
                }
            }
        }
        if ((lineNumber = csf.getLineNumber(stratumn)) < 1) {
            lineNumber = 1;
        }
        final int ln = lineNumber;
        final String u = url;
        SwingUtilities.invokeLater(new Runnable(){
            final /* synthetic */ SourcePath this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                EditorContextBridge.getContext().showSource(u, ln, (Object)this.this$0.debugger);
            }
        });
    }

    public void showSource(Field v) {
        this.showSource(v, true);
    }

    public void showSource(Field v, final boolean reportUnknownSource) {
        String fieldName = v.getName();
        String url = null;
        JPDAClassType declaringClass = v.getDeclaringClass();
        if (declaringClass != null) {
            url = this.getClassURL(declaringClass, null);
        }
        String className = v.getClassName();
        final String sourcePath = EditorContextBridge.getRelativePath(className);
        if (url == null) {
            url = this.getURL(sourcePath, true);
        }
        if (url == null) {
            return;
        }
        int lineNumber = EditorContextBridge.getContext().getFieldLineNumber(url, className, fieldName);
        if (lineNumber < 1) {
            lineNumber = 1;
        }
        final int ln = lineNumber;
        final String u = url;
        SwingUtilities.invokeLater(new Runnable(){
            final /* synthetic */ SourcePath this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                boolean success = EditorContextBridge.getContext().showSource(u, ln, (Object)this.this$0.debugger);
                if (reportUnknownSource && !success) {
                    String message = NbBundle.getMessage(SourcePath.class, (String)"No_URL_Warning", (Object)sourcePath);
                    NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)message, 2);
                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)d);
                }
            }
        });
    }

    static String convertSlash(String original) {
        return original.replace(File.separatorChar, '/');
    }

    public static String convertClassNameToRelativePath(String className) {
        int i = className.indexOf(36);
        if (i > 0) {
            className = className.substring(0, i);
        }
        String sourceName = className.replace('.', '/') + ".java";
        return sourceName;
    }

    public Object annotate(JPDAThread t, String stratumn, String url, int lineNumber) {
        return this.annotate(t, stratumn, url, lineNumber, true);
    }

    public Object annotate(JPDAThread t, String stratumn, String url, int lineNumber, boolean isCurrent) {
        List operationsAnn;
        EditorContext.Operation operation;
        if (isCurrent) {
            operation = t.getCurrentOperation();
            operationsAnn = SourcePath.annotateOperations(this.debugger, url, operation, t.getLastOperations(), lineNumber);
        } else {
            operation = null;
            operationsAnn = Collections.EMPTY_LIST;
        }
        if (operation == null && operationsAnn.size() == 0) {
            return EditorContextBridge.getContext().annotate(url, lineNumber, isCurrent ? "CurrentPC" : "OtherThread", (Object)this.debugger, t);
        }
        return operationsAnn;
    }

    public Object annotate(CallStackFrame csf, String stratumn) {
        int lineNumber = csf.getLineNumber(stratumn);
        if (lineNumber < 1) {
            return null;
        }
        EditorContext.Operation operation = csf.getCurrentOperation(stratumn);
        if (operation != null) {
            int endOffset;
            int startOffset;
            if (operation.getMethodName() != null) {
                startOffset = operation.getMethodStartPosition().getOffset();
                endOffset = operation.getMethodEndPosition().getOffset();
            } else {
                startOffset = operation.getStartPosition().getOffset();
                endOffset = operation.getEndPosition().getOffset();
            }
            String url = this.getURL(csf, stratumn);
            return EditorContextBridge.getContext().annotate(url, startOffset, endOffset, "CallSite", (Object)this.debugger);
        }
        String url = this.getURL(csf, stratumn);
        return EditorContextBridge.getContext().annotate(url, lineNumber, "CallSite", (Object)this.debugger);
    }

    private static List annotateOperations(JPDADebugger debugger, String url, EditorContext.Operation currentOperation, List lastOperations, int locLineNumber) {
        Object ann;
        ArrayList<Object> annotations = null;
        int currentOperationLine = -1;
        if (currentOperation != null) {
            annotations = new ArrayList<Object>();
            Object ann2 = SourcePath.createAnnotation(debugger, url, currentOperation, "CurrentPC", true);
            if (ann2 != null) {
                annotations.add(ann2);
            }
            int lineNumber = currentOperation.getMethodName() != null ? currentOperation.getMethodStartPosition().getLine() : currentOperation.getStartPosition().getLine();
            ann2 = EditorContextBridge.getContext().annotate(url, lineNumber, "CurrentExpressionLine", (Object)debugger);
            currentOperationLine = lineNumber;
            if (ann2 != null) {
                annotations.add(ann2);
            }
        }
        boolean isNewLineExp = false;
        if (lastOperations != null && lastOperations.size() > 0) {
            if (annotations == null) {
                annotations = new ArrayList();
            }
            isNewLineExp = currentOperation == null;
            for (int i = 0; i < lastOperations.size(); ++i) {
                Object ann3;
                EditorContext.Operation lastOperation = (EditorContext.Operation)lastOperations.get(i);
                if (currentOperation == lastOperation && i == lastOperations.size() - 1) {
                    int lineNumber;
                    ann3 = SourcePath.createAnnotation(debugger, url, lastOperation, "StepOutOperation", false);
                    if (ann3 != null) {
                        annotations.add(ann3);
                    }
                    if (currentOperationLine != (lineNumber = lastOperation.getEndPosition().getLine()) && (ann3 = EditorContextBridge.getContext().annotate(url, lineNumber, "CurrentExpressionLine", (Object)debugger)) != null) {
                        annotations.add(ann3);
                    }
                    isNewLineExp = false;
                    continue;
                }
                ann3 = SourcePath.createAnnotation(debugger, url, lastOperation, "LastOperation", true);
                if (ann3 == null) continue;
                annotations.add(ann3);
            }
        }
        if (isNewLineExp && (ann = EditorContextBridge.getContext().annotate(url, locLineNumber, "CurrentPC", (Object)debugger)) != null) {
            annotations.add(ann);
        }
        if (annotations != null) {
            return annotations;
        }
        return Collections.EMPTY_LIST;
    }

    private static Object createAnnotation(JPDADebugger debugger, String url, EditorContext.Operation operation, String type, boolean method) {
        int endOffset;
        int startOffset;
        if (method && operation.getMethodName() != null) {
            startOffset = operation.getMethodStartPosition().getOffset();
            endOffset = operation.getMethodEndPosition().getOffset();
        } else {
            startOffset = operation.getStartPosition().getOffset();
            endOffset = operation.getEndPosition().getOffset();
        }
        return EditorContextBridge.getContext().annotate(url, startOffset, endOffset, type, (Object)debugger);
    }

    private static class CompoundContextProvider
    extends SourcePathProvider {
        private SourcePathProvider cp1;
        private SourcePathProvider cp2;

        CompoundContextProvider(SourcePathProvider cp1, SourcePathProvider cp2) {
            this.cp1 = cp1;
            this.cp2 = cp2;
        }

        public String getURL(String relativePath, boolean global) {
            String p1 = this.cp1.getURL(relativePath, global);
            if (p1 != null) {
                try {
                    new URL(p1);
                    return p1;
                }
                catch (MalformedURLException muex) {
                    Logger.getLogger(SourcePath.class.getName()).log(Level.WARNING, "Malformed URL '" + p1 + "' produced by " + this.cp1, muex);
                }
            }
            if ((p1 = this.cp2.getURL(relativePath, global)) != null) {
                try {
                    new URL(p1);
                }
                catch (MalformedURLException muex) {
                    Logger.getLogger(SourcePath.class.getName()).log(Level.WARNING, "Malformed URL '" + p1 + "' produced by " + this.cp2, muex);
                    p1 = null;
                }
            }
            return p1;
        }

        public String getURL(JPDAClassType clazz, String stratum) {
            String url;
            Method getURLMethod2;
            try {
                getURLMethod2 = this.cp1.getClass().getMethod("getURL", JPDAClassType.class, String.class);
                url = (String)getURLMethod2.invoke((Object)this.cp1, clazz, stratum);
                if (url != null) {
                    return url;
                }
            }
            catch (IllegalAccessException getURLMethod2) {
            }
            catch (IllegalArgumentException getURLMethod2) {
            }
            catch (NoSuchMethodException getURLMethod2) {
            }
            catch (SecurityException getURLMethod2) {
            }
            catch (InvocationTargetException getURLMethod2) {
                // empty catch block
            }
            try {
                getURLMethod2 = this.cp2.getClass().getMethod("getURL", JPDAClassType.class, String.class);
                url = (String)getURLMethod2.invoke((Object)this.cp2, clazz, stratum);
                if (url != null) {
                    return url;
                }
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (SecurityException securityException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
            return null;
        }

        public String getRelativePath(String url, char directorySeparator, boolean includeExtension) {
            String p1 = this.cp1.getRelativePath(url, directorySeparator, includeExtension);
            if (p1 != null) {
                return p1;
            }
            return this.cp2.getRelativePath(url, directorySeparator, includeExtension);
        }

        public String[] getSourceRoots() {
            String[] fs1 = this.cp1.getSourceRoots();
            String[] fs2 = this.cp2.getSourceRoots();
            String[] fs = new String[fs1.length + fs2.length];
            System.arraycopy(fs1, 0, fs, 0, fs1.length);
            System.arraycopy(fs2, 0, fs, fs1.length, fs2.length);
            return fs;
        }

        public String[] getOriginalSourceRoots() {
            String[] fs1 = this.cp1.getOriginalSourceRoots();
            String[] fs2 = this.cp2.getOriginalSourceRoots();
            String[] fs = new String[fs1.length + fs2.length];
            System.arraycopy(fs1, 0, fs, 0, fs1.length);
            System.arraycopy(fs2, 0, fs, fs1.length, fs2.length);
            return fs;
        }

        public void setSourceRoots(String[] sourceRoots) {
            this.cp1.setSourceRoots(sourceRoots);
            this.cp2.setSourceRoots(sourceRoots);
        }

        public String[] getAdditionalSourceRoots() {
            String[] additionalSourceRoots2;
            String[] additionalSourceRoots1;
            Method getAdditionalSourceRootsMethod;
            try {
                getAdditionalSourceRootsMethod = this.cp1.getClass().getMethod("getAdditionalSourceRoots", new Class[0]);
                additionalSourceRoots1 = (String[])getAdditionalSourceRootsMethod.invoke((Object)this.cp1, new Object[0]);
            }
            catch (Exception ex) {
                additionalSourceRoots1 = new String[]{};
            }
            try {
                getAdditionalSourceRootsMethod = this.cp2.getClass().getMethod("getAdditionalSourceRoots", new Class[0]);
                additionalSourceRoots2 = (String[])getAdditionalSourceRootsMethod.invoke((Object)this.cp2, new Object[0]);
            }
            catch (Exception ex) {
                additionalSourceRoots2 = new String[]{};
            }
            if (additionalSourceRoots1.length == 0) {
                return additionalSourceRoots2;
            }
            if (additionalSourceRoots2.length == 0) {
                return additionalSourceRoots1;
            }
            String[] additionalSourceRoots = new String[additionalSourceRoots1.length + additionalSourceRoots2.length];
            System.arraycopy(additionalSourceRoots1, 0, additionalSourceRoots, 0, additionalSourceRoots1.length);
            System.arraycopy(additionalSourceRoots2, 0, additionalSourceRoots, additionalSourceRoots1.length, additionalSourceRoots2.length);
            return additionalSourceRoots;
        }

        public void setSourceRoots(String[] sourceRoots, String[] additionalRoots) {
            Method setSourceRootsMethod;
            try {
                setSourceRootsMethod = this.cp1.getClass().getMethod("setSourceRoots", String[].class, String[].class);
                setSourceRootsMethod.invoke((Object)this.cp1, sourceRoots, additionalRoots);
            }
            catch (Exception ex) {
                this.cp1.setSourceRoots(sourceRoots);
            }
            try {
                setSourceRootsMethod = this.cp2.getClass().getMethod("setSourceRoots", String[].class, String[].class);
                setSourceRootsMethod.invoke((Object)this.cp2, sourceRoots, additionalRoots);
            }
            catch (Exception ex) {
                this.cp2.setSourceRoots(sourceRoots);
            }
        }

        public void reorderOriginalSourceRoots(int[] permutation) {
            Method reorderOriginalSourceRootsMethod2;
            try {
                reorderOriginalSourceRootsMethod2 = this.cp1.getClass().getMethod("reorderOriginalSourceRoots", int[].class);
                reorderOriginalSourceRootsMethod2.invoke((Object)this.cp1, new Object[]{permutation});
            }
            catch (Exception reorderOriginalSourceRootsMethod2) {
                // empty catch block
            }
            try {
                reorderOriginalSourceRootsMethod2 = this.cp2.getClass().getMethod("reorderOriginalSourceRoots", int[].class);
                reorderOriginalSourceRootsMethod2.invoke((Object)this.cp2, new Object[]{permutation});
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
            this.cp1.addPropertyChangeListener(l);
            this.cp2.addPropertyChangeListener(l);
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
            this.cp1.removePropertyChangeListener(l);
            this.cp2.removePropertyChangeListener(l);
        }
    }

    private static class CompoundAnnotation {
        Object annotation1;
        Object annotation2;

        private CompoundAnnotation() {
        }
    }
}

