/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections.ui.transfer;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import org.netbeans.modules.php.project.connections.transfer.TransferFile;
import org.netbeans.modules.php.project.connections.ui.transfer.Bundle;
import org.netbeans.modules.php.project.connections.ui.transfer.TransferFilesChooserPanel;
import org.netbeans.modules.php.project.connections.ui.transfer.TransferFilesChooserVisual;
import org.netbeans.modules.php.project.connections.ui.transfer.tree.TransferSelector;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.Mutex;

public final class TransferFilesChooser {
    private final Set<TransferFile> transferFiles;
    private final TransferType transferType;
    private final long timestamp;
    private TransferFilesChooserVisual transferVisual;
    private TransferFilesChooserPanel transferPanel;

    private TransferFilesChooser(Set<TransferFile> transferFiles, TransferType transferType, long timestamp) {
        assert (transferFiles != null);
        assert (transferType != null);
        this.transferFiles = Collections.synchronizedSet(new HashSet<TransferFile>(transferFiles));
        this.transferType = transferType;
        this.timestamp = timestamp;
    }

    public static TransferFilesChooser forDownload(Set<TransferFile> transferFiles) {
        return TransferFilesChooser.forDownload(transferFiles, -1L);
    }

    public static TransferFilesChooser forDownload(Set<TransferFile> transferFiles, long timestamp) {
        return new TransferFilesChooser(transferFiles, TransferType.DOWNLOAD, timestamp);
    }

    public static TransferFilesChooser forUpload(Set<TransferFile> transferFiles) {
        return TransferFilesChooser.forUpload(transferFiles, -1L);
    }

    public static TransferFilesChooser forUpload(Set<TransferFile> transferFiles, long timestamp) {
        return new TransferFilesChooser(transferFiles, TransferType.UPLOAD, timestamp);
    }

    public Set<TransferFile> showDialog() {
        return (Set)Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<Set<TransferFile>>(){

            public Set<TransferFile> run() {
                return TransferFilesChooser.this.showDialogInernal();
            }
        });
    }

    Set<TransferFile> showDialogInernal() {
        String buttonLabel;
        String title;
        switch (this.transferType.ordinal()) {
            case 1: {
                title = Bundle.TransferFilesChooser_title_download();
                buttonLabel = Bundle.TransferFilesChooser_button_downloadWithMnemonics();
                break;
            }
            case 0: {
                title = Bundle.TransferFilesChooser_title_upload();
                buttonLabel = Bundle.TransferFilesChooser_button_uploadWithMnemonics();
                break;
            }
            default: {
                throw new IllegalStateException("Unknown transfer type: " + (Object)((Object)this.transferType));
            }
        }
        JButton okButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)okButton, (String)buttonLabel);
        DialogDescriptor descriptor = new DialogDescriptor((Object)this.getTransferVisual(), title, true, new Object[]{okButton, DialogDescriptor.CANCEL_OPTION}, (Object)okButton, 0, null, null);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor) == okButton) {
            return this.getTransferPanel().getSelectedFiles();
        }
        return Collections.emptySet();
    }

    public TransferFilesChooserPanel getEmbeddablePanel() {
        return this.getTransferVisual().getEmbeddablePanel();
    }

    public boolean hasAnyTransferableFiles() {
        return this.getTransferPanel().hasAnyTransferableFiles();
    }

    private synchronized TransferFilesChooserVisual getTransferVisual() {
        if (this.transferVisual == null) {
            this.transferVisual = new TransferFilesChooserVisual(this.getTransferPanel(), this.transferType);
        }
        return this.transferVisual;
    }

    private synchronized TransferFilesChooserPanel getTransferPanel() {
        if (this.transferPanel == null) {
            this.transferPanel = new TransferSelector(this.transferFiles, this.transferType, this.timestamp);
        }
        return this.transferPanel;
    }

    public static enum TransferType {
        UPLOAD,
        DOWNLOAD;

    }
}

