/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.options;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.MercurialAnnotator;
import org.netbeans.modules.mercurial.options.HgExtProperties;
import org.netbeans.modules.mercurial.options.LabelsPanel;
import org.netbeans.modules.mercurial.options.MercurialPanel;
import org.netbeans.modules.mercurial.options.PropertiesPanel;
import org.netbeans.modules.mercurial.options.PropertiesTable;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.util.AccessibleJFileChooser;
import org.netbeans.modules.versioning.util.VCSOptionsKeywordsProvider;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

final class MercurialOptionsPanelController
extends OptionsPanelController
implements ActionListener,
VCSOptionsKeywordsProvider {
    private MercurialPanel panel;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private boolean changed;

    public MercurialOptionsPanelController() {
        this.panel = new MercurialPanel(this);
        this.panel.execPathBrowseButton.addActionListener(this);
        this.panel.exportFilenameBrowseButton.addActionListener(this);
        String tooltip = NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.annotationTextField.toolTipText", (Object[])MercurialAnnotator.LABELS);
        this.panel.annotationTextField.setToolTipText(tooltip);
        this.panel.addButton.addActionListener(this);
        this.panel.manageButton.addActionListener(this);
    }

    public void update() {
        this.getPanel().load();
        this.changed = false;
    }

    public void applyChanges() {
        this.getPanel().store();
        Mercurial.getInstance().getMercurialAnnotator().refresh();
        Mercurial.getInstance().refreshAllAnnotations();
        this.changed = false;
    }

    public void cancel() {
    }

    public boolean isValid() {
        return this.validateFields();
    }

    public boolean isChanged() {
        return this.changed;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(MercurialOptionsPanelController.class);
    }

    public JComponent getComponent(Lookup masterLookup) {
        return this.getPanel();
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.panel.execPathBrowseButton) {
            this.onExecPathBrowseClick();
        } else if (evt.getSource() == this.panel.exportFilenameBrowseButton) {
            this.onExportFilenameBrowseClick();
        } else if (evt.getSource() == this.panel.addButton) {
            this.onAddClick();
        } else if (evt.getSource() == this.panel.manageButton) {
            this.onManageClick();
        }
    }

    public boolean acceptKeywords(List<String> keywords) {
        HashSet<String> allKeywords = new HashSet<String>(this.panel.getKeywords());
        allKeywords.retainAll(keywords);
        return !allKeywords.isEmpty();
    }

    private File getExportFile() {
        String execPath = this.panel.exportFilenameTextField.getText();
        return FileUtil.normalizeFile((File)new File(execPath));
    }

    private File getExecutableFile() {
        String execPath = this.panel.executablePathTextField.getText();
        return FileUtil.normalizeFile((File)new File(execPath));
    }

    private boolean validateFields() {
        this.getPanel().showError(null);
        String username = this.panel.userNameTextField.getText();
        if (!HgModuleConfig.getDefault().isUserNameValid(username).booleanValue()) {
            this.getPanel().showError(NbBundle.getMessage(MercurialPanel.class, (String)"MSG_WARN_USER_NAME_TEXT"));
            return false;
        }
        String execpath = this.panel.executablePathTextField.getText();
        String hgExecutableParent = null;
        if (Utilities.isWindows()) {
            hgExecutableParent = MercurialOptionsPanelController.getHgWindowsExecutableParent(execpath);
        }
        if (hgExecutableParent == null && execpath.endsWith("hg")) {
            hgExecutableParent = execpath.substring(0, execpath.length() - "hg".length());
        }
        if (hgExecutableParent == null) {
            hgExecutableParent = execpath;
        }
        if (!HgModuleConfig.getDefault().isExecPathValid(hgExecutableParent).booleanValue()) {
            this.getPanel().showError(NbBundle.getMessage(MercurialPanel.class, (String)"MSG_WARN_EXEC_PATH_TEXT"));
            return false;
        }
        if (!HgUtils.isAnnotationFormatValid(HgUtils.createAnnotationFormat(this.panel.annotationTextField.getText()))) {
            this.getPanel().showError(NbBundle.getMessage(MercurialPanel.class, (String)"MSG_WARN_ANNOTATION_FORMAT_TEXT"));
            return false;
        }
        return true;
    }

    private static String getHgWindowsExecutableParent(String pathToCheck) {
        for (String hgExecutable : HgCommand.HG_WINDOWS_EXECUTABLES) {
            if (!pathToCheck.endsWith(hgExecutable)) continue;
            return pathToCheck.substring(0, pathToCheck.length() - hgExecutable.length());
        }
        return null;
    }

    private void onExportFilenameBrowseClick() {
        File oldFile = this.getExecutableFile();
        AccessibleJFileChooser fileChooser = new AccessibleJFileChooser(NbBundle.getMessage(MercurialOptionsPanelController.class, (String)"ACSD_ExportBrowseFolder"), oldFile);
        fileChooser.setDialogTitle(NbBundle.getMessage(MercurialOptionsPanelController.class, (String)"ExportBrowse_title"));
        fileChooser.setMultiSelectionEnabled(false);
        FileFilter[] old = fileChooser.getChoosableFileFilters();
        for (int i = 0; i < old.length; ++i) {
            FileFilter fileFilter = old[i];
            fileChooser.removeChoosableFileFilter(fileFilter);
        }
        fileChooser.showDialog(this.panel, NbBundle.getMessage(MercurialOptionsPanelController.class, (String)"OK_Button"));
        File f = fileChooser.getSelectedFile();
        if (f != null) {
            this.panel.exportFilenameTextField.setText(f.getAbsolutePath());
        }
    }

    private void onExecPathBrowseClick() {
        File oldFile = this.getExportFile();
        AccessibleJFileChooser fileChooser = new AccessibleJFileChooser(NbBundle.getMessage(MercurialOptionsPanelController.class, (String)"ACSD_BrowseFolder"), oldFile);
        fileChooser.setDialogTitle(NbBundle.getMessage(MercurialOptionsPanelController.class, (String)"Browse_title"));
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.showDialog(this.panel, NbBundle.getMessage(MercurialOptionsPanelController.class, (String)"OK_Button"));
        File f = fileChooser.getSelectedFile();
        if (f != null) {
            this.panel.executablePathTextField.setText(f.getAbsolutePath());
        }
    }

    private MercurialPanel getPanel() {
        if (this.panel == null) {
            this.panel = new MercurialPanel(this);
        }
        return this.panel;
    }

    void changed(boolean isChanged) {
        boolean oldValue = this.changed;
        this.changed = isChanged;
        if (this.changed != oldValue) {
            this.pcs.firePropertyChange("changed", oldValue, this.changed);
        }
        this.pcs.firePropertyChange("valid", null, null);
    }

    private void onAddClick() {
        LabelsPanel labelsPanel = new LabelsPanel();
        ArrayList<LabelVariable> variables = new ArrayList<LabelVariable>(MercurialAnnotator.LABELS.length);
        for (int i = 0; i < MercurialAnnotator.LABELS.length; ++i) {
            LabelVariable variable = new LabelVariable(MercurialAnnotator.LABELS[i], "{" + MercurialAnnotator.LABELS[i] + "} - " + NbBundle.getMessage(MercurialPanel.class, (String)("MercurialPanel.label." + MercurialAnnotator.LABELS[i])));
            variables.add(variable);
        }
        labelsPanel.labelsList.setListData(variables.toArray(new LabelVariable[0]));
        String title = NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.labelVariables.title");
        String acsd = NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.labelVariables.acsd");
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)labelsPanel, title);
        dialogDescriptor.setModal(true);
        dialogDescriptor.setValid(true);
        final Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(acsd);
        labelsPanel.labelsList.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ MercurialOptionsPanelController this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    dialog.setVisible(false);
                }
            }
        });
        dialog.setVisible(true);
        if (DialogDescriptor.OK_OPTION.equals(dialogDescriptor.getValue())) {
            Object[] selection = labelsPanel.labelsList.getSelectedValues();
            String variable = "";
            for (int i = 0; i < selection.length; ++i) {
                variable = variable + "{" + ((LabelVariable)selection[i]).getVariable() + "}";
            }
            String annotation = this.panel.annotationTextField.getText();
            int pos = this.panel.annotationTextField.getCaretPosition();
            if (pos < 0) {
                pos = annotation.length();
            }
            StringBuffer sb = new StringBuffer(annotation.length() + variable.length());
            sb.append(annotation.substring(0, pos));
            sb.append(variable);
            if (pos < annotation.length()) {
                sb.append(annotation.substring(pos));
            }
            this.panel.annotationTextField.setText(sb.toString());
            this.panel.annotationTextField.requestFocus();
            this.panel.annotationTextField.setCaretPosition(pos + variable.length());
        }
    }

    private void onManageClick() {
        PropertiesPanel panel = new PropertiesPanel();
        PropertiesTable propTable = new PropertiesTable(panel.labelForTable, PropertiesTable.PROPERTIES_COLUMNS, new String[]{"value"});
        panel.setPropertiesTable(propTable);
        JComponent component = propTable.getComponent();
        panel.propsPanel.setLayout(new BorderLayout());
        panel.propsPanel.add((Component)component, "Center");
        HgExtProperties hgProperties = new HgExtProperties(panel, propTable, null);
        JButton okButton = new JButton(NbBundle.getMessage(MercurialOptionsPanelController.class, (String)"CTL_Properties_Action_OK"));
        okButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MercurialOptionsPanelController.class, (String)"CTL_Properties_Action_OK"));
        JButton cancelButton = new JButton(NbBundle.getMessage(MercurialOptionsPanelController.class, (String)"CTL_Properties_Action_Cancel"));
        cancelButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MercurialOptionsPanelController.class, (String)"CTL_Properties_Action_Cancel"));
        DialogDescriptor dd = new DialogDescriptor((Object)panel, NbBundle.getMessage(MercurialOptionsPanelController.class, (String)"CTL_PropertiesDialog_Title", null), true, new Object[]{okButton, cancelButton}, (Object)okButton, 0, new HelpCtx(MercurialOptionsPanelController.class), null);
        panel.putClientProperty("contentTitle", null);
        panel.putClientProperty("DialogDescriptor", dd);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MercurialOptionsPanelController.class, (String)"CTL_PropertiesDialog_Title"));
        dialog.pack();
        dialog.setVisible(true);
        if (dd.getValue() == okButton) {
            hgProperties.setProperties();
        }
    }

    private class LabelVariable {
        private String description;
        private String variable;

        public LabelVariable(String variable, String description) {
            this.description = description;
            this.variable = variable;
        }

        public String toString() {
            return this.description;
        }

        public String getDescription() {
            return this.description;
        }

        public String getVariable() {
            return this.variable;
        }
    }
}

