/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.nodejs.misc;

import java.io.File;
import java.net.URI;
import java.util.EventListener;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.queries.SharabilityQuery;
import org.netbeans.modules.javascript.nodejs.file.PackageJson;
import org.netbeans.modules.javascript.nodejs.options.NodeJsOptions;
import org.netbeans.spi.queries.SharabilityQueryImplementation2;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public final class SharabilityQueryImpl
implements SharabilityQueryImplementation2,
PreferenceChangeListener {
    private final PackageJson packageJson;
    private volatile URI nodeModulesUri;
    private volatile Boolean versioningIgnored;

    private SharabilityQueryImpl(Project project) {
        assert (project != null);
        this.packageJson = new PackageJson(project.getProjectDirectory());
    }

    private static SharabilityQueryImplementation2 create(Project project) {
        SharabilityQueryImpl sharabilityQuery = new SharabilityQueryImpl(project);
        NodeJsOptions nodeJsOptions = NodeJsOptions.getInstance();
        nodeJsOptions.addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)sharabilityQuery, (Object)nodeJsOptions));
        return sharabilityQuery;
    }

    public static SharabilityQueryImplementation2 forHtml5Project(Project project) {
        return SharabilityQueryImpl.create(project);
    }

    public static SharabilityQueryImplementation2 forPhpProject(Project project) {
        return SharabilityQueryImpl.create(project);
    }

    public static SharabilityQueryImplementation2 forWebProject(Project project) {
        return SharabilityQueryImpl.create(project);
    }

    public static SharabilityQueryImplementation2 forMavenProject(Project project) {
        return SharabilityQueryImpl.create(project);
    }

    public SharabilityQuery.Sharability getSharability(URI uri) {
        if (this.isVersioningIgnored() && uri.equals(this.getNodeModulesUri())) {
            return SharabilityQuery.Sharability.NOT_SHARABLE;
        }
        return SharabilityQuery.Sharability.UNKNOWN;
    }

    public URI getNodeModulesUri() {
        if (this.nodeModulesUri == null) {
            this.nodeModulesUri = Utilities.toURI((File)this.packageJson.getNodeModulesDir());
        }
        return this.nodeModulesUri;
    }

    public boolean isVersioningIgnored() {
        if (this.versioningIgnored == null) {
            this.versioningIgnored = NodeJsOptions.getInstance().isNpmIgnoreNodeModules();
        }
        return this.versioningIgnored;
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent evt) {
        if ("npm.ignore.node_modules".equals(evt.getKey())) {
            this.versioningIgnored = null;
        }
    }
}

