/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.netbeans.lib.profiler.ui.UIUtils;

public final class ProfilerPopup {
    private static final boolean DEBUG = Boolean.getBoolean("ProfilerPopup.DebugWindows");
    private static final int IGNORE_OWNER_TIMEOUT = Integer.getInteger("ProfilerPopup.OwnerTimeout", 40);
    private static final int RESIZE_STRIPE = Integer.getInteger("ProfilerPopup.ResizeStripe", 10);
    public static final int RESIZE_NONE = 0;
    public static final int RESIZE_TOP = 1;
    public static final int RESIZE_LEFT = 2;
    public static final int RESIZE_BOTTOM = 4;
    public static final int RESIZE_RIGHT = 8;
    private final Reference<Window> ownerRef;
    private final PopupPane content;
    private final Rectangle location;
    private final int popupAlign;
    private JWindow window;
    private Window owner;
    private Point ownerLocation;
    private final Listener listener;
    private final int resizeMode;

    public static ProfilerPopup create(Component invoker, Component content, int x, int y) {
        return ProfilerPopup.create(invoker, content, x, y, 0);
    }

    public static ProfilerPopup createRelative(Component invoker, Component content, int popupAlign) {
        if (invoker == null) {
            throw new IllegalArgumentException("Invoker cannot be null for relative popups");
        }
        return ProfilerPopup.createRelative(invoker, content, popupAlign, 0);
    }

    public static ProfilerPopup create(Component invoker, Component content, int x, int y, int resizeMode) {
        return ProfilerPopup.create(invoker, content, x, y, resizeMode, null);
    }

    public static ProfilerPopup createRelative(Component invoker, Component content, int popupAlign, int resizeMode) {
        if (invoker == null) {
            throw new IllegalArgumentException("Invoker cannot be null for relative popups");
        }
        return ProfilerPopup.createRelative(invoker, content, popupAlign, resizeMode, null);
    }

    public static ProfilerPopup create(Component invoker, Component content, int x, int y, int resizeMode, Listener listener) {
        return ProfilerPopup.create(invoker, content, x, y, -1, resizeMode, listener);
    }

    public static ProfilerPopup createRelative(Component invoker, Component content, int popupAlign, int resizeMode, Listener listener) {
        if (invoker == null) {
            throw new IllegalArgumentException("Invoker cannot be null for relative popups");
        }
        return ProfilerPopup.create(invoker, content, -1, -1, popupAlign, resizeMode, listener);
    }

    private static ProfilerPopup create(Component invoker, Component content, int x, int y, int popupAlign, int resizeMode, Listener listener) {
        Point location = new Point(x, y);
        Dimension size = new Dimension();
        Window owner = null;
        if (invoker != null) {
            SwingUtilities.convertPointToScreen(location, invoker);
            size.setSize(invoker.getSize());
            owner = SwingUtilities.getWindowAncestor(invoker);
        }
        return new ProfilerPopup(content, new Rectangle(location, size), popupAlign, owner, resizeMode, listener);
    }

    public void show() {
        this.owner = this.ownerRef == null ? null : this.ownerRef.get();
        this.ownerLocation = this.owner == null ? null : this.owner.getLocationOnScreen();
        this.window = new JWindow(this.owner);
        this.window.setType(Window.Type.POPUP);
        this.window.setAlwaysOnTop(false);
        this.window.setFocusable(true);
        this.window.setFocusableWindowState(true);
        this.window.setAutoRequestFocus(true);
        this.window.getContentPane().add(this.content);
        this.window.pack();
        if (this.popupAlign == -1) {
            this.window.setLocation(this.location.getLocation());
        } else {
            int y;
            int x;
            Dimension size = this.content.getSize();
            switch (this.popupAlign) {
                case 2: 
                case 3: 
                case 4: {
                    x = this.location.x + this.location.width - size.width + 1;
                    break;
                }
                default: {
                    x = this.location.x + 1;
                }
            }
            switch (this.popupAlign) {
                case 1: 
                case 2: 
                case 8: {
                    y = this.location.y - size.height + 1;
                    break;
                }
                default: {
                    y = this.location.y + this.location.height + 1;
                }
            }
            this.window.setLocation(x, y);
        }
        this.window.setVisible(true);
        Component defaultFocus = this.content.getFocusTraversalPolicy().getDefaultComponent(this.content);
        if (defaultFocus != null) {
            defaultFocus.requestFocusInWindow();
        }
        this.content.installListeners();
        if (this.listener != null) {
            this.listener.popupShown();
        }
    }

    public void hide() {
        this.content.uninstallListeners();
        this.owner = null;
        this.ownerLocation = null;
        this.window.setVisible(false);
        this.window.dispose();
        this.window = null;
        if (this.listener != null) {
            this.listener.popupHidden();
        }
    }

    public static boolean isInPopup(Component component) {
        for (Container parent = component.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof PopupPane)) continue;
            return true;
        }
        return false;
    }

    private ProfilerPopup(Component component, Rectangle location, int popupAlign, Window owner, int resizeMode, Listener listener) {
        this.content = new PopupPane(component, resizeMode != 0);
        this.location = location;
        this.popupAlign = popupAlign;
        this.ownerRef = owner == null ? null : new WeakReference<Window>(owner);
        this.resizeMode = resizeMode;
        this.listener = listener;
    }

    private class PopupPane
    extends JPanel
    implements WindowFocusListener,
    ComponentListener,
    KeyEventDispatcher,
    MouseListener,
    MouseMotionListener {
        private boolean skippingEvents;
        private long gainedFocusTime;
        private boolean dragging;
        private int currentResizing;
        private int dragX;
        private int dragY;

        PopupPane(Component content, boolean resize) {
            super(new BorderLayout());
            this.dragY = -1;
            this.add(content, "Center");
            this.setFocusCycleRoot(true);
            this.setFocusTraversalPolicyProvider(true);
            this.setFocusTraversalPolicy(new PopupFocusTraversalPolicy());
            if (UIUtils.isAquaLookAndFeel()) {
                if (resize) {
                    this.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
                    this.addMouseListener(this);
                    this.addMouseMotionListener(this);
                }
            } else {
                Border border = BorderFactory.createLineBorder(UIUtils.getDisabledLineColor());
                if (resize) {
                    this.setBorder(BorderFactory.createCompoundBorder(border, BorderFactory.createEmptyBorder(8, 8, 8, 8)));
                    this.addMouseListener(this);
                    this.addMouseMotionListener(this);
                } else {
                    this.setBorder(border);
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.dragging = true;
            this.dragX = e.getXOnScreen();
            this.dragY = e.getYOnScreen();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.dragging = false;
            this.dragX = -1;
            this.dragY = -1;
            this.updateResizing(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (!this.dragging) {
                this.updateResizing(e);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (!this.dragging) {
                this.currentResizing = 0;
                this.setCursor(Cursor.getDefaultCursor());
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (!this.dragging) {
                this.updateResizing(e);
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.dragX >= 0 && this.dragY >= 0) {
                int x = e.getXOnScreen();
                int y = e.getYOnScreen();
                int dx = x - this.dragX;
                int dy = y - this.dragY;
                int newX = ProfilerPopup.this.window.getX();
                int newY = ProfilerPopup.this.window.getY();
                int newW = ProfilerPopup.this.window.getWidth();
                int newH = ProfilerPopup.this.window.getHeight();
                int xx = 0;
                int yy = 0;
                Dimension min = ProfilerPopup.this.window.getMinimumSize();
                if (this.isResizeLeft(this.currentResizing)) {
                    newX += dx;
                    if ((newW -= dx) < min.width) {
                        xx = newW - min.width;
                        newX += xx;
                        newW = min.width;
                    }
                } else if (this.isResizeRight(this.currentResizing) && (newW += dx) < min.width) {
                    xx = min.width - newW;
                    newW = min.width;
                }
                if (this.isResizeTop(this.currentResizing)) {
                    newY += dy;
                    if ((newH -= dy) < min.height) {
                        yy = newH - min.height;
                        newY += yy;
                        newH = min.height;
                    }
                } else if (this.isResizeBottom(this.currentResizing) && (newH += dy) < min.height) {
                    yy = min.height - newH;
                    newH = min.height;
                }
                ProfilerPopup.this.window.setBounds(newX, newY, newW, newH);
                ProfilerPopup.this.content.setSize(newW, newH);
                this.dragX = x + xx;
                this.dragY = y + yy;
            }
        }

        private void updateResizing(MouseEvent e) {
            int newResizing = 0;
            int x = e.getX();
            int y = e.getY();
            if (this.isResizeLeft(ProfilerPopup.this.resizeMode) && x < 8 && x >= 0) {
                newResizing |= 2;
            } else if (this.isResizeRight(ProfilerPopup.this.resizeMode) && x > this.getWidth() - RESIZE_STRIPE && x < this.getWidth()) {
                newResizing |= 8;
            }
            if (this.isResizeTop(ProfilerPopup.this.resizeMode) && y < 8 && y >= 0) {
                newResizing |= 1;
            } else if (this.isResizeBottom(ProfilerPopup.this.resizeMode) && y > this.getHeight() - RESIZE_STRIPE && y < this.getHeight()) {
                newResizing |= 4;
            }
            this.currentResizing = newResizing;
            switch (this.currentResizing) {
                case 0: {
                    this.setCursor(Cursor.getDefaultCursor());
                    break;
                }
                case 1: {
                    this.setCursor(Cursor.getPredefinedCursor(8));
                    break;
                }
                case 2: {
                    this.setCursor(Cursor.getPredefinedCursor(10));
                    break;
                }
                case 4: {
                    this.setCursor(Cursor.getPredefinedCursor(9));
                    break;
                }
                case 8: {
                    this.setCursor(Cursor.getPredefinedCursor(11));
                    break;
                }
                case 3: {
                    this.setCursor(Cursor.getPredefinedCursor(6));
                    break;
                }
                case 6: {
                    this.setCursor(Cursor.getPredefinedCursor(4));
                    break;
                }
                case 12: {
                    this.setCursor(Cursor.getPredefinedCursor(5));
                    break;
                }
                case 9: {
                    this.setCursor(Cursor.getPredefinedCursor(7));
                }
            }
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            if (ProfilerPopup.this.resizeMode > 0) {
                g.setColor(UIUtils.getDisabledLineColor());
                switch (ProfilerPopup.this.resizeMode) {
                    case 3: {
                        g.drawLine(0, 5, 5, 0);
                        g.drawLine(0, 9, 9, 0);
                        break;
                    }
                    case 9: {
                        int w = this.getWidth();
                        g.drawLine(w - 6, 0, w, 6);
                        g.drawLine(w - 10, 0, w, 10);
                        break;
                    }
                    case 6: {
                        int h = this.getHeight();
                        g.drawLine(0, h - 6, 6, h);
                        g.drawLine(0, h - 10, 10, h);
                        break;
                    }
                    default: {
                        int w = this.getWidth();
                        int h = this.getHeight();
                        g.drawLine(w, h - 7, w - 7, h);
                        g.drawLine(w, h - 11, w - 11, h);
                    }
                }
            }
        }

        boolean isResizeTop(int mode) {
            return (mode & 1) != 0;
        }

        boolean isResizeLeft(int mode) {
            return (mode & 2) != 0;
        }

        boolean isResizeBottom(int mode) {
            return (mode & 4) != 0;
        }

        boolean isResizeRight(int mode) {
            return (mode & 8) != 0;
        }

        void installListeners() {
            ProfilerPopup.this.window.addWindowFocusListener(this);
            if (ProfilerPopup.this.owner != null) {
                ProfilerPopup.this.owner.addComponentListener(this);
            }
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this);
        }

        void uninstallListeners() {
            ProfilerPopup.this.window.removeWindowFocusListener(this);
            if (ProfilerPopup.this.owner != null) {
                ProfilerPopup.this.owner.removeComponentListener(this);
            }
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this);
        }

        @Override
        public void windowGainedFocus(WindowEvent e) {
            this.skippingEvents = false;
            this.gainedFocusTime = System.currentTimeMillis();
            if (DEBUG) {
                System.err.println(">>> Focus to popup gained");
            }
        }

        @Override
        public void windowLostFocus(WindowEvent e) {
            if (this.skippingEvents) {
                return;
            }
            if (e.getOppositeWindow() instanceof Dialog) {
                final Dialog d = (Dialog)e.getOppositeWindow();
                if (d != ProfilerPopup.this.owner && d.isModal()) {
                    this.skippingEvents = true;
                    if (DEBUG) {
                        System.err.println(">>> LOST TO DIALOG " + this.getString(d) + " owned by " + this.getString(d.getOwner()));
                    }
                    final JWindow win = ProfilerPopup.this.window;
                    final Component comp = ProfilerPopup.this.window.getMostRecentFocusOwner();
                    d.addWindowListener(new WindowAdapter(this){
                        final /* synthetic */ PopupPane this$1;
                        {
                            this.this$1 = this$1;
                        }

                        @Override
                        public void windowClosed(WindowEvent e) {
                            if (DEBUG) {
                                System.err.println(">>> BLOCKING DIALOG CLOSED " + this.this$1.getString(d));
                            }
                            win.requestFocus();
                            if (comp != null) {
                                comp.requestFocus();
                            }
                        }
                    });
                    return;
                }
            } else if (e.getOppositeWindow() == ProfilerPopup.this.owner) {
                long lostFocusTime = System.currentTimeMillis();
                if (DEBUG) {
                    System.err.println(">>> ### HIDDEN BY OWNER, gained focus before " + (lostFocusTime - this.gainedFocusTime));
                }
                if (lostFocusTime - this.gainedFocusTime < (long)IGNORE_OWNER_TIMEOUT) {
                    this.gainedFocusTime = 0L;
                    final JWindow win = ProfilerPopup.this.window;
                    final Component comp = ProfilerPopup.this.window.getMostRecentFocusOwner();
                    if (DEBUG) {
                        System.err.println(">>>   Requesting focus again to " + this.getString(comp));
                    }
                    SwingUtilities.invokeLater(new Runnable(){
                        final /* synthetic */ PopupPane this$1;
                        {
                            this.this$1 = this$1;
                        }

                        @Override
                        public void run() {
                            win.requestFocus();
                            if (comp != null) {
                                comp.requestFocus();
                            }
                            if (DEBUG) {
                                System.err.println(">>>       REQUESTED lazily");
                            }
                        }
                    });
                    return;
                }
            }
            ProfilerPopup.this.hide();
            if (DEBUG) {
                System.err.println(">>> Focus to popup lost to " + this.getString(e.getOppositeWindow()));
            }
        }

        private String getString(Component c) {
            if (c instanceof Dialog) {
                return "[dialog] " + ((Dialog)c).getTitle();
            }
            if (c instanceof Frame) {
                return "[frame] " + ((Frame)c).getTitle();
            }
            return c == null ? "null" : c.getClass().getName();
        }

        @Override
        public void componentResized(ComponentEvent e) {
            if (DEBUG) {
                System.err.println(">>> Closed by componentResized");
            }
            ProfilerPopup.this.hide();
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            Point newLocation = ProfilerPopup.this.owner.getLocationOnScreen();
            ProfilerPopup.this.window.setLocation(ProfilerPopup.this.window.getX() + (newLocation.x - ((ProfilerPopup)ProfilerPopup.this).ownerLocation.x), ProfilerPopup.this.window.getY() + (newLocation.y - ((ProfilerPopup)ProfilerPopup.this).ownerLocation.y));
            ProfilerPopup.this.ownerLocation = newLocation;
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            if (DEBUG) {
                System.err.println(">>> Closed by componentHidden");
            }
            ProfilerPopup.this.hide();
        }

        @Override
        public boolean dispatchKeyEvent(KeyEvent e) {
            if (this.skippingEvents || e.isConsumed()) {
                return false;
            }
            if (e.getID() == 401 && e.getKeyCode() == 27 && SwingUtilities.getRootPane(this) != e.getSource()) {
                e.consume();
                if (DEBUG) {
                    System.err.println(">>> Closed by ESC");
                }
                ProfilerPopup.this.hide();
                return true;
            }
            return false;
        }
    }

    public static abstract class Listener {
        protected void popupShown() {
        }

        protected void popupHidden() {
        }
    }

    private static class PopupFocusTraversalPolicy
    extends FocusTraversalPolicy {
        private PopupFocusTraversalPolicy() {
        }

        @Override
        public Component getComponentAfter(Container aContainer, Component aComponent) {
            List<Component> l = PopupFocusTraversalPolicy.components(aContainer);
            int i = l.indexOf(aComponent);
            return i == -1 || i == l.size() - 1 ? null : l.get(i + 1);
        }

        @Override
        public Component getComponentBefore(Container aContainer, Component aComponent) {
            List<Component> l = PopupFocusTraversalPolicy.components(aContainer);
            int i = l.indexOf(aComponent);
            return i == -1 || i == 0 ? null : l.get(i - 1);
        }

        @Override
        public Component getFirstComponent(Container aContainer) {
            List<Component> l = PopupFocusTraversalPolicy.components(aContainer);
            return l.isEmpty() ? null : l.get(0);
        }

        @Override
        public Component getLastComponent(Container aContainer) {
            List<Component> l = PopupFocusTraversalPolicy.components(aContainer);
            return l.isEmpty() ? null : l.get(l.size() - 1);
        }

        @Override
        public Component getDefaultComponent(Container aContainer) {
            ButtonModel bm;
            Component c = this.getFirstComponent(aContainer);
            if (c instanceof AbstractButton && (bm = ((AbstractButton)c).getModel()) instanceof DefaultButtonModel) {
                Enumeration<AbstractButton> en;
                ButtonGroup bg = ((DefaultButtonModel)bm).getGroup();
                Enumeration<AbstractButton> enumeration = en = bg == null ? null : bg.getElements();
                while (en != null && en.hasMoreElements()) {
                    AbstractButton ab = en.nextElement();
                    if (!ab.isSelected()) continue;
                    return ab;
                }
            }
            return c;
        }

        private static List<Component> components(Container aContainer) {
            ArrayList<Component> l = new ArrayList<Component>();
            for (int i = 0; i < aContainer.getComponentCount(); ++i) {
                Component c = aContainer.getComponent(i);
                if (c instanceof JPanel || c instanceof JToolBar) {
                    l.addAll(PopupFocusTraversalPolicy.components((Container)c));
                    continue;
                }
                if (c instanceof JScrollPane) {
                    l.addAll(PopupFocusTraversalPolicy.components(((JScrollPane)c).getViewport()));
                    continue;
                }
                if (!PopupFocusTraversalPolicy.focusable(c)) continue;
                l.add(c);
            }
            return l;
        }

        private static boolean focusable(Component c) {
            if (c instanceof JLabel || c instanceof Box.Filler) {
                return false;
            }
            return c.isVisible() && c.isEnabled() && c.isFocusable();
        }
    }
}

