/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.derby;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.db.explorer.ConnectionListener;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.modules.derby.DerbyDatabasesImpl;
import org.netbeans.modules.derby.RegisterDerby;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class ConnectDatabaseAction
extends NodeAction {
    private static final Logger LOGGER = Logger.getLogger(ConnectDatabaseAction.class.getName());

    public ConnectDatabaseAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    protected boolean asynchronous() {
        return false;
    }

    public String getName() {
        return NbBundle.getMessage(ConnectDatabaseAction.class, (String)"ConnectDatabaseAction_ConnectAction");
    }

    public boolean enable(Node[] activatedNodes) {
        return activatedNodes != null && activatedNodes.length == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performAction(Node[] activatedNodes) {
        block7: {
            if (activatedNodes == null || activatedNodes.length == 0) {
                return;
            }
            Node n = activatedNodes[0];
            String dbname = n.getName();
            List<DatabaseConnection> conns = DerbyDatabasesImpl.getDefault().findDatabaseConnections(dbname);
            try {
                if (conns.isEmpty()) {
                    ArrayList<JDBCDriver> drivers = new ArrayList<JDBCDriver>();
                    drivers.addAll(Arrays.asList(JDBCDriverManager.getDefault().getDrivers("org.apache.derby.jdbc.ClientDriver")));
                    drivers.addAll(Arrays.asList(JDBCDriverManager.getDefault().getDrivers("org.apache.derby.client.ClientAutoloadedDriver")));
                    if (drivers.isEmpty()) {
                        this.showDriverNotFoundDialog();
                        return;
                    }
                    final DatabaseConnection dbconn = DatabaseConnection.create((JDBCDriver)((JDBCDriver)drivers.get(0)), (String)("jdbc:derby://localhost:" + RegisterDerby.getDefault().getPort() + "/" + dbname), (String)DerbyDatabasesImpl.getDefault().getUser(dbname), (String)DerbyDatabasesImpl.getDefault().getSchema(dbname), (String)DerbyDatabasesImpl.getDefault().getPassword(dbname), (boolean)true);
                    ConnectionManager.getDefault().addConnectionListener(new ConnectionListener(){
                        final /* synthetic */ ConnectDatabaseAction this$0;
                        {
                            this.this$0 = this$0;
                        }

                        public void connectionsChanged() {
                            ConnectionManager.getDefault().showConnectionDialog(dbconn);
                            ConnectionManager.getDefault().removeConnectionListener((ConnectionListener)this);
                        }
                    });
                    ConnectionManager.getDefault().addConnection(dbconn);
                    break block7;
                }
                ConnectionManager.getDefault().showConnectionDialog(conns.get(0));
            }
            catch (DatabaseException dbe) {
                LOGGER.log(Level.INFO, dbe.getMessage(), dbe);
            }
        }
    }

    private void showDriverNotFoundDialog() {
        String msg = NbBundle.getMessage(ConnectDatabaseAction.class, (String)"ERR_DerbyDriverNotFoundConfigure", (Object)"Java DB (Network)");
        NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)msg, 0);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
        if (NotifyDescriptor.YES_OPTION.equals(nd.getValue())) {
            JDBCDriverManager.getDefault().showAddDriverDialog();
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ConnectDatabaseAction.class);
    }
}

