/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.webkit.tooling.networkmonitor;

import java.lang.ref.WeakReference;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.webkit.debugging.api.network.Network;
import org.netbeans.modules.web.webkit.tooling.networkmonitor.DependentFileQueryImpl;
import org.netbeans.modules.web.webkit.tooling.networkmonitor.Model;
import org.netbeans.modules.web.webkit.tooling.networkmonitor.NetworkMonitorTopComponent;
import org.openide.util.Lookup;
import org.openide.windows.TopComponent;

public class NetworkMonitor
implements Network.Listener {
    private static WeakReference<NetworkMonitor> lastNetworkMonitor = new WeakReference<Object>(null);
    private final Model model;
    private final Project project;
    private volatile NetworkMonitorTopComponent component;
    private volatile boolean debuggingSession;

    private NetworkMonitor(Lookup projectContext, NetworkMonitorTopComponent comp, boolean debuggingSession) {
        this.component = comp;
        this.model = new Model(projectContext);
        this.debuggingSession = debuggingSession;
        this.project = (Project)projectContext.lookup(Project.class);
        lastNetworkMonitor = new WeakReference<NetworkMonitor>(this);
    }

    boolean isConnected() {
        return this.debuggingSession;
    }

    void open() {
        final boolean show = NetworkMonitorTopComponent.canReopenNetworkComponent();
        if (show) {
            this.model.activate();
        }
        SwingUtilities.invokeLater(new Runnable(){
            final /* synthetic */ NetworkMonitor this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                if (this.this$0.component == null) {
                    this.this$0.component = new NetworkMonitorTopComponent(this.this$0.model, this.this$0.isConnected());
                    if (show) {
                        this.this$0.component.open();
                        this.this$0.component.requestActive();
                    }
                } else {
                    this.this$0.component.setModel(this.this$0.model, this.this$0.isConnected());
                }
            }
        });
    }

    private void resetComponent() {
        this.component = null;
    }

    public static NetworkMonitor createNetworkMonitor(Lookup projectContext) {
        NetworkMonitorTopComponent component = NetworkMonitor.findNetworkMonitorTC();
        NetworkMonitor nm = new NetworkMonitor(projectContext, component, true);
        nm.open();
        return nm;
    }

    public static void reopenNetworkMonitor() {
        NetworkMonitorTopComponent component = NetworkMonitor.findNetworkMonitorTC();
        if (component != null) {
            component.requestActive();
        } else {
            NetworkMonitor nm = (NetworkMonitor)lastNetworkMonitor.get();
            if (nm != null) {
                nm.resetComponent();
            } else {
                nm = new NetworkMonitor(Lookup.EMPTY, null, false);
            }
            nm.open();
        }
    }

    private static NetworkMonitorTopComponent findNetworkMonitorTC() {
        for (TopComponent tc : TopComponent.getRegistry().getOpened()) {
            if (!(tc instanceof NetworkMonitorTopComponent)) continue;
            return (NetworkMonitorTopComponent)tc;
        }
        return null;
    }

    public void close() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NetworkMonitorTopComponent cmp = NetworkMonitor.this.component;
                if (cmp != null && cmp.isOpened()) {
                    cmp.close();
                    NetworkMonitorTopComponent.setReopenNetworkComponent(true);
                }
            }
        });
        this.debuggingSession = false;
    }

    public void networkRequest(Network.Request request) {
        this.model.add(request);
        DependentFileQueryImpl.networkRequest(this.project, request);
    }

    public void webSocketRequest(Network.WebSocketRequest request) {
        this.model.add(request);
    }
}

