/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.hints.pom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.text.Document;
import org.netbeans.api.project.Project;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.maven.hints.pom.ReleaseVersionErrorCustomizer;
import org.netbeans.modules.maven.hints.pom.spi.Configuration;
import org.netbeans.modules.maven.hints.pom.spi.POMErrorFixProvider;
import org.netbeans.modules.maven.model.pom.Build;
import org.netbeans.modules.maven.model.pom.BuildBase;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Plugin;
import org.netbeans.modules.maven.model.pom.PluginManagement;
import org.netbeans.modules.maven.model.pom.Profile;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.text.Line;
import org.openide.util.NbBundle;

public class ReleaseVersionError
implements POMErrorFixProvider {
    private final Configuration configuration = new Configuration("ReleaseVersionError", NbBundle.getMessage(ReleaseVersionError.class, (String)"TIT_ReleaseLatestVersion"), NbBundle.getMessage(ReleaseVersionError.class, (String)"DESC_ReleaseLatestVersion"), true, Configuration.HintSeverity.WARNING);
    static final String PROP_RELEASE = "release";
    static final String PROP_LATEST = "latest";
    static final String PROP_SNAPSHOT = "snapshot";
    private JComponent component;

    @Override
    public List<ErrorDescription> getErrorsForDocument(POMModel model, Project prj) {
        List profiles;
        assert (model != null);
        ArrayList<ErrorDescription> toRet = new ArrayList<ErrorDescription>();
        boolean release = this.getConfiguration().getPreferences().getBoolean(PROP_RELEASE, true);
        boolean latest = this.getConfiguration().getPreferences().getBoolean(PROP_LATEST, true);
        boolean snapshot = this.getConfiguration().getPreferences().getBoolean(PROP_SNAPSHOT, false);
        Build bld = model.getProject().getBuild();
        if (bld != null) {
            this.checkPluginList(bld.getPlugins(), model, toRet, release, latest, snapshot);
            PluginManagement pm = bld.getPluginManagement();
            if (pm != null) {
                this.checkPluginList(pm.getPlugins(), model, toRet, release, latest, snapshot);
            }
        }
        if ((profiles = model.getProject().getProfiles()) != null) {
            for (Profile prof : profiles) {
                BuildBase base = prof.getBuildBase();
                if (base == null) continue;
                this.checkPluginList(base.getPlugins(), model, toRet, release, latest, snapshot);
                PluginManagement pm = base.getPluginManagement();
                if (pm == null) continue;
                this.checkPluginList(pm.getPlugins(), model, toRet, release, latest, snapshot);
            }
        }
        return toRet;
    }

    private void checkPluginList(List<Plugin> plugins, POMModel model, List<ErrorDescription> toRet, boolean release, boolean latest, boolean snapshot) {
        if (plugins != null) {
            for (Plugin plg : plugins) {
                String ver = plg.getVersion();
                if (ver == null || !(release && "RELEASE".equals(ver) || latest && "LATEST".equals(ver)) && (!snapshot || !ver.endsWith("SNAPSHOT"))) continue;
                int position = plg.findChildElementPosition(model.getPOMQNames().VERSION.getQName());
                Line line = NbEditorUtilities.getLine((Document)model.getBaseDocument(), (int)position, (boolean)false);
                toRet.add(ErrorDescriptionFactory.createErrorDescription((Severity)this.configuration.getSeverity(this.configuration.getPreferences()).toEditorSeverity(), (String)NbBundle.getMessage(ReleaseVersionError.class, (String)"DESC_RELEASE_VERSION"), Collections.emptyList(), (Document)model.getBaseDocument(), (int)(line.getLineNumber() + 1)));
            }
        }
    }

    @Override
    public JComponent getCustomizer(Preferences preferences) {
        if (this.component == null) {
            this.component = new ReleaseVersionErrorCustomizer(preferences);
        }
        return this.component;
    }

    @Override
    public String getSavedValue(JComponent customCustomizer, String key) {
        return ((ReleaseVersionErrorCustomizer)customCustomizer).getSavedValue(key);
    }

    @Override
    public void cancel() {
        this.component = null;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }
}

