/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import java.util.HashSet;
import java.util.Map;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.LaunchingDICookie;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.SessionProvider;
import org.openide.util.NbBundle;

public class LaunchingSessionProvider
extends SessionProvider {
    private ContextProvider contextProvider;
    private LaunchingDICookie launchingCookie;

    public LaunchingSessionProvider(ContextProvider contextProvider) {
        this.contextProvider = contextProvider;
        this.launchingCookie = (LaunchingDICookie)contextProvider.lookupFirst(null, LaunchingDICookie.class);
    }

    public String getSessionName() {
        String processName;
        Map arguments = (Map)this.contextProvider.lookupFirst(null, Map.class);
        if (arguments != null && (processName = (String)arguments.get("name")) != null) {
            return LaunchingSessionProvider.findUnique(processName);
        }
        String sessionName = this.launchingCookie.getClassName();
        int i = sessionName.lastIndexOf(46);
        if (i >= 0) {
            sessionName = sessionName.substring(i + 1);
        }
        return LaunchingSessionProvider.findUnique(sessionName);
    }

    public String getLocationName() {
        return NbBundle.getMessage(LaunchingSessionProvider.class, (String)"CTL_Localhost");
    }

    public String getTypeID() {
        return "netbeans-JPDASession";
    }

    public Object[] getServices() {
        return new Object[0];
    }

    static String findUnique(String sessionName) {
        int i;
        DebuggerManager cd = DebuggerManager.getDebuggerManager();
        Session[] ds = cd.getSessions();
        int k = ds.length;
        HashSet<Integer> m = new HashSet<Integer>();
        for (i = 0; i < k; ++i) {
            String pn = ds[i].getName();
            if (!pn.startsWith(sessionName)) continue;
            if (pn.equals(sessionName)) {
                m.add(0);
                continue;
            }
            try {
                int t = Integer.parseInt(pn.substring(sessionName.length() + 3));
                m.add(t);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        k = m.size();
        for (i = 0; i < k && m.contains(i); ++i) {
        }
        if (i > 0) {
            sessionName = sessionName + " - " + i;
        }
        return sessionName;
    }
}

