/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.debug.variablesfilterring;

import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.modules.web.debug.variablesfilterring.JSPVariablesFilter;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ExtendedNodeModel;
import org.netbeans.spi.viewmodel.ExtendedNodeModelFilter;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.datatransfer.PasteType;

public class JSPVariablesNodeModelFilter
implements ExtendedNodeModelFilter {
    private static final int TO_STRING_LENGTH_LIMIT = 10000;
    private RequestProcessor evaluationRP;
    private final Map<ObjectVariable, String> shortDescriptionMap = new IdentityHashMap<ObjectVariable, String>();
    private final Collection modelListeners = new HashSet();

    public JSPVariablesNodeModelFilter(ContextProvider lookupProvider) {
        this.evaluationRP = (RequestProcessor)lookupProvider.lookupFirst(null, RequestProcessor.class);
    }

    public String getDisplayName(NodeModel original, Object node) throws UnknownTypeException {
        String dn = "";
        if (node instanceof JSPVariablesFilter.ImplicitLocals) {
            dn = NbBundle.getMessage(JSPVariablesFilter.class, (String)"LBL_IMPLICIT_LOCALS");
        } else if (node instanceof JSPVariablesFilter.AttributeMap) {
            String resIcon = "";
            String ownerName = ((JSPVariablesFilter.AttributeMap)node).getOwnerName();
            if (ownerName.equals("request")) {
                resIcon = "LBL_REQUEST_ATTRIBUTES";
            } else if (ownerName.equals("session")) {
                resIcon = "LBL_SESSION_ATTRIBUTES";
            } else if (ownerName.equals("application")) {
                resIcon = "LBL_APPLICATION_ATTRIBUTES";
            }
            dn = NbBundle.getMessage(JSPVariablesFilter.class, (String)resIcon);
        } else {
            dn = node instanceof JSPVariablesFilter.AttributeMap.Attribute ? ((JSPVariablesFilter.AttributeMap.Attribute)node).getName() : original.getDisplayName(node);
        }
        return dn;
    }

    public String getIconBase(NodeModel original, Object node) throws UnknownTypeException {
        throw new IllegalStateException("getIconBaseWithExtension should be always called instead");
    }

    public String getIconBaseWithExtension(ExtendedNodeModel original, Object node) throws UnknownTypeException {
        String ib = "";
        ib = node instanceof JSPVariablesFilter.ImplicitLocals ? NbBundle.getMessage(JSPVariablesFilter.class, (String)"RES_IMPLICIT_LOCALS_GROUP") : (node instanceof JSPVariablesFilter.AttributeMap ? NbBundle.getMessage(JSPVariablesFilter.class, (String)"RES_ATTRIBUTES_GROUP") : (node instanceof JSPVariablesFilter.AttributeMap.Attribute ? NbBundle.getMessage(JSPVariablesFilter.class, (String)"RES_ATTRIBUTE_VALUE") : original.getIconBaseWithExtension(node)));
        return ib;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getShortDescription(NodeModel original, Object node) throws UnknownTypeException {
        String sd = "";
        if (node instanceof JSPVariablesFilter.ImplicitLocals) {
            sd = NbBundle.getMessage(JSPVariablesFilter.class, (String)"TLT_IMPLICIT_LOCALS");
        } else if (node instanceof JSPVariablesFilter.AttributeMap) {
            String tltAttributes;
            String ownerName = ((JSPVariablesFilter.AttributeMap)node).getOwnerName();
            if (ownerName.equals("request")) {
                tltAttributes = "TLT_REQUEST_ATTRIBUTES";
            } else if (ownerName.equals("session")) {
                tltAttributes = "TLT_SESSION_ATTRIBUTES";
            } else if (ownerName.equals("application")) {
                tltAttributes = "TLT_APPLICATION_ATTRIBUTES";
            } else {
                throw new JSPVariablesFilter.AttributeMap.UnknownOwnerNameException(ownerName);
            }
            sd = NbBundle.getMessage(JSPVariablesFilter.class, (String)tltAttributes);
        } else if (node instanceof JSPVariablesFilter.AttributeMap.Attribute) {
            Variable attributeValue = ((JSPVariablesFilter.AttributeMap.Attribute)node).getValue();
            String type = attributeValue.getType();
            String stringValue = attributeValue.getValue();
            if (attributeValue instanceof ObjectVariable) {
                final ObjectVariable ov = (ObjectVariable)attributeValue;
                Map<ObjectVariable, String> map = this.shortDescriptionMap;
                synchronized (map) {
                    String shortDescription = this.shortDescriptionMap.remove(ov);
                    if (shortDescription != null) {
                        return "(" + type + ") " + shortDescription;
                    }
                }
                this.evaluationRP.post(new Runnable(){
                    final /* synthetic */ JSPVariablesNodeModelFilter this$0;
                    {
                        this.this$0 = this$0;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        String shortDescription = this.this$0.getShortDescriptionSynch(ov);
                        if (shortDescription != null && !"".equals(shortDescription)) {
                            Map map = this.this$0.shortDescriptionMap;
                            synchronized (map) {
                                this.this$0.shortDescriptionMap.put(ov, shortDescription);
                            }
                            this.this$0.fireModelChange((ModelEvent)new ModelEvent.NodeChanged((Object)this.this$0, (Object)ov, 4));
                        }
                    }
                });
                return "";
            }
            sd = "(" + type + ") " + stringValue;
        } else {
            sd = original.getShortDescription(node);
        }
        return sd;
    }

    private static String getLimitedToString(ObjectVariable v) throws InvalidExpressionException {
        String toString = null;
        try {
            Method toStringMethod = v.getClass().getMethod("getToStringValue", Integer.TYPE);
            toStringMethod.setAccessible(true);
            toString = (String)toStringMethod.invoke((Object)v, 10000);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (toString == null) {
            toString = v.getToStringValue();
        }
        return toString;
    }

    private String getShortDescriptionSynch(ObjectVariable v) {
        try {
            return JSPVariablesNodeModelFilter.getLimitedToString(v);
        }
        catch (InvalidExpressionException ex) {
            return ex.getLocalizedMessage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModelListener(ModelListener l) {
        Collection collection = this.modelListeners;
        synchronized (collection) {
            this.modelListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModelListener(ModelListener l) {
        Collection collection = this.modelListeners;
        synchronized (collection) {
            this.modelListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireModelChange(ModelEvent me) {
        Object[] listeners;
        Collection collection = this.modelListeners;
        synchronized (collection) {
            listeners = this.modelListeners.toArray();
        }
        for (int i = 0; i < listeners.length; ++i) {
            ((ModelListener)listeners[i]).modelChanged(me);
        }
    }

    public boolean canRename(ExtendedNodeModel original, Object node) throws UnknownTypeException {
        return false;
    }

    public boolean canCopy(ExtendedNodeModel original, Object node) throws UnknownTypeException {
        return false;
    }

    public boolean canCut(ExtendedNodeModel original, Object node) throws UnknownTypeException {
        return false;
    }

    public Transferable clipboardCopy(ExtendedNodeModel original, Object node) throws IOException, UnknownTypeException {
        throw new UnsupportedOperationException("not supported");
    }

    public Transferable clipboardCut(ExtendedNodeModel original, Object node) throws IOException, UnknownTypeException {
        throw new UnsupportedOperationException("not supported");
    }

    public PasteType[] getPasteTypes(ExtendedNodeModel original, Object node, Transferable t) throws UnknownTypeException {
        return new PasteType[0];
    }

    public void setName(ExtendedNodeModel original, Object node, String name) throws UnknownTypeException {
    }
}

